/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.android.tools.idea.model.AndroidManifestIndexQueryUtils;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.text.StringKt;
import java.io.Reader;
import java.io.StringReader;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\f\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a!\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"1\u0010\u0004\u001a%\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0007 \b*\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "PACKAGE_NAME_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getPackageName", "module", "Lcom/intellij/openapi/module/Module;", "getPackageNameByParsingPrimaryManifest", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "getPackageNameFromIndex", "getText", "manifestFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "readPackageNameFromManifest", "runCancellableReadAction", "T", "computable", "Lcom/intellij/openapi/util/Computable;", "(Lcom/intellij/openapi/util/Computable;)Ljava/lang/Object;", "intellij.android.core"})
public final class DefaultModuleSystemKt {
    @NotNull
    private static final Key<CachedValue<String>> PACKAGE_NAME_KEY;

    private static final Logger getLOG() {
        Logger logger2 = Logger.getInstance((String)"DefaultModuleSystem.kt");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(\"DefaultModuleSystem.kt\")");
        return logger2;
    }

    @Nullable
    public static final String getPackageName(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module2);
        if (androidFacet == null) {
            return null;
        }
        AndroidFacet facet2 = androidFacet;
        ProgressManager.checkCanceled();
        String string = (String)DumbService.getInstance((Project)module2.getProject()).runReadActionInSmartMode(new Computable(facet2){
            final /* synthetic */ AndroidFacet $facet;
            {
                this.$facet = $facet;
            }

            @Nullable
            public final String compute() {
                return DefaultModuleSystemKt.access$getPackageNameFromIndex(this.$facet);
            }
        });
        if (string == null) {
            string = DefaultModuleSystemKt.getPackageNameByParsingPrimaryManifest(facet2);
        }
        return string;
    }

    private static final String getPackageNameFromIndex(AndroidFacet facet2) {
        String string;
        if (DumbService.isDumb((Project)facet2.getModule().getProject())) {
            return null;
        }
        try {
            string = AndroidManifestIndexQueryUtils.queryPackageNameFromManifestIndex(facet2);
        }
        catch (IndexNotReadyException e) {
            DefaultModuleSystemKt.getLOG().debug((Throwable)e);
            string = null;
        }
        return string;
    }

    private static final String getPackageNameByParsingPrimaryManifest(AndroidFacet facet2) {
        VirtualFile virtualFile = SourceProviderManager.Companion.getInstance(facet2).getMainManifestFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile manifestFile = virtualFile;
        CachedValue cachedValue2 = CachedValuesManager.getManager((Project)facet2.getModule().getProject()).createCachedValue(new CachedValueProvider(manifestFile){
            final /* synthetic */ VirtualFile $manifestFile;
            {
                this.$manifestFile = $manifestFile;
            }

            @Nullable
            public final CachedValueProvider.Result<String> compute() {
                String packageName2 = DefaultModuleSystemKt.access$readPackageNameFromManifest(this.$manifestFile);
                Object[] objectArray = new Object[]{this.$manifestFile};
                return CachedValueProvider.Result.create((Object)packageName2, (Object[])objectArray);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)cachedValue2, (String)"manifestFile = SourcePro\u2026geName, manifestFile)\n  }");
        CachedValue cachedValue3 = cachedValue2;
        return (String)((CachedValue)facet2.putUserDataIfAbsent(PACKAGE_NAME_KEY, (Object)cachedValue3)).getValue();
    }

    private static final String readPackageNameFromManifest(VirtualFile manifestFile) {
        try {
            KXmlParser kXmlParser;
            KXmlParser $this$readPackageNameFromManifest_u24lambda_u240 = kXmlParser = new KXmlParser();
            boolean bl = false;
            $this$readPackageNameFromManifest_u24lambda_u240.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            $this$readPackageNameFromManifest_u24lambda_u240.setInput((Reader)new StringReader((String)DefaultModuleSystemKt.runCancellableReadAction((Computable)new Computable(manifestFile){
                final /* synthetic */ VirtualFile $manifestFile;
                {
                    this.$manifestFile = $manifestFile;
                }

                public final String compute() {
                    return DefaultModuleSystemKt.access$getText(this.$manifestFile);
                }
            })));
            KXmlParser parser2 = kXmlParser;
            if (parser2.nextTag() == 2) {
                return StringKt.nullize((String)parser2.getAttributeValue(null, "package"), (boolean)true);
            }
        }
        catch (Exception e) {
            DefaultModuleSystemKt.getLOG().warn((Throwable)e);
        }
        return null;
    }

    private static final String getText(VirtualFile manifestFile) {
        Document document2 = FileDocumentManager.getInstance().getCachedDocument(manifestFile);
        if (document2 == null) {
            return ((Object)LoadTextUtil.getTextByBinaryPresentation((byte[])manifestFile.contentsToByteArray(), (VirtualFile)manifestFile)).toString();
        }
        Document document3 = document2;
        String string = document3.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.text");
        return string;
    }

    private static final <T> T runCancellableReadAction(Computable<T> computable) {
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (T)computable.compute();
        }
        return (T)ReadAction.nonBlocking((Callable)new Callable(computable){
            final /* synthetic */ Computable<T> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final T call() {
                return (T)this.$tmp0.compute();
            }
        }).executeSynchronously();
    }

    public static final /* synthetic */ String access$getPackageNameFromIndex(AndroidFacet facet2) {
        return DefaultModuleSystemKt.getPackageNameFromIndex(facet2);
    }

    public static final /* synthetic */ String access$readPackageNameFromManifest(VirtualFile manifestFile) {
        return DefaultModuleSystemKt.readPackageNameFromManifest(manifestFile);
    }

    public static final /* synthetic */ String access$getText(VirtualFile manifestFile) {
        return DefaultModuleSystemKt.getText(manifestFile);
    }

    static {
        Key key = Key.create((String)"main.manifest.package.name");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create<CachedValue<Strin\u2026n.manifest.package.name\")");
        PACKAGE_NAME_KEY = key;
    }
}

