/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.ui.CustomNotificationListener;
import com.google.common.base.Objects;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidNotification {
    public static final NotificationGroup BALLOON_GROUP = NotificationGroup.balloonGroup((String)"Android Notification Group", (PluginId)PluginId.getId((String)"org.jetbrains.android"));
    public static final NotificationGroup LOG_ONLY_GROUP = NotificationGroup.logOnlyGroup((String)"Android Notification Log-Only Group", (PluginId)PluginId.getId((String)"org.jetbrains.android"));
    private static final Key<JFrame> NOTIFICATION_DESTINATION_FALLBACK_KEY = Key.create((String)"NOTIFICATION_DESTINATION_FALLBACK");
    @Nullable
    private Notification myNotification;
    @NotNull
    private final Project myProject;

    public void showProgressBalloon(@NotNull String message2, @NotNull MessageType type) {
        UIUtil.invokeLaterIfNeeded(() -> {
            StatusBarEx statusBar;
            IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(this.myProject);
            if (ideFrame != null && (statusBar = (StatusBarEx)ideFrame.getStatusBar()) != null) {
                statusBar.notifyProgressByBalloon(type, message2);
            }
        });
    }

    @NotNull
    public static AndroidNotification getInstance(@NotNull Project project) {
        return (AndroidNotification)project.getService(AndroidNotification.class);
    }

    public AndroidNotification(@NotNull Project project) {
        this.myProject = project;
    }

    public void addLogEvent(@NotNull String title, @NotNull String text2, @NotNull NotificationType type) {
        this.showNotification(title, text2, type, LOG_ONLY_GROUP, null);
    }

    public void showBalloon(@NotNull String title, @NotNull String text2, @NotNull NotificationType type) {
        this.showBalloon(title, text2, type, (NotificationListener)null);
    }

    public void showBalloon(@NotNull String title, @NotNull String text2, @NotNull NotificationType type, NotificationHyperlink ... hyperlinks) {
        this.showBalloon(title, text2, type, BALLOON_GROUP, hyperlinks);
    }

    public void showBalloon(@NotNull String title, @NotNull String text2, @NotNull NotificationType type, @NotNull NotificationGroup group2, NotificationHyperlink ... hyperlinks) {
        this.showBalloon(title, text2, type, group2, true, hyperlinks);
    }

    public void showBalloon(@NotNull String title, @NotNull String text2, @NotNull NotificationType type, @NotNull NotificationGroup group2, boolean newLineForLinkText, NotificationHyperlink ... hyperlinks) {
        CustomNotificationListener notificationListener = new CustomNotificationListener(this.myProject, hyperlinks);
        String newText = AndroidNotification.addHyperlinksToText(text2, newLineForLinkText, hyperlinks);
        this.showNotification(title, newText, type, group2, (NotificationListener)notificationListener);
    }

    @NotNull
    private static String addHyperlinksToText(@NotNull String text2, boolean newLineForLinkText, NotificationHyperlink ... hyperlinks) {
        if (hyperlinks.length == 0) {
            return text2;
        }
        StringBuilder b = new StringBuilder();
        b.append(text2);
        for (NotificationHyperlink hyperlink2 : hyperlinks) {
            if (newLineForLinkText) {
                b.append("<br>\n");
            }
            b.append(hyperlink2.toHtml());
        }
        return b.toString();
    }

    public void showBalloon(@NotNull String title, @NotNull String text2, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        this.showNotification(title, text2, type, BALLOON_GROUP, listener2);
    }

    private void showNotification(@NotNull String title, @NotNull String text2, @NotNull NotificationType type, @NotNull NotificationGroup group2, @Nullable NotificationListener listener2) {
        Notification notification = group2.createNotification(title, text2, type);
        if (listener2 != null) {
            notification.setListener(listener2);
        }
        Runnable notificationTask = () -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myProject.isOpen()) {
                boolean similar;
                Notification old2 = this.myNotification;
                if (old2 != null && (similar = Objects.equal((Object)notification.getContent(), (Object)old2.getContent()))) {
                    old2.expire();
                }
                this.myNotification = notification;
                notification.notify(this.myProject);
            } else {
                JFrame jFrame = AndroidNotification.getFallbackNotificationDestination(this.myProject);
                if (jFrame == null) {
                    return;
                }
                AndroidNotification.showNotification(this.myProject, notification, jFrame);
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            notificationTask.run();
        } else {
            application.invokeLater(notificationTask);
        }
    }

    public static void setFallbackNotificationDestination(final Project project, final JFrame jFrame) {
        project.putUserData(NOTIFICATION_DESTINATION_FALLBACK_KEY, (Object)jFrame);
        Notifications subscriber2 = new Notifications(){

            public void notify(@NotNull Notification notification) {
                AndroidNotification.showNotification(project, notification, jFrame);
            }
        };
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(Notifications.TOPIC, (Object)subscriber2);
        project.getMessageBus().connect().subscribe(Notifications.TOPIC, (Object)subscriber2);
    }

    private static void showNotification(Project project, Notification notification, final JFrame jFrame) {
        Balloon balloon = NotificationsManagerImpl.createBalloon((JComponent)jFrame.getRootPane(), (Notification)notification, (boolean)false, (boolean)true, (Ref)BalloonLayoutData.fullContent(), (Disposable)project);
        balloon.show((PositionTracker)new PositionTracker<Balloon>((Component)jFrame.getRootPane()){

            public RelativePoint recalculateLocation(@NotNull Balloon balloon) {
                Dimension jFrameSize = jFrame.getSize();
                Dimension balloonSize = balloon.getPreferredSize();
                return new RelativePoint((Component)jFrame, new Point(jFrameSize.width - balloonSize.width / 2, jFrameSize.height - balloonSize.height / 2));
            }
        }, Balloon.Position.above);
    }

    @Nullable
    private static JFrame getFallbackNotificationDestination(Project project) {
        return (JFrame)project.getUserData(NOTIFICATION_DESTINATION_FALLBACK_KEY);
    }

    @Nullable
    public Notification getNotification() {
        return this.myNotification;
    }
}

