/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.profilingconfig;

import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.android.tools.profilers.cpu.config.ArtInstrumentedConfiguration;
import com.android.tools.profilers.cpu.config.ArtSampledConfiguration;
import com.android.tools.profilers.cpu.config.AtraceConfiguration;
import com.android.tools.profilers.cpu.config.PerfettoConfiguration;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.cpu.config.SimpleperfConfiguration;
import com.android.tools.profilers.cpu.config.UnspecifiedConfiguration;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;

public class CpuProfilerConfigConverter {
    private CpuProfilerConfigConverter() {
    }

    public static CpuProfilerConfig fromProfilingConfiguration(ProfilingConfiguration config2) {
        CpuProfilerConfig cpuProfilerConfig = null;
        switch (config2.getTraceType()) {
            case ART: {
                if (config2 instanceof ArtSampledConfiguration) {
                    ArtSampledConfiguration artSampledConfiguration = (ArtSampledConfiguration)config2;
                    cpuProfilerConfig = new CpuProfilerConfig(artSampledConfiguration.getName(), CpuProfilerConfig.Technology.SAMPLED_JAVA);
                    cpuProfilerConfig.setSamplingIntervalUs(artSampledConfiguration.getProfilingSamplingIntervalUs());
                    cpuProfilerConfig.setBufferSizeMb(artSampledConfiguration.getProfilingBufferSizeInMb());
                    break;
                }
                ArtInstrumentedConfiguration artInstrumentedConfiguration = (ArtInstrumentedConfiguration)config2;
                cpuProfilerConfig = new CpuProfilerConfig(artInstrumentedConfiguration.getName(), CpuProfilerConfig.Technology.INSTRUMENTED_JAVA);
                cpuProfilerConfig.setBufferSizeMb(artInstrumentedConfiguration.getProfilingBufferSizeInMb());
                break;
            }
            case SIMPLEPERF: {
                SimpleperfConfiguration simpleperfConfiguration = (SimpleperfConfiguration)config2;
                cpuProfilerConfig = new CpuProfilerConfig(simpleperfConfiguration.getName(), CpuProfilerConfig.Technology.SAMPLED_NATIVE);
                cpuProfilerConfig.setSamplingIntervalUs(simpleperfConfiguration.getProfilingSamplingIntervalUs());
                break;
            }
            case ATRACE: {
                AtraceConfiguration atraceConfiguration = (AtraceConfiguration)config2;
                cpuProfilerConfig = new CpuProfilerConfig(atraceConfiguration.getName(), CpuProfilerConfig.Technology.SYSTEM_TRACE);
                cpuProfilerConfig.setBufferSizeMb(4);
                break;
            }
            case PERFETTO: {
                PerfettoConfiguration perfettoConfiguration = (PerfettoConfiguration)config2;
                cpuProfilerConfig = new CpuProfilerConfig(perfettoConfiguration.getName(), CpuProfilerConfig.Technology.SYSTEM_TRACE);
                cpuProfilerConfig.setBufferSizeMb(4);
                break;
            }
            case UNSPECIFIED: {
                UnspecifiedConfiguration unspecifiedConfiguration = (UnspecifiedConfiguration)config2;
                cpuProfilerConfig = new CpuProfilerConfig(unspecifiedConfiguration.getName(), CpuProfilerConfig.Technology.SAMPLED_JAVA);
            }
        }
        return cpuProfilerConfig;
    }

    public static ProfilingConfiguration toProfilingConfiguration(CpuProfilerConfig config2, int deviceApi) {
        Object configuration = null;
        String name2 = config2.getName();
        switch (config2.getTechnology()) {
            case SAMPLED_JAVA: {
                configuration = new ArtSampledConfiguration(name2);
                configuration.setProfilingBufferSizeInMb(config2.getBufferSizeMb());
                configuration.setProfilingSamplingIntervalUs(config2.getSamplingIntervalUs());
                break;
            }
            case INSTRUMENTED_JAVA: {
                configuration = new ArtInstrumentedConfiguration(name2);
                ((ArtInstrumentedConfiguration)configuration).setProfilingBufferSizeInMb(config2.getBufferSizeMb());
                break;
            }
            case SAMPLED_NATIVE: {
                configuration = new SimpleperfConfiguration(name2);
                ((SimpleperfConfiguration)configuration).setProfilingSamplingIntervalUs(config2.getSamplingIntervalUs());
                break;
            }
            case SYSTEM_TRACE: {
                configuration = deviceApi >= 28 ? new PerfettoConfiguration(name2) : new AtraceConfiguration(name2);
            }
        }
        return configuration;
    }

    public static List<ProfilingConfiguration> toProfilingConfiguration(List<CpuProfilerConfig> configs, int deviceApi) {
        return ContainerUtil.map(configs, config2 -> CpuProfilerConfigConverter.toProfilingConfiguration(config2, deviceApi));
    }
}

