/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.eventpreprocessor;

import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.transport.TransportBytesPreprocessor;
import com.android.tools.idea.transport.TransportEventPreprocessor;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Trace;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.cpu.TracePreProcessor;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SimpleperfPipelinePreprocessor
implements TransportEventPreprocessor,
TransportBytesPreprocessor {
    private final Map<String, List<String>> myTraceIdsToSymbols = new HashMap<String, List<String>>();
    private final TracePreProcessor myPreProcessor;

    public SimpleperfPipelinePreprocessor(@NotNull TracePreProcessor preProcessor) {
        this.myPreProcessor = preProcessor;
    }

    @Override
    public boolean shouldPreprocess(Common.Event event2) {
        return event2.hasTraceData() && event2.getTraceData().hasTraceStarted() && ProfilingConfiguration.TraceType.from((Trace.TraceConfiguration)event2.getTraceData().getTraceStarted().getTraceInfo().getConfiguration()) == ProfilingConfiguration.TraceType.SIMPLEPERF;
    }

    @Override
    @NotNull
    public Iterable<Common.Event> preprocessEvent(Common.Event event2) {
        Trace.TraceConfiguration config2 = event2.getTraceData().getTraceStarted().getTraceInfo().getConfiguration();
        if (config2.hasSimpleperfOptions()) {
            this.myTraceIdsToSymbols.putIfAbsent(String.valueOf(event2.getTraceData().getTraceStarted().getTraceInfo().getTraceId()), (List<String>)config2.getSimpleperfOptions().getSymbolDirsList());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean shouldPreprocess(Transport.BytesRequest request2) {
        return this.myTraceIdsToSymbols.containsKey(request2.getId());
    }

    @Override
    @NotNull
    public ByteString preprocessBytes(String id2, ByteString data) {
        assert (this.myTraceIdsToSymbols.containsKey(id2));
        return this.myPreProcessor.preProcessTrace(data, this.myTraceIdsToSymbols.remove(id2));
    }
}

