/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.commands;

import com.android.ddmlib.Client;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.android.tools.idea.profilers.LegacyCpuProfilingHandler;
import com.android.tools.idea.profilers.LegacyCpuTraceRecord;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.transport.TransportProxy;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Trace;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011j\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/profilers/commands/LegacyCpuTraceCommandHandler;", "Lcom/android/tools/idea/transport/TransportProxy$ProxyCommandHandler;", "device", "Lcom/android/ddmlib/IDevice;", "transportStub", "Lcom/android/tools/profiler/proto/TransportServiceGrpc$TransportServiceBlockingStub;", "eventQueue", "Ljava/util/concurrent/BlockingDeque;", "Lcom/android/tools/profiler/proto/Common$Event;", "byteCache", "", "", "Lcom/android/tools/idea/protobuf/ByteString;", "(Lcom/android/ddmlib/IDevice;Lcom/android/tools/profiler/proto/TransportServiceGrpc$TransportServiceBlockingStub;Ljava/util/concurrent/BlockingDeque;Ljava/util/Map;)V", "getDevice", "()Lcom/android/ddmlib/IDevice;", "legacyProfilingRecord", "Ljava/util/HashMap;", "", "Lcom/android/tools/idea/profilers/LegacyCpuTraceRecord;", "Lkotlin/collections/HashMap;", "execute", "Lcom/android/tools/profiler/proto/Transport$ExecuteResponse;", "command", "Lcom/android/tools/profiler/proto/Commands$Command;", "getDeviceTimestamp", "", "record", "getLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "sendStartStatusEvent", "", "startStatus", "Lcom/android/tools/profiler/proto/Trace$TraceStartStatus;", "sendStartTraceEvent", "traceInfo", "Lcom/android/tools/profiler/proto/Trace$TraceInfo;", "sendStopStatusEvent", "Lcom/android/tools/profiler/proto/Trace$TraceStopStatus;", "sendStopTraceEvent", "shouldHandle", "", "startTrace", "stopTrace", "intellij.android.profilersAndroid"})
public final class LegacyCpuTraceCommandHandler
implements TransportProxy.ProxyCommandHandler {
    @NotNull
    private final IDevice device;
    @NotNull
    private final TransportServiceGrpc.TransportServiceBlockingStub transportStub;
    @NotNull
    private final BlockingDeque<Common.Event> eventQueue;
    @NotNull
    private final HashMap<Integer, LegacyCpuTraceRecord> legacyProfilingRecord;

    public LegacyCpuTraceCommandHandler(@NotNull IDevice device2, @NotNull TransportServiceGrpc.TransportServiceBlockingStub transportStub, @NotNull BlockingDeque<Common.Event> eventQueue, @NotNull Map<String, ByteString> byteCache) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)transportStub, (String)"transportStub");
        Intrinsics.checkNotNullParameter(eventQueue, (String)"eventQueue");
        Intrinsics.checkNotNullParameter(byteCache, (String)"byteCache");
        this.device = device2;
        this.transportStub = transportStub;
        this.eventQueue = eventQueue;
        this.legacyProfilingRecord = new HashMap();
        LegacyCpuProfilingHandler.INSTANCE.registerDevice(this.device, (Map<Integer, LegacyCpuTraceRecord>)this.legacyProfilingRecord, byteCache);
    }

    @NotNull
    public final IDevice getDevice() {
        return this.device;
    }

    private final Logger getLogger() {
        Logger logger2 = Logger.getInstance(LegacyCpuTraceCommandHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(LegacyCpuTra\u2026mmandHandler::class.java)");
        return logger2;
    }

    @Override
    public boolean shouldHandle(@NotNull Commands.Command command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Commands.Command.CommandType commandType = command.getType();
        return switch (commandType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[commandType.ordinal()]) {
            case 1 -> {
                if (ProfilingConfiguration.TraceType.from((Trace.TraceConfiguration)command.getStartTrace().getConfiguration()) == ProfilingConfiguration.TraceType.ART) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (ProfilingConfiguration.TraceType.from((Trace.TraceConfiguration)command.getStopTrace().getConfiguration()) == ProfilingConfiguration.TraceType.ART) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    @NotNull
    public Transport.ExecuteResponse execute(@NotNull Commands.Command command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Commands.Command.CommandType commandType = command.getType();
        switch (commandType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[commandType.ordinal()]) {
            case 1: {
                this.startTrace(command);
                break;
            }
            case 2: {
                this.stopTrace(command);
            }
        }
        Transport.ExecuteResponse executeResponse = Transport.ExecuteResponse.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)executeResponse, (String)"getDefaultInstance()");
        return executeResponse;
    }

    private final void startTrace(Commands.Command command) {
        Client client2;
        Trace.TraceConfiguration traceConfiguration = command.getStartTrace().getConfiguration();
        boolean bl = traceConfiguration.hasArtOptions();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Trace.ArtOptions artOptions = traceConfiguration.getArtOptions();
        int pid = command.getPid();
        String appPkgName = this.device.getClientName(pid);
        Client client3 = client2 = appPkgName != null ? this.device.getClient(appPkgName) : null;
        if (client2 == null) {
            Trace.TraceStartStatus.Builder builder2;
            Trace.TraceStartStatus.Builder $this$startTrace_u24lambda_u240 = builder2 = Trace.TraceStartStatus.newBuilder();
            boolean bl2 = false;
            $this$startTrace_u24lambda_u240.setStatus(Trace.TraceStartStatus.Status.FAILURE);
            $this$startTrace_u24lambda_u240.setErrorMessage("App is not running");
            Trace.TraceStartStatus status2 = builder2.build();
            Intrinsics.checkNotNullExpressionValue((Object)status2, (String)"status");
            this.sendStartStatusEvent(command, status2);
        } else if (!LegacyCpuTraceRecord.Companion.isMethodProfilingStatusOff(this.legacyProfilingRecord.get(pid), client2)) {
            Trace.TraceStartStatus.Builder builder3;
            Trace.TraceStartStatus.Builder $this$startTrace_u24lambda_u241 = builder3 = Trace.TraceStartStatus.newBuilder();
            boolean bl3 = false;
            $this$startTrace_u24lambda_u241.setStatus(Trace.TraceStartStatus.Status.FAILURE);
            $this$startTrace_u24lambda_u241.setErrorMessage("Start request ignored. The app has an on-going profiling session.");
            Trace.TraceStartStatus status3 = builder3.build();
            Intrinsics.checkNotNullExpressionValue((Object)status3, (String)"status");
            this.sendStartStatusEvent(command, status3);
        } else {
            DdmPreferences.setProfilerBufferSizeMb((int)artOptions.getBufferSizeInMb());
            long requestTimeNs = this.transportStub.getCurrentTime(Transport.TimeRequest.getDefaultInstance()).getTimestampNs();
            LegacyCpuTraceRecord record = new LegacyCpuTraceRecord();
            this.legacyProfilingRecord.put(pid, record);
            try {
                if (artOptions.getTraceMode() == Trace.TraceMode.SAMPLED) {
                    client2.startSamplingProfiler(artOptions.getSamplingIntervalUs(), TimeUnit.MICROSECONDS);
                } else {
                    client2.startMethodTracer();
                }
                record.getStartLatch().await(100L, TimeUnit.MILLISECONDS);
                record.getStartLatch().countDown();
                if (record.isStartFailed()) {
                    Trace.TraceStartStatus.Builder builder4;
                    Trace.TraceStartStatus.Builder $this$startTrace_u24lambda_u242 = builder4 = Trace.TraceStartStatus.newBuilder();
                    boolean bl4 = false;
                    $this$startTrace_u24lambda_u242.setStatus(Trace.TraceStartStatus.Status.FAILURE);
                    $this$startTrace_u24lambda_u242.setErrorMessage("Failed to start profiling: " + record.getStartFailureMessage());
                    Trace.TraceStartStatus status4 = builder4.build();
                    this.legacyProfilingRecord.remove(pid);
                    Intrinsics.checkNotNullExpressionValue((Object)status4, (String)"status");
                    this.sendStartStatusEvent(command, status4);
                } else {
                    Trace.TraceInfo.Builder builder5;
                    Trace.TraceStartStatus.Builder builder6;
                    Trace.TraceStartStatus.Builder $this$startTrace_u24lambda_u243 = builder6 = Trace.TraceStartStatus.newBuilder();
                    boolean bl5 = false;
                    $this$startTrace_u24lambda_u243.setStatus(Trace.TraceStartStatus.Status.SUCCESS);
                    Trace.TraceStartStatus status5 = builder6.build();
                    Intrinsics.checkNotNullExpressionValue((Object)status5, (String)"status");
                    this.sendStartStatusEvent(command, status5);
                    Trace.TraceInfo.Builder $this$startTrace_u24lambda_u244 = builder5 = Trace.TraceInfo.newBuilder();
                    boolean bl6 = false;
                    $this$startTrace_u24lambda_u244.setTraceId(requestTimeNs);
                    $this$startTrace_u24lambda_u244.setConfiguration(traceConfiguration);
                    $this$startTrace_u24lambda_u244.setFromTimestamp(requestTimeNs);
                    $this$startTrace_u24lambda_u244.setToTimestamp(-1L);
                    $this$startTrace_u24lambda_u244.setStartStatus(status5);
                    Trace.TraceInfo.Builder traceInfo = builder5;
                    record.setTraceInfo(traceInfo);
                    Trace.TraceInfo traceInfo2 = traceInfo.build();
                    Intrinsics.checkNotNullExpressionValue((Object)traceInfo2, (String)"traceInfo.build()");
                    this.sendStartTraceEvent(command, traceInfo2);
                }
            }
            catch (Exception e) {
                Trace.TraceStartStatus.Builder builder7;
                Trace.TraceStartStatus.Builder $this$startTrace_u24lambda_u245 = builder7 = Trace.TraceStartStatus.newBuilder();
                boolean bl7 = false;
                $this$startTrace_u24lambda_u245.setStatus(Trace.TraceStartStatus.Status.FAILURE);
                $this$startTrace_u24lambda_u245.setErrorMessage("Failed: " + e);
                Trace.TraceStartStatus status6 = builder7.build();
                this.legacyProfilingRecord.remove(pid);
                Intrinsics.checkNotNullExpressionValue((Object)status6, (String)"status");
                this.sendStartStatusEvent(command, status6);
                this.getLogger().error("Exception while CpuServiceProxy startProfilingAppDdms: " + e);
            }
        }
    }

    private final void stopTrace(Commands.Command command) {
        Client client2;
        Trace.TraceConfiguration traceConfiguration = command.getStopTrace().getConfiguration();
        boolean bl = traceConfiguration.hasArtOptions();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Trace.ArtOptions artOptions = traceConfiguration.getArtOptions();
        int pid = command.getPid();
        String appPkgName = this.device.getClientName(pid);
        Client client3 = client2 = appPkgName != null ? this.device.getClient(appPkgName) : null;
        if (client2 == null) {
            Trace.TraceStopStatus.Builder builder2;
            Trace.TraceStopStatus.Builder $this$stopTrace_u24lambda_u246 = builder2 = Trace.TraceStopStatus.newBuilder();
            boolean bl2 = false;
            $this$stopTrace_u24lambda_u246.setStatus(Trace.TraceStopStatus.Status.APP_PROCESS_DIED);
            $this$stopTrace_u24lambda_u246.setErrorMessage("App is not running");
            Trace.TraceStopStatus status2 = builder2.build();
            Intrinsics.checkNotNullExpressionValue((Object)status2, (String)"status");
            this.sendStopStatusEvent(command, status2);
            LegacyCpuTraceRecord record = this.legacyProfilingRecord.get(pid);
            if (record != null) {
                long endTimeNs = this.getDeviceTimestamp(record);
                Trace.TraceInfo.Builder builder3 = record.getTraceInfo();
                Intrinsics.checkNotNull((Object)builder3);
                Trace.TraceInfo traceInfo = builder3.setToTimestamp(endTimeNs).build();
                Intrinsics.checkNotNullExpressionValue((Object)traceInfo, (String)"record.traceInfo!!.setTo\u2026estamp(endTimeNs).build()");
                this.sendStopTraceEvent(command, traceInfo);
            }
        } else {
            LegacyCpuTraceRecord record = this.legacyProfilingRecord.get(pid);
            if (LegacyCpuTraceRecord.Companion.isMethodProfilingStatusOff(record, client2)) {
                Trace.TraceStopStatus.Builder endTimeNs;
                Trace.TraceStopStatus.Builder $this$stopTrace_u24lambda_u247 = endTimeNs = Trace.TraceStopStatus.newBuilder();
                boolean bl3 = false;
                $this$stopTrace_u24lambda_u247.setStatus(Trace.TraceStopStatus.Status.NO_ONGOING_PROFILING);
                $this$stopTrace_u24lambda_u247.setErrorMessage("The app is not being profiled.");
                Trace.TraceStopStatus status3 = endTimeNs.build();
                Intrinsics.checkNotNullExpressionValue((Object)status3, (String)"status");
                this.sendStopStatusEvent(command, status3);
            } else {
                try {
                    if (artOptions.getTraceMode() == Trace.TraceMode.SAMPLED) {
                        client2.stopSamplingProfiler();
                    } else {
                        client2.stopMethodTracer();
                    }
                    LegacyCpuTraceRecord legacyCpuTraceRecord = record;
                    Intrinsics.checkNotNull((Object)legacyCpuTraceRecord);
                    legacyCpuTraceRecord.getStopLatch().await();
                    long endTimeNs = this.getDeviceTimestamp(record);
                    Trace.TraceInfo.Builder builder4 = record.getTraceInfo();
                    Intrinsics.checkNotNull((Object)builder4);
                    Trace.TraceStopStatus traceStopStatus = builder4.getStopStatus();
                    Intrinsics.checkNotNullExpressionValue((Object)traceStopStatus, (String)"record.traceInfo!!.stopStatus");
                    this.sendStopStatusEvent(command, traceStopStatus);
                    Trace.TraceInfo.Builder builder5 = record.getTraceInfo();
                    Intrinsics.checkNotNull((Object)builder5);
                    Trace.TraceInfo traceInfo = builder5.setToTimestamp(endTimeNs).build();
                    Intrinsics.checkNotNullExpressionValue((Object)traceInfo, (String)"record.traceInfo!!.setTo\u2026estamp(endTimeNs).build()");
                    this.sendStopTraceEvent(command, traceInfo);
                }
                catch (Exception e) {
                    Trace.TraceStopStatus.Builder builder6;
                    Trace.TraceStopStatus.Builder $this$stopTrace_u24lambda_u248 = builder6 = Trace.TraceStopStatus.newBuilder();
                    boolean bl4 = false;
                    $this$stopTrace_u24lambda_u248.setStatus(Trace.TraceStopStatus.Status.STOP_COMMAND_FAILED);
                    $this$stopTrace_u24lambda_u248.setErrorMessage("Failed: " + e);
                    Trace.TraceStopStatus status4 = builder6.build();
                    Intrinsics.checkNotNullExpressionValue((Object)status4, (String)"status");
                    this.sendStopStatusEvent(command, status4);
                    this.getLogger().error("Exception while CpuServiceProxy stopProfilingApp: " + e);
                }
            }
        }
        this.legacyProfilingRecord.remove(pid);
    }

    private final long getDeviceTimestamp(LegacyCpuTraceRecord record) {
        long endTimeNs = 0L;
        try {
            endTimeNs = this.transportStub.getCurrentTime(Transport.TimeRequest.getDefaultInstance()).getTimestampNs();
        }
        catch (StatusRuntimeException exception) {
            Trace.TraceInfo.Builder builder2 = record.getTraceInfo();
            Intrinsics.checkNotNull((Object)builder2);
            endTimeNs = builder2.getFromTimestamp() + 1L;
        }
        return endTimeNs;
    }

    private final void sendStartStatusEvent(Commands.Command command, Trace.TraceStartStatus startStatus) {
        Common.Event.Builder builder2;
        Common.Event.Builder $this$sendStartStatusEvent_u24lambda_u249 = builder2 = Common.Event.newBuilder();
        boolean bl = false;
        $this$sendStartStatusEvent_u24lambda_u249.setPid(command.getPid());
        $this$sendStartStatusEvent_u24lambda_u249.setKind(Common.Event.Kind.TRACE_STATUS);
        $this$sendStartStatusEvent_u24lambda_u249.setCommandId(command.getCommandId());
        $this$sendStartStatusEvent_u24lambda_u249.setTraceStatus(Trace.TraceStatusData.newBuilder().setTraceStartStatus(startStatus).build());
        Common.Event statusEvent = builder2.build();
        this.eventQueue.offer(statusEvent);
    }

    private final void sendStartTraceEvent(Commands.Command command, Trace.TraceInfo traceInfo) {
        Common.Event.Builder builder2;
        Common.Event.Builder $this$sendStartTraceEvent_u24lambda_u2410 = builder2 = Common.Event.newBuilder();
        boolean bl = false;
        $this$sendStartTraceEvent_u24lambda_u2410.setPid(command.getPid());
        $this$sendStartTraceEvent_u24lambda_u2410.setKind(Common.Event.Kind.CPU_TRACE);
        $this$sendStartTraceEvent_u24lambda_u2410.setTimestamp(traceInfo.getFromTimestamp());
        $this$sendStartTraceEvent_u24lambda_u2410.setGroupId(traceInfo.getTraceId());
        $this$sendStartTraceEvent_u24lambda_u2410.setTraceData(Trace.TraceData.newBuilder().setTraceStarted(Trace.TraceData.TraceStarted.newBuilder().setTraceInfo(traceInfo)).build());
        Common.Event traceStartEvent = builder2.build();
        this.eventQueue.offer(traceStartEvent);
    }

    private final void sendStopStatusEvent(Commands.Command command, Trace.TraceStopStatus startStatus) {
        Common.Event.Builder builder2;
        Common.Event.Builder $this$sendStopStatusEvent_u24lambda_u2411 = builder2 = Common.Event.newBuilder();
        boolean bl = false;
        $this$sendStopStatusEvent_u24lambda_u2411.setPid(command.getPid());
        $this$sendStopStatusEvent_u24lambda_u2411.setKind(Common.Event.Kind.TRACE_STATUS);
        $this$sendStopStatusEvent_u24lambda_u2411.setCommandId(command.getCommandId());
        $this$sendStopStatusEvent_u24lambda_u2411.setTraceStatus(Trace.TraceStatusData.newBuilder().setTraceStopStatus(startStatus).build());
        Common.Event statusEvent = builder2.build();
        this.eventQueue.offer(statusEvent);
    }

    private final void sendStopTraceEvent(Commands.Command command, Trace.TraceInfo traceInfo) {
        Common.Event.Builder builder2;
        Common.Event.Builder $this$sendStopTraceEvent_u24lambda_u2412 = builder2 = Common.Event.newBuilder();
        boolean bl = false;
        $this$sendStopTraceEvent_u24lambda_u2412.setPid(command.getPid());
        $this$sendStopTraceEvent_u24lambda_u2412.setKind(Common.Event.Kind.CPU_TRACE);
        $this$sendStopTraceEvent_u24lambda_u2412.setTimestamp(traceInfo.getToTimestamp());
        $this$sendStopTraceEvent_u24lambda_u2412.setGroupId(traceInfo.getTraceId());
        $this$sendStopTraceEvent_u24lambda_u2412.setTraceData(Trace.TraceData.newBuilder().setTraceEnded(Trace.TraceData.TraceEnded.newBuilder().setTraceInfo(traceInfo)).build());
        Common.Event traceStartEvent = builder2.build();
        this.eventQueue.offer(traceStartEvent);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Commands.Command.CommandType.values().length];
            try {
                nArray[Commands.Command.CommandType.START_TRACE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Commands.Command.CommandType.STOP_TRACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

