/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.idea.codenavigation.CodeNavigator;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.profilers.AndroidProfilerToolWindow;
import com.android.tools.idea.profilers.AndroidProfilerWindowManagerListener;
import com.android.tools.idea.profilers.IntellijProfilerComponents;
import com.android.tools.idea.profilers.IntellijProfilerServices;
import com.android.tools.idea.profilers.PreferredProcessInfo;
import com.android.tools.idea.profilers.ToolWindowWrapper;
import com.android.tools.idea.transport.TransportService;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.SessionProfilersView;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.sessions.SessionsManager;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import icons.StudioIcons;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0013H\u0002J\b\u0010\u0016\u001a\u00020\u0013H\u0002R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/profilers/StudioProfilersWrapper;", "Lcom/android/tools/adtui/model/AspectObserver;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "window", "Lcom/android/tools/idea/profilers/ToolWindowWrapper;", "ideProfilerServices", "Lcom/android/tools/idea/profilers/IntellijProfilerServices;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/profilers/ToolWindowWrapper;Lcom/android/tools/idea/profilers/IntellijProfilerServices;)V", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "getProfilers", "()Lcom/android/tools/profilers/StudioProfilers;", "profilersView", "Lcom/android/tools/profilers/StudioProfilersView;", "getProfilersView", "()Lcom/android/tools/profilers/StudioProfilersView;", "dispose", "", "profilingSessionChanged", "selectedSessionChanged", "stageChanged", "Companion", "intellij.android.profilersAndroid"})
public final class StudioProfilersWrapper
extends AspectObserver
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ToolWindowWrapper window;
    @NotNull
    private final StudioProfilers profilers;
    @NotNull
    private final StudioProfilersView profilersView;

    public StudioProfilersWrapper(@NotNull Project project, @NotNull ToolWindowWrapper window2, @NotNull IntellijProfilerServices ideProfilerServices) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)window2, (String)"window");
        Intrinsics.checkNotNullParameter((Object)ideProfilerServices, (String)"ideProfilerServices");
        this.project = project;
        this.window = window2;
        ProfilerClient client2 = new ProfilerClient(TransportService.Companion.getChannelName());
        this.profilers = new StudioProfilers(client2, (IdeProfilerServices)ideProfilerServices);
        CodeNavigator codeNavigator = ideProfilerServices.getCodeNavigator();
        Intrinsics.checkNotNullExpressionValue((Object)codeNavigator, (String)"ideProfilerServices.codeNavigator");
        CodeNavigator navigator = codeNavigator;
        navigator.setCpuArchSource(new Supplier(){

            @Nullable
            public final String get() {
                return this.getProfilers().getSessionsManager().getSelectedSessionMetaData().getProcessAbi();
            }
        });
        this.profilers.addDependency((AspectObserver)this).onChange((Enum)ProfilerAspect.STAGE, new Runnable(){

            @Override
            public final void run() {
                this.stageChanged();
            }
        });
        this.profilers.getSessionsManager().addDependency((AspectObserver)this).onChange((Enum)SessionAspect.SELECTED_SESSION, new Runnable(){

            @Override
            public final void run() {
                this.selectedSessionChanged();
            }
        }).onChange((Enum)SessionAspect.PROFILING_SESSION, new Runnable(){

            @Override
            public final void run() {
                this.profilingSessionChanged();
            }
        });
        final PreferredProcessInfo processInfo = (PreferredProcessInfo)this.project.getUserData(AndroidProfilerToolWindow.LAST_RUN_APP_INFO);
        if (processInfo != null) {
            this.profilers.setPreferredProcess(processInfo.getDeviceName(), processInfo.getProcessName(), new Predicate(){

                public final boolean test(@Nullable Common.Process p) {
                    Function1<Common.Process, Boolean> function1 = processInfo.getProcessFilter();
                    Common.Process process2 = p;
                    Intrinsics.checkNotNull((Object)process2);
                    return (Boolean)function1.invoke((Object)process2);
                }
            });
            this.project.putUserData(AndroidProfilerToolWindow.LAST_RUN_APP_INFO, null);
        } else {
            StartupManager.getInstance((Project)this.project).runWhenProjectIsInitialized(new Runnable(){

                @Override
                public final void run() {
                    this.getProfilers().setPreferredProcessName(Companion.getPreferredProcessName(project));
                }
            });
        }
        IdeProfilerComponents profilerComponents = new IntellijProfilerComponents(this.project, this.profilers.getIdeServices().getFeatureTracker());
        this.profilersView = (StudioProfilersView)new SessionProfilersView(this.profilers, profilerComponents, (Disposable)this);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new AndroidProfilerWindowManagerListener(this.project, this.profilers, this.profilersView));
    }

    @NotNull
    public final StudioProfilers getProfilers() {
        return this.profilers;
    }

    @NotNull
    public final StudioProfilersView getProfilersView() {
        return this.profilersView;
    }

    public void dispose() {
        this.profilers.stop();
    }

    private final void stageChanged() {
        if (this.profilers.isStopped()) {
            this.window.removeContent();
        }
    }

    private final void selectedSessionChanged() {
        Common.SessionMetaData sessionMetaData = this.profilers.getSessionsManager().getSelectedSessionMetaData();
        Intrinsics.checkNotNullExpressionValue((Object)sessionMetaData, (String)"profilers.sessionsManager.selectedSessionMetaData");
        Common.SessionMetaData metaData = sessionMetaData;
        this.window.setTitle(metaData.getSessionName());
    }

    private final void profilingSessionChanged() {
        Common.Session session2 = this.profilers.getSessionsManager().getProfilingSession();
        Intrinsics.checkNotNullExpressionValue((Object)session2, (String)"profilers.sessionsManager.profilingSession");
        Common.Session profilingSession = session2;
        if (SessionsManager.isSessionAlive((Common.Session)profilingSession)) {
            this.window.setIcon(ExecutionUtil.getLiveIndicator((Icon)StudioIcons.Shell.ToolWindows.ANDROID_PROFILER));
        } else {
            this.window.setIcon(StudioIcons.Shell.ToolWindows.ANDROID_PROFILER);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/profilers/StudioProfilersWrapper$Companion;", "", "()V", "getModuleName", "", "module", "Lcom/intellij/openapi/module/Module;", "getPreferredProcessName", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.profilersAndroid"})
    public static final class Companion {
        private Companion() {
        }

        private final String getPreferredProcessName(Project project) {
            for (Module module2 : ModuleManager.Companion.getInstance(project).getModules()) {
                String moduleName2 = this.getModuleName(module2);
                if (moduleName2 == null) continue;
                return moduleName2;
            }
            return null;
        }

        private final String getModuleName(Module module2) {
            String pkg;
            AndroidModuleInfo moduleInfo = StudioAndroidModuleInfo.getInstance(module2);
            if (moduleInfo != null && (pkg = moduleInfo.getPackageName()) != null) {
                return pkg;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

