/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.profilers.AndroidProfilerToolWindow;
import com.android.tools.idea.profilers.AndroidProfilerToolWindowFactory;
import com.android.tools.idea.profilers.analytics.StudioFeatureTracker;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidRunConfigurationType;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.configuration.AndroidConfigurationProgramRunner;
import com.android.tools.idea.run.configuration.execution.AndroidConfigurationExecutor;
import com.android.tools.idea.run.profiler.AbstractProfilerExecutorGroup;
import com.android.tools.idea.run.profiler.ProfilingMode;
import com.android.tools.idea.run.util.SwapInfo;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfigurationType;
import com.android.tools.profilers.StudioProfilers;
import com.google.wireless.android.sdk.stats.RunWithProfilingMetadata;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ThreeState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0014J \u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016J \u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0014R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/profilers/ProfilerProgramRunner;", "Lcom/android/tools/idea/run/configuration/AndroidConfigurationProgramRunner;", "()V", "supportedConfigurationTypeIds", "", "", "getSupportedConfigurationTypeIds", "()Ljava/util/List;", "canRun", "", "executorId", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "canRunWithMultipleDevices", "checkProfileableSupportAndExecute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "doExecuteInternal", "execute", "getRunnerId", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Companion", "intellij.android.profilersAndroid"})
public final class ProfilerProgramRunner
extends AndroidConfigurationProgramRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> supportedConfigurationTypeIds;

    public ProfilerProgramRunner() {
        Object[] objectArray = new String[2];
        objectArray[0] = new AndroidRunConfigurationType().getId();
        Intrinsics.checkNotNullExpressionValue((Object)new AndroidTestRunConfigurationType().getId(), (String)"AndroidTestRunConfigurationType().id");
        this.supportedConfigurationTypeIds = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public String getRunnerId() {
        return "ProfilerProgramRunner";
    }

    @Override
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile2) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
        if (!super.canRun(executorId, profile2)) {
            return false;
        }
        if (!Companion.isProfilerExecutor(executorId)) {
            return false;
        }
        if (!(profile2 instanceof RunConfiguration)) {
            return false;
        }
        Object t = StudioFlags.PROFILEABLE_BUILDS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"PROFILEABLE_BUILDS.get()");
        if (((Boolean)t).booleanValue()) {
            Project project = ((RunConfiguration)profile2).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"profile.project");
            if (ProjectSystemUtil.getProjectSystem(project).supportsProfilingMode()) {
                AbstractProfilerExecutorGroup<?> abstractProfilerExecutorGroup = AbstractProfilerExecutorGroup.Companion.getInstance();
                if ((abstractProfilerExecutorGroup != null ? (AbstractProfilerExecutorGroup.AbstractProfilerSetting)abstractProfilerExecutorGroup.getRegisteredSettings(executorId) : null) == null) {
                    return false;
                }
            } else if (!Intrinsics.areEqual((Object)"Android Profiler", (Object)executorId)) {
                return false;
            }
        }
        Project project = ((RunConfiguration)profile2).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"profile.project");
        GradleSyncState syncState = GradleSyncState.Companion.getInstance(project);
        return !syncState.isSyncInProgress() && syncState.isSyncNeeded() == ThreeState.NO;
    }

    @Override
    @NotNull
    protected List<String> getSupportedConfigurationTypeIds() {
        return this.supportedConfigurationTypeIds;
    }

    @Override
    protected boolean canRunWithMultipleDevices(@NotNull String executorId) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        return false;
    }

    @Override
    @NotNull
    protected RunContentDescriptor run(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state2, @NotNull ProgressIndicator indicator) {
        SwapInfo swapInfo;
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        AndroidConfigurationExecutor executor2 = (AndroidConfigurationExecutor)state2;
        String string = environment.getExecutor().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"environment.executor.id");
        if (!Companion.isProfilerExecutor(string)) {
            throw new RuntimeException("Not a profiler executor");
        }
        SwapInfo swapInfo2 = swapInfo = (SwapInfo)environment.getUserData(SwapInfo.SWAP_INFO_KEY);
        SwapInfo.SwapType swapType = swapInfo2 != null ? swapInfo2.getType() : null;
        return switch (swapType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[swapType.ordinal()]) {
            case 1 -> executor2.applyChanges(indicator);
            case 2 -> executor2.applyCodeChanges(indicator);
            default -> executor2.run(indicator);
        };
    }

    @Override
    @NotNull
    public Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state2) throws ExecutionException {
        Promise<RunContentDescriptor> promise;
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        String string = environment.getExecutor().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"environment.executor.id");
        String executorId = string;
        if (Intrinsics.areEqual((Object)"Android Profiler", (Object)executorId)) {
            promise = this.doExecuteInternal(state2, environment);
        } else {
            AbstractProfilerExecutorGroup.AbstractProfilerSetting abstractProfilerSetting = AbstractProfilerExecutorGroup.Companion.getExecutorSetting(executorId);
            ProfilingMode profilingMode = abstractProfilerSetting != null ? abstractProfilerSetting.getProfilingMode() : null;
            switch (profilingMode == null ? -1 : WhenMappings.$EnumSwitchMapping$1[profilingMode.ordinal()]) {
                case 1: 
                case 2: {
                    promise = this.doExecuteInternal(state2, environment);
                    break;
                }
                case 3: {
                    promise = this.checkProfileableSupportAndExecute(state2, environment);
                    break;
                }
                default: {
                    promise = Promises.resolvedPromise(null);
                }
            }
        }
        return promise;
    }

    private final Promise<RunContentDescriptor> doExecuteInternal(RunProfileState state2, ExecutionEnvironment environment) {
        Promise<RunContentDescriptor> descriptor2 = super.execute(environment, state2);
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"environment.project");
        Companion.createProfilerToolWindow(project, environment.getRunnerAndConfigurationSettings(), environment.getUserData(SwapInfo.SWAP_INFO_KEY) != null, environment.getExecutor().getId());
        return descriptor2;
    }

    private final Promise<RunContentDescriptor> checkProfileableSupportAndExecute(RunProfileState state2, ExecutionEnvironment environment) {
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"environment.project");
        if (ProfilerProgramRunner.Companion.isAgpVersionSupported(project) && ProfilerProgramRunner.Companion.isDeviceSupported(environment)) {
            return this.doExecuteInternal(state2, environment);
        }
        Project project2 = environment.getProject();
        DialogWrapper dialog2 = new DialogWrapper(project2){
            {
                this.setTitle("Confirmation");
                this.init();
            }

            @NotNull
            protected JComponent createCenterPanel() {
                JPanel jPanel;
                JPanel $this$createCenterPanel_u24lambda_u240 = jPanel = new JPanel(new BorderLayout());
                boolean bl = false;
                $this$createCenterPanel_u24lambda_u240.add((Component)new JBLabel("<html>Profiling with Low Overhead requires Android Gradle Plugin 7.3 or higher, a device with API level 29 or higher,<br>and a system that is not debuggable (e.g., a Google Play enabled emulator system image).<br>Do you want to Profile with Complete Data instead?</html>"), "Center");
                return jPanel;
            }
        };
        if (dialog2.showAndGet()) {
            return this.doExecuteInternal(state2, environment);
        }
        return Promises.resolvedPromise();
    }

    @JvmStatic
    @JvmOverloads
    public static final void createProfilerToolWindow(@NotNull Project project, @Nullable RunnerAndConfigurationSettings settings, boolean isSwapExecution, @Nullable String executorId) {
        Companion.createProfilerToolWindow(project, settings, isSwapExecution, executorId);
    }

    @JvmStatic
    @JvmOverloads
    public static final void createProfilerToolWindow(@NotNull Project project, @Nullable RunnerAndConfigurationSettings settings, boolean isSwapExecution) {
        Companion.createProfilerToolWindow(project, settings, isSwapExecution);
    }

    @JvmStatic
    @JvmOverloads
    public static final void createProfilerToolWindow(@NotNull Project project, @Nullable RunnerAndConfigurationSettings settings) {
        Companion.createProfilerToolWindow(project, settings);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/profilers/ProfilerProgramRunner$Companion;", "", "()V", "createProfilerToolWindow", "", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "isSwapExecution", "", "executorId", "", "isAgpVersionSupported", "isDeviceSupported", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "isProfilerExecutor", "intellij.android.profilersAndroid"})
    @SourceDebugExtension(value={"SMAP\nProfilerProgramRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfilerProgramRunner.kt\ncom/android/tools/idea/profilers/ProfilerProgramRunner$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,247:1\n1#2:248\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        public final void createProfilerToolWindow(@NotNull Project project, @Nullable RunnerAndConfigurationSettings settings, boolean isSwapExecution, @Nullable String executorId) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ApplicationManager.getApplication().assertIsDispatchThread();
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = settings;
            if (runnerAndConfigurationSettings != null) {
                runnerAndConfigurationSettings.setActivateToolWindowBeforeRun(false);
            }
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Android Profiler");
            if (toolWindow != null) {
                object = toolWindow;
                ToolWindow $this$createProfilerToolWindow_u24lambda_u240 = object;
                boolean bl = false;
                if (!$this$createProfilerToolWindow_u24lambda_u240.isVisible()) {
                    project.putUserData(AndroidProfilerToolWindow.LAST_RUN_APP_INFO, null);
                    $this$createProfilerToolWindow_u24lambda_u240.setAvailable(true);
                    $this$createProfilerToolWindow_u24lambda_u240.show(null);
                }
            }
            AndroidProfilerToolWindow androidProfilerToolWindow = AndroidProfilerToolWindowFactory.Companion.getProfilerToolWindow(project);
            if (androidProfilerToolWindow != null) {
                Object $this$createProfilerToolWindow_u24lambda_u241 = object = androidProfilerToolWindow;
                boolean bl = false;
                ((AndroidProfilerToolWindow)$this$createProfilerToolWindow_u24lambda_u241).disableAutoProfiling();
                if (!isSwapExecution) {
                    StudioProfilers studioProfilers = ((AndroidProfilerToolWindow)$this$createProfilerToolWindow_u24lambda_u241).getProfilers();
                    Intrinsics.checkNotNull((Object)studioProfilers);
                    studioProfilers.getSessionsManager().endCurrentSession();
                }
            }
            StudioFeatureTracker featureTracker = new StudioFeatureTracker(project);
            RunWithProfilingMetadata.Builder metadataBuilder = RunWithProfilingMetadata.newBuilder();
            Object t = StudioFlags.PROFILEABLE_BUILDS.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"PROFILEABLE_BUILDS.get()");
            if (((Boolean)t).booleanValue() && executorId != null) {
                Object object2 = AbstractProfilerExecutorGroup.Companion.getExecutorSetting(executorId);
                if (object2 == null || (object2 = ((AbstractProfilerExecutorGroup.AbstractProfilerSetting)object2).getProfilingMode()) == null) {
                    object2 = ProfilingMode.NOT_SET;
                }
                Object profilingMode = object2;
                metadataBuilder.setProfilingMode(((ProfilingMode)((Object)profilingMode)).getAnalyticsProtoType());
            }
            featureTracker.trackRunWithProfiling(metadataBuilder.build());
        }

        public static /* synthetic */ void createProfilerToolWindow$default(Companion companion, Project project, RunnerAndConfigurationSettings runnerAndConfigurationSettings, boolean bl, String string, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                string = null;
            }
            companion.createProfilerToolWindow(project, runnerAndConfigurationSettings, bl, string);
        }

        public final boolean isProfilerExecutor(@NotNull String executorId) {
            Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
            Object t = StudioFlags.PROFILEABLE_BUILDS.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"PROFILEABLE_BUILDS.get()");
            if (((Boolean)t).booleanValue()) {
                AbstractProfilerExecutorGroup<?> abstractProfilerExecutorGroup = AbstractProfilerExecutorGroup.Companion.getInstance();
                if ((abstractProfilerExecutorGroup != null ? (AbstractProfilerExecutorGroup.AbstractProfilerSetting)abstractProfilerExecutorGroup.getRegisteredSettings(executorId) : null) != null) {
                    return true;
                }
            }
            return Intrinsics.areEqual((Object)"Android Profiler", (Object)executorId);
        }

        private final boolean isAgpVersionSupported(Project project) {
            AgpVersion agpVersion;
            String string = GradleUtil.getLastKnownAndroidGradlePluginVersion(project);
            if (string != null) {
                String it = string;
                boolean bl = false;
                agpVersion = AgpVersion.Companion.tryParse(it);
            } else {
                agpVersion = null;
            }
            AgpVersion agpVersion2 = agpVersion;
            return agpVersion2 != null && agpVersion2.isAtLeastIncludingPreviews(7, 3, 0);
        }

        private final boolean isDeviceSupported(ExecutionEnvironment env) {
            List targetDevices;
            DeviceFutures deviceFutures;
            DeviceFutures deviceFutures2 = deviceFutures = (DeviceFutures)env.getCopyableUserData(DeviceFutures.KEY);
            List list2 = deviceFutures2 != null ? deviceFutures2.getDevices() : null;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            if (!((Collection)(targetDevices = list2)).isEmpty()) {
                AndroidDevice device2 = (AndroidDevice)targetDevices.get(0);
                return device2.getVersion().isGreaterOrEqualThan(29) && !device2.isDebuggable();
            }
            return false;
        }

        @JvmStatic
        @JvmOverloads
        public final void createProfilerToolWindow(@NotNull Project project, @Nullable RunnerAndConfigurationSettings settings, boolean isSwapExecution) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            com.android.tools.idea.profilers.ProfilerProgramRunner$Companion.createProfilerToolWindow$default(this, project, settings, isSwapExecution, null, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void createProfilerToolWindow(@NotNull Project project, @Nullable RunnerAndConfigurationSettings settings) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            com.android.tools.idea.profilers.ProfilerProgramRunner$Companion.createProfilerToolWindow$default(this, project, settings, false, null, 12, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SwapInfo.SwapType.values().length];
            try {
                nArray[SwapInfo.SwapType.APPLY_CHANGES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SwapInfo.SwapType.APPLY_CODE_CHANGES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ProfilingMode.values().length];
            try {
                nArray[ProfilingMode.DEBUGGABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProfilingMode.NOT_SET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProfilingMode.PROFILEABLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

