/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.profiler.AbstractProfilerExecutorGroup;
import com.android.tools.idea.run.profiler.ProfilingMode;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.DefaultExecutorGroup;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u001f !B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\tH\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH\u0016J\b\u0010\u0017\u001a\u00020\tH\u0016J\b\u0010\u0018\u001a\u00020\tH\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\b\u0010\u001a\u001a\u00020\tH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/profilers/ProfileRunExecutorGroup;", "Lcom/android/tools/idea/run/profiler/AbstractProfilerExecutorGroup;", "Lcom/android/tools/idea/profilers/ProfileRunExecutorGroup$ProfilerSetting;", "()V", "createExecutorGroupWrapper", "Lcom/intellij/execution/impl/DefaultExecutorGroup$ExecutorGroupWrapper;", "actionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getActionName", "", "getChildExecutor", "Lcom/intellij/execution/Executor;", "profilingMode", "Lcom/android/tools/idea/run/profiler/ProfilingMode;", "getContextActionId", "getDescription", "getDisabledIcon", "Ljavax/swing/Icon;", "getHelpId", "getIcon", "getId", "getRunToolbarActionText", "param", "getRunToolbarChooserText", "getStartActionText", "getToolWindowIcon", "getToolWindowId", "isApplicable", "", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "GroupWrapper", "ProfilerSetting", "intellij.android.profilersAndroid"})
@SourceDebugExtension(value={"SMAP\nProfileRunExecutorGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileRunExecutorGroup.kt\ncom/android/tools/idea/profilers/ProfileRunExecutorGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n766#2:146\n857#2,2:147\n*S KotlinDebug\n*F\n+ 1 ProfileRunExecutorGroup.kt\ncom/android/tools/idea/profilers/ProfileRunExecutorGroup\n*L\n132#1:146\n132#1:147,2\n*E\n"})
public final class ProfileRunExecutorGroup
extends AbstractProfilerExecutorGroup<ProfilerSetting> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Icon PROFILEABLE_ICON;
    @NotNull
    private static final Icon DEBUGGABLE_ICON;

    public ProfileRunExecutorGroup() {
        this.registerSettings(new ProfilerSetting(ProfilingMode.PROFILEABLE));
        this.registerSettings(new ProfilerSetting(ProfilingMode.DEBUGGABLE));
    }

    @NotNull
    public Icon getIcon() {
        return PROFILEABLE_ICON;
    }

    @NotNull
    public Icon getDisabledIcon() {
        return this.getToolWindowIcon();
    }

    @NotNull
    public String getDescription() {
        return "Profile selected configuration";
    }

    @NotNull
    public String getActionName() {
        return "Profile";
    }

    @NotNull
    public String getId() {
        return "Android Profiler Group";
    }

    @NotNull
    public String getStartActionText() {
        return "Profile";
    }

    @NotNull
    public String getContextActionId() {
        return "ProfileGroupRunClass";
    }

    @Nullable
    public String getHelpId() {
        return null;
    }

    public boolean isApplicable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return AndroidUtils.hasAndroidFacets(project);
    }

    @NotNull
    public String getRunToolbarActionText(@NotNull String param) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        return "Profile";
    }

    @NotNull
    public String getRunToolbarChooserText() {
        return "Profile";
    }

    @NotNull
    public Icon getToolWindowIcon() {
        Icon icon2 = AllIcons.Toolwindows.ToolWindowRun;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ToolWindowRun");
        return icon2;
    }

    @NotNull
    public String getToolWindowId() {
        return "Run";
    }

    @NotNull
    protected DefaultExecutorGroup.ExecutorGroupWrapper createExecutorGroupWrapper(@NotNull ActionGroup actionGroup2) {
        Intrinsics.checkNotNullParameter((Object)actionGroup2, (String)"actionGroup");
        return new GroupWrapper(actionGroup2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Executor getChildExecutor(@NotNull ProfilingMode profilingMode) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)profilingMode), (String)"profilingMode");
        Iterable $this$filter$iv = this.childExecutors();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Executor e = (Executor)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)e.getActionName(), (Object)new ProfilerSetting(profilingMode).getActionName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (Executor)CollectionsKt.first((List)((List)destination$iv$iv));
    }

    @JvmStatic
    @Nullable
    public static final ProfileRunExecutorGroup getInstance() {
        return Companion.getInstance();
    }

    static {
        Icon icon2 = StudioIcons.Shell.Toolbar.PROFILER_LOW_OVERHEAD;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"PROFILER_LOW_OVERHEAD");
        PROFILEABLE_ICON = icon2;
        Icon icon3 = StudioIcons.Shell.Toolbar.PROFILER_DETAILED;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"PROFILER_DETAILED");
        DEBUGGABLE_ICON = icon3;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/profilers/ProfileRunExecutorGroup$Companion;", "", "()V", "DEBUGGABLE_ICON", "Ljavax/swing/Icon;", "PROFILEABLE_ICON", "getInstance", "Lcom/android/tools/idea/profilers/ProfileRunExecutorGroup;", "intellij.android.profilersAndroid"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final ProfileRunExecutorGroup getInstance() {
            Executor executor2 = ExecutorRegistry.getInstance().getExecutorById("Android Profiler Group");
            return executor2 instanceof ProfileRunExecutorGroup ? (ProfileRunExecutorGroup)executor2 : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/profilers/ProfileRunExecutorGroup$GroupWrapper;", "Lcom/intellij/execution/impl/DefaultExecutorGroup$ExecutorGroupWrapper;", "actionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "(Lcom/intellij/openapi/actionSystem/ActionGroup;)V", "groupShouldBeVisible", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "updateDisabledActionPresentation", "", "eventPresentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "intellij.android.profilersAndroid"})
    private static final class GroupWrapper
    extends DefaultExecutorGroup.ExecutorGroupWrapper {
        public GroupWrapper(@NotNull ActionGroup actionGroup2) {
            Intrinsics.checkNotNullParameter((Object)actionGroup2, (String)"actionGroup");
            super(actionGroup2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean groupShouldBeVisible(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            Object object = project;
            if (project == null) return false;
            AndroidProjectSystem androidProjectSystem = ProjectSystemUtil.getProjectSystem((Project)object);
            object = androidProjectSystem;
            if (androidProjectSystem == null) return false;
            boolean bl = object.supportsProfilingMode();
            boolean isProfilingModeSupported = bl;
            if (!isProfilingModeSupported) return false;
            Object t = StudioFlags.PROFILEABLE_BUILDS.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"PROFILEABLE_BUILDS.get()");
            if ((Boolean)t == false) return false;
            return true;
        }

        public void updateDisabledActionPresentation(@NotNull Presentation eventPresentation) {
            Intrinsics.checkNotNullParameter((Object)eventPresentation, (String)"eventPresentation");
            eventPresentation.setIcon(PROFILEABLE_ICON);
            eventPresentation.setText("Profile");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/profilers/ProfileRunExecutorGroup$ProfilerSetting;", "Lcom/android/tools/idea/run/profiler/AbstractProfilerExecutorGroup$AbstractProfilerSetting;", "profilingMode", "Lcom/android/tools/idea/run/profiler/ProfilingMode;", "(Lcom/android/tools/idea/run/profiler/ProfilingMode;)V", "actionName", "", "getActionName", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "startActionText", "getStartActionText", "canRun", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "configurationName", "isApplicable", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.profilersAndroid"})
    public static final class ProfilerSetting
    extends AbstractProfilerExecutorGroup.AbstractProfilerSetting {
        @NotNull
        private final String startActionText;

        public ProfilerSetting(@NotNull ProfilingMode profilingMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)profilingMode), (String)"profilingMode");
            super(profilingMode);
            this.startActionText = "Profile";
        }

        @NotNull
        public String getActionName() {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.getProfilingMode().ordinal()]) {
                case 1 -> "Profile with low overhead";
                case 2 -> "Profile with complete data";
                default -> "Profile";
            };
        }

        @NotNull
        public Icon getIcon() {
            Icon icon2;
            switch (WhenMappings.$EnumSwitchMapping$0[this.getProfilingMode().ordinal()]) {
                case 1: {
                    icon2 = PROFILEABLE_ICON;
                    break;
                }
                case 2: {
                    icon2 = DEBUGGABLE_ICON;
                    break;
                }
                default: {
                    Icon icon3 = StudioIcons.Shell.Toolbar.PROFILER;
                    icon2 = icon3;
                    Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"PROFILER");
                }
            }
            return icon2;
        }

        @NotNull
        public String getStartActionText() {
            return this.startActionText;
        }

        public boolean canRun(@NotNull RunProfile profile2) {
            Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
            return true;
        }

        public boolean isApplicable(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return true;
        }

        @NotNull
        public String getStartActionText(@NotNull String configurationName) {
            Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
            return switch (WhenMappings.$EnumSwitchMapping$0[this.getProfilingMode().ordinal()]) {
                case 1 -> "Profile '" + configurationName + "' with low overhead";
                case 2 -> "Profile '" + configurationName + "' with complete data";
                default -> "Profile '" + configurationName + "'";
            };
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ProfilingMode.values().length];
                try {
                    nArray[ProfilingMode.PROFILEABLE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ProfilingMode.DEBUGGABLE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

