/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.profilers.LegacyCpuTraceRecord;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.profiler.proto.Trace;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J6\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00052\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0004R>\u0010\u0003\u001a2\u0012\u0004\u0012\u00020\u0005\u0012(\u0012&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u00040\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/profilers/LegacyCpuProfilingHandler;", "Lcom/android/ddmlib/ClientData$IMethodProfilingHandler;", "()V", "deviceToProfilingMetadata", "", "Lcom/android/ddmlib/IDevice;", "Lkotlin/Pair;", "", "", "Lcom/android/tools/idea/profilers/LegacyCpuTraceRecord;", "", "Lcom/android/tools/idea/protobuf/ByteString;", "onEndFailure", "", "client", "Lcom/android/ddmlib/Client;", "message", "onStartFailure", "onSuccess", "data", "", "remoteFilePath", "registerDevice", "device", "profilingRecords", "byteCache", "intellij.android.profilersAndroid"})
@SourceDebugExtension(value={"SMAP\nLegacyCpuProfilingHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyCpuProfilingHandler.kt\ncom/android/tools/idea/profilers/LegacyCpuProfilingHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class LegacyCpuProfilingHandler
implements ClientData.IMethodProfilingHandler {
    @NotNull
    public static final LegacyCpuProfilingHandler INSTANCE = new LegacyCpuProfilingHandler();
    @NotNull
    private static final Map<IDevice, Pair<Map<Integer, LegacyCpuTraceRecord>, Map<String, ByteString>>> deviceToProfilingMetadata = new LinkedHashMap();

    private LegacyCpuProfilingHandler() {
    }

    public final void registerDevice(@NotNull IDevice device2, @NotNull Map<Integer, LegacyCpuTraceRecord> profilingRecords, @NotNull Map<String, ByteString> byteCache) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter(profilingRecords, (String)"profilingRecords");
        Intrinsics.checkNotNullParameter(byteCache, (String)"byteCache");
        deviceToProfilingMetadata.put(device2, (Pair<Map<Integer, LegacyCpuTraceRecord>, Map<String, ByteString>>)new Pair(profilingRecords, byteCache));
    }

    public void onSuccess(@NotNull String remoteFilePath, @NotNull Client client2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)remoteFilePath, (String)"remoteFilePath");
            Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
            Pair<Map<Integer, LegacyCpuTraceRecord>, Map<String, ByteString>> pair = deviceToProfilingMetadata.get(client2.getDevice());
            if (pair == null) break block1;
            Pair<Map<Integer, LegacyCpuTraceRecord>, Map<String, ByteString>> pair2 = pair;
            boolean bl = false;
            Map traceRecords = (Map)pair2.component1();
            LegacyCpuTraceRecord legacyCpuTraceRecord = (LegacyCpuTraceRecord)traceRecords.get(client2.getClientData().getPid());
            if (legacyCpuTraceRecord != null) {
                LegacyCpuTraceRecord record = legacyCpuTraceRecord;
                boolean bl2 = false;
                Trace.TraceStopStatus status2 = Trace.TraceStopStatus.newBuilder().setStatus(Trace.TraceStopStatus.Status.CANNOT_COPY_FILE).setErrorMessage("Method profiling: Older devices (API level < 10) are not supported. Please use DDMS.").build();
                Trace.TraceInfo.Builder builder2 = record.getTraceInfo();
                Intrinsics.checkNotNull((Object)builder2);
                builder2.setStopStatus(status2);
                record.getStopLatch().countDown();
            }
        }
    }

    public void onSuccess(@NotNull byte[] data, @NotNull Client client2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
            Pair<Map<Integer, LegacyCpuTraceRecord>, Map<String, ByteString>> pair = deviceToProfilingMetadata.get(client2.getDevice());
            if (pair == null) break block1;
            Pair<Map<Integer, LegacyCpuTraceRecord>, Map<String, ByteString>> pair2 = pair;
            boolean bl = false;
            Map traceRecords = (Map)pair2.component1();
            Map byteCache = (Map)pair2.component2();
            LegacyCpuTraceRecord legacyCpuTraceRecord = (LegacyCpuTraceRecord)traceRecords.get(client2.getClientData().getPid());
            if (legacyCpuTraceRecord != null) {
                LegacyCpuTraceRecord record = legacyCpuTraceRecord;
                boolean bl2 = false;
                Trace.TraceInfo.Builder builder2 = record.getTraceInfo();
                Intrinsics.checkNotNull((Object)builder2);
                Trace.TraceInfo.Builder traceInfo = builder2;
                traceInfo.setStopStatus(Trace.TraceStopStatus.newBuilder().setStatus(Trace.TraceStopStatus.Status.SUCCESS).build());
                Map map2 = byteCache;
                String string = String.valueOf(traceInfo.getTraceId());
                ByteString byteString = ByteString.copyFrom((byte[])data);
                Intrinsics.checkNotNullExpressionValue((Object)byteString, (String)"copyFrom(data)");
                ByteString byteString2 = byteString;
                map2.put(string, byteString2);
                record.getStopLatch().countDown();
            }
        }
    }

    public void onStartFailure(@NotNull Client client2, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
    }

    public void onEndFailure(@NotNull Client client2, @NotNull String message2) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Pair<Map<Integer, LegacyCpuTraceRecord>, Map<String, ByteString>> pair = deviceToProfilingMetadata.get(client2.getDevice());
            if (pair == null) break block3;
            Pair<Map<Integer, LegacyCpuTraceRecord>, Map<String, ByteString>> pair2 = pair;
            boolean bl = false;
            Map traceRecords = (Map)pair2.component1();
            LegacyCpuTraceRecord legacyCpuTraceRecord = (LegacyCpuTraceRecord)traceRecords.get(client2.getClientData().getPid());
            if (legacyCpuTraceRecord != null) {
                LegacyCpuTraceRecord record = legacyCpuTraceRecord;
                boolean bl2 = false;
                if (record.getStartLatch().getCount() > 0L) {
                    record.setStartFailureMessage(message2);
                    record.getStartLatch().countDown();
                } else {
                    Trace.TraceStopStatus status2 = Trace.TraceStopStatus.newBuilder().setStatus(Trace.TraceStopStatus.Status.STOP_COMMAND_FAILED).setErrorMessage("Failed to stop profiling: " + message2).build();
                    Trace.TraceInfo.Builder builder2 = record.getTraceInfo();
                    Intrinsics.checkNotNull((Object)builder2);
                    builder2.setStopStatus(status2);
                    record.getStopLatch().countDown();
                }
            }
        }
    }

    static {
        ClientData.setMethodProfilingHandler((ClientData.IMethodProfilingHandler)INSTANCE);
    }
}

