/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.profilers.ImportDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class IntellijImportDialog
implements ImportDialog {
    private final Project myProject;

    public IntellijImportDialog(@NotNull Project project) {
        this.myProject = project;
    }

    public void open(@NotNull Supplier<String> dialogTitleSupplier, @NotNull List<String> validExtensions, @NotNull Consumer<VirtualFile> fileOpenedCallback) {
        ApplicationManager.getApplication().invokeLater(() -> {
            VirtualFile importDir = this.myProject.getBaseDir();
            if (importDir == null || !importDir.exists()) {
                importDir = VfsUtil.getUserHomeDir();
            }
            FileChooserDescriptor chooserDescriptor = FileChooserDescriptorFactory.createSingleFileDescriptor().withFileFilter(file2 -> validExtensions.stream().anyMatch(extension -> Comparing.equal((String)file2.getExtension(), (String)extension, (boolean)file2.isCaseSensitive()))).withHideIgnored(false);
            chooserDescriptor.setTitle((String)dialogTitleSupplier.get());
            chooserDescriptor.setDescription("Open file from");
            FileChooser.chooseFiles((FileChooserDescriptor)chooserDescriptor, null, (VirtualFile)importDir, files2 -> fileOpenedCallback.accept((VirtualFile)files2.get(0)));
        });
    }
}

