/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.profilers.AndroidProfilerToolWindow;
import com.android.tools.idea.profilers.PreferredProcessInfo;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.ProfilerPreferences;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.sessions.SessionsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.util.Consumer;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/profilers/AndroidProfilerWindowManagerListener;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "profilersView", "Lcom/android/tools/profilers/StudioProfilersView;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/profilers/StudioProfilers;Lcom/android/tools/profilers/StudioProfilersView;)V", "isProfilingActiveBalloonShown", "", "wasWindowExpanded", "stateChanged", "", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "Companion", "intellij.android.profilersAndroid"})
public final class AndroidProfilerWindowManagerListener
implements ToolWindowManagerListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final StudioProfilers profilers;
    @NotNull
    private final StudioProfilersView profilersView;
    private boolean isProfilingActiveBalloonShown;
    private boolean wasWindowExpanded;
    @NotNull
    public static final String HIDE_STOP_PROMPT = "profilers.hide.stop.prompt";

    public AndroidProfilerWindowManagerListener(@NotNull Project project, @NotNull StudioProfilers profilers, @NotNull StudioProfilersView profilersView) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)profilers, (String)"profilers");
        Intrinsics.checkNotNullParameter((Object)profilersView, (String)"profilersView");
        this.project = project;
        this.profilers = profilers;
        this.profilersView = profilersView;
    }

    public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
        Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
        ToolWindow toolWindow = toolWindowManager.getToolWindow("Android Profiler");
        if (toolWindow == null) {
            return;
        }
        ToolWindow window2 = toolWindow;
        boolean hasAliveSession = SessionsManager.isSessionAlive((Common.Session)this.profilers.getSessionsManager().getProfilingSession());
        boolean isWindowTabHidden = !window2.isShowStripeButton();
        boolean isWindowExpanded = window2.isVisible();
        boolean windowVisibilityChanged = isWindowExpanded != this.wasWindowExpanded;
        this.wasWindowExpanded = isWindowExpanded;
        if (isWindowTabHidden) {
            if (hasAliveSession) {
                boolean confirm2;
                boolean hidePrompt = this.profilers.getIdeServices().getTemporaryProfilerPreferences().getBoolean(HIDE_STOP_PROMPT, false);
                boolean bl = confirm2 = hidePrompt || this.profilersView.getIdeProfilerComponents().createUiMessageHandler().displayOkCancelMessage("Confirm Stop Profiling", "Hiding the window will stop the current profiling session. Are you sure?", "Yes", "Cancel", null, new Consumer(this){
                    final /* synthetic */ AndroidProfilerWindowManagerListener this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final void consume(@Nullable Boolean result2) {
                        ProfilerPreferences profilerPreferences = AndroidProfilerWindowManagerListener.access$getProfilers$p(this.this$0).getIdeServices().getTemporaryProfilerPreferences();
                        Boolean bl = result2;
                        Intrinsics.checkNotNull((Object)bl);
                        profilerPreferences.setBoolean("profilers.hide.stop.prompt", bl.booleanValue());
                    }
                });
                if (!confirm2) {
                    window2.setShowStripeButton(true);
                    return;
                }
            }
            this.profilers.stop();
            return;
        }
        if (isWindowExpanded) {
            PreferredProcessInfo processInfo;
            this.isProfilingActiveBalloonShown = false;
            if (windowVisibilityChanged && (processInfo = (PreferredProcessInfo)this.project.getUserData(AndroidProfilerToolWindow.LAST_RUN_APP_INFO)) != null && Intrinsics.areEqual((Object)Common.Session.getDefaultInstance(), (Object)this.profilers.getSession())) {
                this.profilers.setPreferredProcess(processInfo.getDeviceName(), processInfo.getProcessName(), new Predicate(processInfo){
                    final /* synthetic */ PreferredProcessInfo $processInfo;
                    {
                        this.$processInfo = $processInfo;
                    }

                    public final boolean test(@Nullable Common.Process p) {
                        Function1<Common.Process, Boolean> function1 = this.$processInfo.getProcessFilter();
                        Common.Process process2 = p;
                        Intrinsics.checkNotNull((Object)process2);
                        return (Boolean)function1.invoke((Object)process2);
                    }
                });
            }
        } else {
            this.profilers.setAutoProfilingEnabled(false);
            if (hasAliveSession && !this.isProfilingActiveBalloonShown) {
                this.isProfilingActiveBalloonShown = true;
                String messageHtml = "A profiler session is running in the background.<br>To end the session, open the profiler and click the stop button in the Sessions pane.";
                ToolWindowManager toolWindowManager2 = ToolWindowManager.Companion.getInstance(this.project);
                MessageType messageType = MessageType.INFO;
                Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"INFO");
                toolWindowManager2.notifyByBalloon("Android Profiler", messageType, messageHtml);
            }
        }
    }

    public static final /* synthetic */ StudioProfilers access$getProfilers$p(AndroidProfilerWindowManagerListener $this) {
        return $this.profilers;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/profilers/AndroidProfilerWindowManagerListener$Companion;", "", "()V", "HIDE_STOP_PROMPT", "", "intellij.android.profilersAndroid"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

