/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.profilers.AndroidProfilerService;
import com.android.tools.idea.profilers.AndroidProfilerToolWindow;
import com.android.tools.idea.profilers.ToolWindowWrapper;
import com.android.tools.idea.profilers.ToolWindowWrapperImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import icons.StudioIcons;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u00012\u00020\u0002:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/profilers/AndroidProfilerToolWindowFactory;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "()V", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "init", "Companion", "intellij.android.profilersAndroid"})
public final class AndroidProfilerToolWindowFactory
implements DumbAware,
ToolWindowFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "Android Profiler";
    @NotNull
    private static final String PROFILER_TOOL_WINDOW_TITLE = "Profiler";
    @NotNull
    private static final Map<Content, AndroidProfilerToolWindow> PROJECT_PROFILER_MAP = new HashMap();

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                ToolWindow toolWindow = toolWindowManager.getToolWindow("Android Profiler");
                if (toolWindow == null) {
                    return;
                }
                ToolWindow window2 = toolWindow;
                AndroidProfilerToolWindow profilerToolWindow = AndroidProfilerToolWindowFactory.Companion.getProfilerToolWindow(this.$project);
                if (window2.isVisible() && profilerToolWindow == null) {
                    com.android.tools.idea.profilers.AndroidProfilerToolWindowFactory$Companion.access$createContent(AndroidProfilerToolWindowFactory.Companion, this.$project, window2);
                }
            }
        });
    }

    public void init(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        toolWindow.setStripeTitle(PROFILER_TOOL_WINDOW_TITLE);
        toolWindow.setShowStripeButton(true);
        AndroidProfilerService.getInstance();
    }

    @JvmStatic
    @Nullable
    public static final AndroidProfilerToolWindow getProfilerToolWindow(@NotNull Project project) {
        return Companion.getProfilerToolWindow(project);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\rH\u0007J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/profilers/AndroidProfilerToolWindowFactory$Companion;", "", "()V", "ID", "", "PROFILER_TOOL_WINDOW_TITLE", "PROJECT_PROFILER_MAP", "", "Lcom/intellij/ui/content/Content;", "Lcom/android/tools/idea/profilers/AndroidProfilerToolWindow;", "createContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "getProfilerToolWindow", "removeContent", "intellij.android.profilersAndroid"})
    public static final class Companion {
        private Companion() {
        }

        private final void createContent(Project project, ToolWindow toolWindow) {
            ToolWindowWrapper wrapper = new ToolWindowWrapperImpl(project, toolWindow);
            AndroidProfilerToolWindow view = new AndroidProfilerToolWindow(wrapper, project);
            ContentFactory contentFactory = ContentFactory.getInstance();
            Content content2 = contentFactory.createContent(view.getComponent(), "", false);
            Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"contentFactory.createCon\u2026iew.component, \"\", false)");
            Content content3 = content2;
            Disposer.register((Disposable)((Disposable)project), (Disposable)view);
            toolWindow.getContentManager().addContent(content3);
            toolWindow.setIcon(StudioIcons.Shell.ToolWindows.ANDROID_PROFILER);
            PROJECT_PROFILER_MAP.put(content3, view);
            Disposer.register((Disposable)((Disposable)content3), (Disposable)new Disposable(content3){
                final /* synthetic */ Content $content;
                {
                    this.$content = $content;
                }

                public final void dispose() {
                    AndroidProfilerToolWindowFactory.access$getPROJECT_PROFILER_MAP$cp().remove(this.$content);
                }
            });
            toolWindow.show(null);
        }

        @JvmStatic
        @Nullable
        public final AndroidProfilerToolWindow getProfilerToolWindow(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow(AndroidProfilerToolWindowFactory.ID);
            if (toolWindow == null) {
                return null;
            }
            ToolWindow window2 = toolWindow;
            ContentManager contentManager = window2.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"window.contentManager");
            ContentManager contentManager2 = contentManager;
            return contentManager2.getContentCount() == 0 ? null : (AndroidProfilerToolWindow)PROJECT_PROFILER_MAP.get(contentManager2.getContent(0));
        }

        public final void removeContent(@NotNull ToolWindow toolWindow) {
            Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
            if (toolWindow.getContentManager().getContentCount() > 0) {
                Content content2 = toolWindow.getContentManager().getContent(0);
                TypeIntrinsics.asMutableMap((Object)PROJECT_PROFILER_MAP).remove(content2);
                toolWindow.getContentManager().removeAllContents(true);
            }
        }

        public static final /* synthetic */ void access$createContent(Companion $this, Project project, ToolWindow toolWindow) {
            $this.createContent(project, toolWindow);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

