/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.profilers.IntellijProfilerServices;
import com.android.tools.idea.profilers.PreferredProcessInfo;
import com.android.tools.idea.profilers.StudioProfilersWrapper;
import com.android.tools.idea.profilers.ToolWindowWrapper;
import com.android.tools.idea.transport.TransportService;
import com.android.tools.idea.transport.TransportServiceProxy;
import com.android.tools.nativeSymbolizer.ProjectSymbolSource;
import com.android.tools.nativeSymbolizer.SymbolFilesLocator;
import com.android.tools.nativeSymbolizer.SymbolSource;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.Notification;
import com.android.tools.profilers.StudioProfilers;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.BorderLayout;
import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dR\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/profilers/AndroidProfilerToolWindow;", "Lcom/intellij/openapi/Disposable;", "window", "Lcom/android/tools/idea/profilers/ToolWindowWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/android/tools/idea/profilers/ToolWindowWrapper;Lcom/intellij/openapi/project/Project;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "ideProfilerServices", "Lcom/android/tools/idea/profilers/IntellijProfilerServices;", "panel", "Ljavax/swing/JPanel;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "getProfilers", "()Lcom/android/tools/profilers/StudioProfilers;", "profilersWrapper", "Lcom/android/tools/idea/profilers/StudioProfilersWrapper;", "disableAutoProfiling", "", "dispose", "openFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "profile", "processInfo", "Lcom/android/tools/idea/profilers/PreferredProcessInfo;", "Companion", "intellij.android.profilersAndroid"})
public final class AndroidProfilerToolWindow
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ToolWindowWrapper window;
    @NotNull
    private final Project project;
    @NotNull
    private final JPanel panel;
    @NotNull
    private StudioProfilersWrapper profilersWrapper;
    @NotNull
    private final IntellijProfilerServices ideProfilerServices;
    @JvmField
    @NotNull
    public static final Key<PreferredProcessInfo> LAST_RUN_APP_INFO;
    @NotNull
    private static final Notification OPEN_FILE_FAILURE_NOTIFICATION;

    public AndroidProfilerToolWindow(@NotNull ToolWindowWrapper window2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)window2, (String)"window");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.window = window2;
        this.project = project;
        SymbolSource symbolSource = new ProjectSymbolSource(this.project);
        SymbolFilesLocator symbolLocator = new SymbolFilesLocator(symbolSource);
        this.ideProfilerServices = new IntellijProfilerServices(this.project, symbolLocator);
        Disposer.register((Disposable)this, (Disposable)this.ideProfilerServices);
        this.panel = new JPanel(new BorderLayout());
        TransportService.Companion.getInstance();
        this.profilersWrapper = new StudioProfilersWrapper(this.project, this.window, this.ideProfilerServices);
        Disposer.register((Disposable)this, (Disposable)this.profilersWrapper);
        this.panel.removeAll();
        this.panel.add(this.profilersWrapper.getProfilersView().getComponent());
        this.panel.revalidate();
        this.panel.repaint();
    }

    @Nullable
    public final StudioProfilers getProfilers() {
        StudioProfilersWrapper studioProfilersWrapper = this.profilersWrapper;
        return studioProfilersWrapper != null ? studioProfilersWrapper.getProfilers() : null;
    }

    public final void profile(@NotNull PreferredProcessInfo processInfo) {
        Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
        this.profilersWrapper.getProfilers().setPreferredProcess(processInfo.getDeviceName(), processInfo.getProcessName(), new Predicate(processInfo){
            final /* synthetic */ PreferredProcessInfo $processInfo;
            {
                this.$processInfo = $processInfo;
            }

            public final boolean test(@Nullable Common.Process p) {
                Function1<Common.Process, Boolean> function1 = this.$processInfo.getProcessFilter();
                Common.Process process2 = p;
                Intrinsics.checkNotNull((Object)process2);
                return (Boolean)function1.invoke((Object)process2);
            }
        });
    }

    public final void disableAutoProfiling() {
        this.profilersWrapper.getProfilers().setAutoProfilingEnabled(false);
    }

    public final void openFile(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!this.profilersWrapper.getProfilers().getSessionsManager().importSessionFromFile(new File(file2.getPath()))) {
            this.profilersWrapper.getProfilers().getIdeServices().showNotification(OPEN_FILE_FAILURE_NOTIFICATION);
        }
    }

    public void dispose() {
    }

    @NotNull
    public final JComponent getComponent() {
        return this.panel;
    }

    @JvmStatic
    @NotNull
    public static final String getDeviceDisplayName(@NotNull IDevice device2) {
        return Companion.getDeviceDisplayName(device2);
    }

    static {
        Key key = Key.create((String)"Profiler.Last.Run.App");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create<PreferredProcessI\u2026(\"Profiler.Last.Run.App\")");
        LAST_RUN_APP_INFO = key;
        OPEN_FILE_FAILURE_NOTIFICATION = new Notification(Notification.Severity.ERROR, "Failed to open file", "The profiler was unable to open the selected file. Please try opening it again or select a different file.", null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bR#\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/profilers/AndroidProfilerToolWindow$Companion;", "", "()V", "LAST_RUN_APP_INFO", "Lcom/intellij/openapi/util/Key;", "Lcom/android/tools/idea/profilers/PreferredProcessInfo;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "OPEN_FILE_FAILURE_NOTIFICATION", "Lcom/android/tools/profilers/Notification;", "getDeviceDisplayName", "", "device", "Lcom/android/ddmlib/IDevice;", "manufacturer", "model", "serial", "intellij.android.profilersAndroid"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String getDeviceDisplayName(@NotNull IDevice device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            String manufacturer = TransportServiceProxy.Companion.getDeviceManufacturer(device2);
            String model2 = TransportServiceProxy.Companion.getDeviceModel(device2);
            String serial = device2.getSerialNumber();
            Intrinsics.checkNotNullExpressionValue((Object)serial, (String)"serial");
            return this.getDeviceDisplayName(manufacturer, model2, serial);
        }

        @NotNull
        public final String getDeviceDisplayName(@NotNull String manufacturer, @NotNull String model2, @NotNull String serial) {
            Intrinsics.checkNotNullParameter((Object)manufacturer, (String)"manufacturer");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Intrinsics.checkNotNullParameter((Object)serial, (String)"serial");
            String deviceModel = model2;
            StringBuilder deviceNameBuilder = new StringBuilder();
            String string = "-%s";
            Object[] objectArray = new Object[]{serial};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            String suffix = string2;
            if (StringsKt.endsWith$default((String)deviceModel, (String)suffix, (boolean)false, (int)2, null)) {
                String string3 = deviceModel.substring(0, deviceModel.length() - suffix.length());
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                deviceModel = string3;
            }
            if (!StringUtil.isEmpty((String)manufacturer)) {
                String string4 = deviceModel.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                String string5 = manufacturer.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                if (!StringsKt.startsWith$default((String)string4, (String)string5, (boolean)false, (int)2, null)) {
                    deviceNameBuilder.append(manufacturer);
                    deviceNameBuilder.append(" ");
                }
            }
            deviceNameBuilder.append(deviceModel);
            String string6 = deviceNameBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"deviceNameBuilder.toString()");
            return string6;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

