/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable.ui;

import com.android.tools.adtui.LabelWithEditButton;
import com.android.tools.idea.observable.core.StringProperty;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.EditorTextField;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public final class TextProperty
extends StringProperty
implements DocumentListener,
PropertyChangeListener,
com.intellij.openapi.editor.event.DocumentListener {
    @NotNull
    private final JComponent myComponent;

    public TextProperty(@NotNull JTextComponent textComponent) {
        this.myComponent = textComponent;
        textComponent.getDocument().addDocumentListener(this);
    }

    public TextProperty(@NotNull AbstractButton button) {
        this.myComponent = button;
        button.addPropertyChangeListener("text", this);
    }

    public TextProperty(@NotNull JLabel label) {
        this.myComponent = label;
        label.addPropertyChangeListener("text", this);
    }

    public TextProperty(@NotNull LabelWithEditButton editLabel) {
        this.myComponent = editLabel;
        editLabel.getDocument().addDocumentListener(this);
    }

    public TextProperty(@NotNull EditorComboBox editorComboBox) {
        this.myComponent = editorComboBox;
        editorComboBox.getDocument().addDocumentListener((com.intellij.openapi.editor.event.DocumentListener)this);
    }

    public TextProperty(@NotNull EditorTextField editorTextField2) {
        this.myComponent = editorTextField2;
        editorTextField2.getDocument().addDocumentListener((com.intellij.openapi.editor.event.DocumentListener)this);
    }

    public TextProperty(@NotNull TextFieldWithBrowseButton textFieldWithBrowseButton) {
        this(textFieldWithBrowseButton.getTextField());
    }

    @Override
    public void insertUpdate(javax.swing.event.DocumentEvent documentEvent) {
        this.notifyInvalidated();
    }

    @Override
    public void removeUpdate(javax.swing.event.DocumentEvent documentEvent) {
        this.notifyInvalidated();
    }

    @Override
    public void changedUpdate(javax.swing.event.DocumentEvent documentEvent) {
        this.notifyInvalidated();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.notifyInvalidated();
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event2) {
    }

    public void documentChanged(@NotNull DocumentEvent event2) {
        this.notifyInvalidated();
    }

    @Override
    @NotNull
    public String get() {
        if (this.myComponent instanceof JTextComponent) {
            return ((JTextComponent)this.myComponent).getText();
        }
        if (this.myComponent instanceof AbstractButton) {
            return ((AbstractButton)this.myComponent).getText();
        }
        if (this.myComponent instanceof JLabel) {
            return ((JLabel)this.myComponent).getText();
        }
        if (this.myComponent instanceof LabelWithEditButton) {
            return ((LabelWithEditButton)this.myComponent).getText();
        }
        if (this.myComponent instanceof EditorComboBox) {
            return ((EditorComboBox)this.myComponent).getText();
        }
        if (this.myComponent instanceof EditorTextField) {
            return ((EditorTextField)this.myComponent).getText();
        }
        throw new IllegalStateException("Unexpected text component type: " + this.myComponent.getClass().getSimpleName());
    }

    @Override
    protected void setDirectly(@NotNull String value2) {
        if (this.myComponent instanceof JTextComponent) {
            ((JTextComponent)this.myComponent).setText(value2);
        } else if (this.myComponent instanceof AbstractButton) {
            ((AbstractButton)this.myComponent).setText(value2);
        } else if (this.myComponent instanceof JLabel) {
            ((JLabel)this.myComponent).setText(value2);
        } else if (this.myComponent instanceof LabelWithEditButton) {
            ((LabelWithEditButton)this.myComponent).setText(value2);
        } else if (this.myComponent instanceof EditorComboBox) {
            ((EditorComboBox)this.myComponent).setText(value2);
        } else if (this.myComponent instanceof EditorTextField) {
            ((EditorTextField)this.myComponent).setText(value2);
        } else {
            throw new IllegalStateException("Unexpected text component type: " + this.myComponent.getClass().getSimpleName());
        }
    }
}

