/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.UpdatablePackage;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.npw.FormFactorUtilKt;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.model.NewProjectModuleModel;
import com.android.tools.idea.npw.module.AndroidApiLevelComboBoxKt;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.platform.AndroidVersionsInfoKt;
import com.android.tools.idea.npw.project.FormFactorSdkControls;
import com.android.tools.idea.npw.template.components.LanguageComboProvider;
import com.android.tools.idea.npw.validator.ProjectNameValidator;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.wizard.InstallSelectedPackagesStep;
import com.android.tools.idea.sdk.wizard.LicenseAgreementModel;
import com.android.tools.idea.sdk.wizard.LicenseAgreementStep;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.template.BuildConfigurationLanguageForNewProject;
import com.android.tools.idea.wizard.template.Category;
import com.android.tools.idea.wizard.template.FormFactor;
import com.android.tools.idea.wizard.template.Language;
import com.android.tools.idea.wizard.template.Template;
import com.android.tools.idea.wizard.template.TemplateConstraint;
import com.android.tools.idea.wizard.ui.WizardUtils;
import com.google.common.collect.Lists;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureAndroidProjectStep
extends ModelWizardStep<NewProjectModuleModel> {
    private final NewProjectModel myProjectModel;
    private final ValidatorPanel myValidatorPanel;
    private final BindingsManager myBindings;
    private final ListenerManager myListeners;
    private final List<UpdatablePackage> myInstallRequests;
    private final List<RemotePackage> myInstallLicenseRequests;
    @NotNull
    private final JBScrollPane myRootPanel;
    private JPanel myPanel;
    private TextFieldWithBrowseButton myProjectLocation;
    private JTextField myAppName;
    private JTextField myPackageName;
    private JComboBox<Language> myProjectLanguage;
    private JBLabel myProjectLanguageLabel;
    private JBCheckBox myWearCheck;
    private JBCheckBox myTvCheck;
    private JBLabel myTemplateTitle;
    private JBLabel myTemplateDetail;
    private HyperlinkLabel myDocumentationLink;
    private JPanel myFormFactorSdkControlsPanel;
    private JComboBox myMinSdkCombo;
    private JComboBox<BuildConfigurationLanguageForNewProject> myBuildConfigurationLanguageCombo;
    private ContextHelpLabel myBuildConfigurationLanguageLabel;
    private FormFactorSdkControls myFormFactorSdkControls;

    public ConfigureAndroidProjectStep(@NotNull NewProjectModuleModel newProjectModuleModel, @NotNull NewProjectModel projectModel) {
        super(newProjectModuleModel, AndroidBundle.message("android.wizard.project.new.configure", new Object[0]));
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.myInstallRequests = new ArrayList<UpdatablePackage>();
        this.myInstallLicenseRequests = new ArrayList<RemotePackage>();
        this.myProjectModel = projectModel;
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
        this.myRootPanel = WizardUtils.wrapWithVScroll((JPanel)this.myValidatorPanel);
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myRootPanel);
    }

    @Override
    @NotNull
    protected Collection<? extends ModelWizardStep<?>> createDependentSteps() {
        LicenseAgreementStep licenseAgreementStep = new LicenseAgreementStep(new LicenseAgreementModel(AndroidVersionsInfoKt.getSdkManagerLocalPath()), this.myInstallLicenseRequests);
        InstallSelectedPackagesStep installPackagesStep = new InstallSelectedPackagesStep(this.myInstallRequests, new HashSet<LocalPackage>(), AndroidSdks.getInstance().tryToChooseSdkHandler(), false);
        return Lists.newArrayList((Object[])new ModelWizardStep[]{licenseAgreementStep, installPackagesStep});
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        ((GridLayoutManager)this.myPanel.getLayout()).setVGap(2);
        this.myBindings.bindTwoWay(new TextProperty(this.myAppName), this.myProjectModel.getApplicationName());
        String basePackage = NewProjectModel.getSuggestedProjectPackage();
        Expression<String> computedPackageName2 = this.myProjectModel.getApplicationName().transform(appName -> String.format("%s.%s", basePackage, NewProjectModel.nameToJavaPackage(appName)));
        TextProperty packageNameText = new TextProperty(this.myPackageName);
        BoolValueProperty isPackageNameSynced = new BoolValueProperty(true);
        this.myBindings.bind(this.myProjectModel.getPackageName(), packageNameText);
        this.myBindings.bind(packageNameText, computedPackageName2, isPackageNameSynced);
        this.myListeners.listen(packageNameText, value2 -> isPackageNameSynced.set(value2.equals(computedPackageName2.get())));
        Expression<String> computedLocation = this.myProjectModel.getApplicationName().transform(ConfigureAndroidProjectStep::findProjectLocation);
        TextProperty locationText = new TextProperty(this.myProjectLocation.getTextField());
        BoolValueProperty isLocationSynced = new BoolValueProperty(true);
        this.myBindings.bind(locationText, computedLocation, isLocationSynced);
        this.myBindings.bind(this.myProjectModel.getProjectLocation(), locationText);
        this.myListeners.listen(locationText, value2 -> isLocationSynced.set(value2.equals(computedLocation.get())));
        OptionalProperty<AndroidVersionsInfo.VersionItem> androidSdkInfo = ((NewProjectModuleModel)this.getModel()).androidSdkInfo();
        this.myFormFactorSdkControls.init(androidSdkInfo, this);
        this.myBindings.bindTwoWay(new SelectedItemProperty(this.myProjectLanguage), this.myProjectModel.getLanguage());
        if (((Boolean)StudioFlags.NPW_SHOW_KTS_GRADLE_COMBO_BOX.get()).booleanValue()) {
            this.myBuildConfigurationLanguageCombo.addItem(BuildConfigurationLanguageForNewProject.KTS);
            this.myBuildConfigurationLanguageCombo.addItem(BuildConfigurationLanguageForNewProject.KTS_VERSION_CATALOG);
            this.myBuildConfigurationLanguageCombo.addItem(BuildConfigurationLanguageForNewProject.Groovy);
        } else {
            this.myBuildConfigurationLanguageLabel.setVisible(false);
            this.myBuildConfigurationLanguageCombo.setVisible(false);
        }
        this.myValidatorPanel.registerValidator((ObservableValue)this.myProjectModel.getApplicationName(), (Validator)new ProjectNameValidator(), new ObservableValue[0]);
        Expression<Path> locationFile = this.myProjectModel.getProjectLocation().transform(x$0 -> Paths.get(x$0, new String[0]));
        this.myValidatorPanel.registerValidator(locationFile, (Validator)PathValidator.createDefault("project location"), new ObservableValue[0]);
        this.myValidatorPanel.registerValidator((ObservableValue)this.myProjectModel.getPackageName(), value2 -> Validator.Result.fromNullableMessage((String)AndroidUtils.validatePackageName(value2)), new ObservableValue[0]);
        this.myValidatorPanel.registerValidator((ObservableValue)this.myProjectModel.getLanguage(), value2 -> value2.isPresent() ? Validator.Result.OK : new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.validate.select.language", new Object[0])), new ObservableValue[0]);
        this.myValidatorPanel.registerValidator(androidSdkInfo, value2 -> value2.isPresent() ? Validator.Result.OK : new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("select.target.dialog.text", new Object[0])), new ObservableValue[0]);
        this.myValidatorPanel.registerValidator(androidSdkInfo, value2 -> !value2.isPresent() || ConfigureAndroidProjectStep.hasValidSdkComposeVersion((AndroidVersionsInfo.VersionItem)value2.get(), (Template)((NewProjectModuleModel)this.getModel()).newRenderTemplate.getValueOrNull()) ? Validator.Result.OK : new Validator.Result(Validator.Severity.WARNING, AndroidBundle.message("android.wizard.validate.select.compose.sdk", new Object[0])), new ObservableValue[]{((NewProjectModuleModel)this.getModel()).newRenderTemplate});
        this.myProjectLocation.addBrowseFolderListener(null, null, null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myListeners.listenAndFire(((NewProjectModuleModel)this.getModel()).formFactor, () -> {
            FormFactor formFactor = (FormFactor)((NewProjectModuleModel)this.getModel()).formFactor.get();
            this.myFormFactorSdkControls.showStatsPanel(formFactor == FormFactor.Mobile);
            this.myWearCheck.setVisible(formFactor == FormFactor.Wear);
            this.myTvCheck.setVisible(formFactor == FormFactor.Tv);
        });
    }

    @Override
    protected void onEntering() {
        FormFactor formFactor = (FormFactor)((NewProjectModuleModel)this.getModel()).formFactor.get();
        Template newTemplate = (Template)((NewProjectModuleModel)this.getModel()).newRenderTemplate.getValue();
        int minSdk = newTemplate.getMinSdk();
        AndroidApiLevelComboBoxKt.ensureDefaultApiLevelAtLeastRecommended();
        this.myFormFactorSdkControls.startDataLoading(FormFactorUtilKt.toWizardFormFactor(formFactor), minSdk);
        this.setTemplateThumbnail(newTemplate);
        boolean isKotlinOnly = newTemplate.getConstraints().contains(TemplateConstraint.Kotlin);
        this.myProjectLanguage.setVisible(!isKotlinOnly);
        this.myProjectLanguageLabel.setVisible(!isKotlinOnly);
        if (isKotlinOnly) {
            this.myProjectModel.getLanguage().setValue(Language.Kotlin);
        }
    }

    @Override
    protected void onProceeding() {
        ((NewProjectModuleModel)this.getModel()).hasCompanionApp.set(this.myWearCheck.isVisible() && this.myWearCheck.isSelected() || this.myTvCheck.isVisible() && this.myTvCheck.isSelected() || ((NewProjectModuleModel)this.getModel()).formFactor.get() == FormFactor.Automotive);
        if (((Boolean)StudioFlags.NPW_SHOW_KTS_GRADLE_COMBO_BOX.get()).booleanValue() && this.myBuildConfigurationLanguageCombo.getSelectedItem() != null) {
            BuildConfigurationLanguageForNewProject selected = (BuildConfigurationLanguageForNewProject)this.myBuildConfigurationLanguageCombo.getSelectedItem();
            this.myProjectModel.getUseGradleKts().set(selected.getUseKts());
            this.myProjectModel.getUseVersionCatalog().set(selected.getUseVersionCatalog());
        }
        this.myInstallRequests.clear();
        this.myInstallLicenseRequests.clear();
        this.myInstallRequests.addAll(this.myFormFactorSdkControls.getSdkInstallPackageList());
        this.myInstallLicenseRequests.addAll(ContainerUtil.map(this.myInstallRequests, UpdatablePackage::getRemote));
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myRootPanel;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myAppName;
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myValidatorPanel.hasErrors().not();
    }

    @NotNull
    private static String findProjectLocation(@NotNull String applicationName) {
        applicationName = NewProjectModel.sanitizeApplicationName(applicationName);
        File baseDirectory = WizardUtils.getProjectLocationParent();
        File projectDirectory = new File(baseDirectory, applicationName);
        int counter = 2;
        while (projectDirectory.exists()) {
            projectDirectory = new File(baseDirectory, String.format(Locale.US, "%s%d", applicationName, counter++));
        }
        return projectDirectory.getPath();
    }

    private void setTemplateThumbnail(@NotNull Template template) {
        this.myTemplateTitle.setText(template.getName());
        this.myTemplateDetail.setText("<html>" + template.getDescription() + "</html>");
        String documentationUrl = template.getDocumentationUrl();
        if (documentationUrl != null) {
            this.myDocumentationLink.setHyperlinkText(AndroidBundle.message("android.wizard.activity.add.cpp.docslinktext", new Object[0]));
            this.myDocumentationLink.setHyperlinkTarget(documentationUrl);
        }
        this.myDocumentationLink.setVisible(documentationUrl != null);
    }

    private static boolean hasValidSdkComposeVersion(AndroidVersionsInfo.VersionItem skdItem, @Nullable Template renderTemplate2) {
        return renderTemplate2 == null || renderTemplate2.getCategory() != Category.Compose || skdItem.getTargetApiLevel() >= 31;
    }

    private void createUIComponents() {
        this.myProjectLanguage = new LanguageComboProvider().createComponent();
        this.myFormFactorSdkControls = new FormFactorSdkControls();
        this.myFormFactorSdkControlsPanel = this.myFormFactorSdkControls.getRoot();
        this.myMinSdkCombo = this.myFormFactorSdkControls.getMinSdkComboBox();
        this.myBuildConfigurationLanguageLabel = ContextHelpLabel.createWithLink(null, (String)AndroidBundle.message("android.wizard.project.help.buildconfigurationlanguage.description", new Object[0]), (String)"Learn more", () -> BrowserUtil.browse((String)"https://d.android.com/build/migrate-to-kotlin-dsl"));
        this.myBuildConfigurationLanguageLabel.setHorizontalTextPosition(2);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HyperlinkLabel hyperlinkLabel2;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(20, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myAppName = jTextField2 = new JTextField();
        jTextField2.setToolTipText("The name that will be shown in the Android launcher for this application");
        jPanel.add((Component)jTextField2, new GridConstraints(5, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPackageName = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(7, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myProjectLocation = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(9, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JComboBox<Language> jComboBox = this.myProjectLanguage;
        jPanel.add(jComboBox, new GridConstraints(11, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 14), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(8, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 14), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(10, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 14), null));
        JPanel jPanel2 = this.myFormFactorSdkControlsPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(14, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(15, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 14), null));
        Spacer spacer5 = new Spacer();
        jPanel.add((Component)spacer5, new GridConstraints(0, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 20), null));
        this.myWearCheck = jBCheckBox2 = new JBCheckBox();
        Font font = this.$$$getFont$$$(null, 0, -1, jBCheckBox2.getFont());
        if (font != null) {
            jBCheckBox2.setFont(font);
        }
        jBCheckBox2.setLabel("Pair with Empty Phone app");
        jBCheckBox2.setText("Pair with Empty Phone app");
        jPanel.add((Component)jBCheckBox2, new GridConstraints(16, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTvCheck = jBCheckBox = new JBCheckBox();
        Font font2 = this.$$$getFont$$$(null, 0, -1, jBCheckBox.getFont());
        if (font2 != null) {
            jBCheckBox.setFont(font2);
        }
        jBCheckBox.setLabel("Pair with companion Phone app");
        jBCheckBox.setText("Pair with companion Phone app");
        jPanel.add((Component)jBCheckBox, new GridConstraints(17, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel.add((Component)spacer6, new GridConstraints(19, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        Font font3 = this.$$$getFont$$$(null, 0, -1, jBLabel4.getFont());
        if (font3 != null) {
            jBLabel4.setFont(font3);
        }
        jBLabel4.setText("Name");
        jBLabel4.setDisplayedMnemonic('N');
        jBLabel4.setDisplayedMnemonicIndex(0);
        jBLabel4.setVerticalAlignment(0);
        jPanel.add((Component)jBLabel4, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(-1, 24), null));
        JBLabel jBLabel5 = new JBLabel();
        Font font4 = this.$$$getFont$$$(null, 0, -1, jBLabel5.getFont());
        if (font4 != null) {
            jBLabel5.setFont(font4);
        }
        jBLabel5.setText("Package name");
        jBLabel5.setDisplayedMnemonic('P');
        jBLabel5.setDisplayedMnemonicIndex(0);
        jBLabel5.setVerticalAlignment(0);
        jPanel.add((Component)jBLabel5, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        Font font5 = this.$$$getFont$$$(null, 0, -1, jBLabel6.getFont());
        if (font5 != null) {
            jBLabel6.setFont(font5);
        }
        jBLabel6.setText("Save location");
        jBLabel6.setDisplayedMnemonic('S');
        jBLabel6.setDisplayedMnemonicIndex(0);
        jBLabel6.setVerticalAlignment(0);
        jPanel.add((Component)jBLabel6, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProjectLanguageLabel = jBLabel3 = new JBLabel();
        Font font6 = this.$$$getFont$$$(null, 0, -1, jBLabel3.getFont());
        if (font6 != null) {
            jBLabel3.setFont(font6);
        }
        jBLabel3.setText("Language");
        jBLabel3.setDisplayedMnemonic('L');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jBLabel3.setVerticalAlignment(0);
        jPanel.add((Component)jBLabel3, new GridConstraints(11, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel.add((Component)spacer7, new GridConstraints(12, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 14), null));
        this.myTemplateTitle = jBLabel2 = new JBLabel();
        Font font7 = this.$$$getFont$$$(null, 1, -1, jBLabel2.getFont());
        if (font7 != null) {
            jBLabel2.setFont(font7);
        }
        jBLabel2.setText("Template title");
        jBLabel2.setVerticalAlignment(0);
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, new Dimension(-1, 24), null));
        Spacer spacer8 = new Spacer();
        jPanel.add((Component)spacer8, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 14), null));
        Spacer spacer9 = new Spacer();
        jPanel.add((Component)spacer9, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 14), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myTemplateDetail = jBLabel = new JBLabel();
        Font font8 = this.$$$getFont$$$(null, 0, -1, jBLabel.getFont());
        if (font8 != null) {
            jBLabel.setFont(font8);
        }
        jBLabel.setText("Template detail");
        jBLabel.setVerticalAlignment(0);
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 7, 0, null, new Dimension(-1, 24), null));
        this.myDocumentationLink = hyperlinkLabel2 = new HyperlinkLabel();
        hyperlinkLabel2.setText("");
        jPanel3.add((Component)hyperlinkLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 7, 0, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        Font font9 = this.$$$getFont$$$(null, 0, -1, jBLabel7.getFont());
        if (font9 != null) {
            jBLabel7.setFont(font9);
        }
        jBLabel7.setText("Minimum SDK");
        jBLabel7.setVerticalAlignment(0);
        jPanel.add((Component)jBLabel7, new GridConstraints(13, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox2 = this.myMinSdkCombo;
        jPanel.add((Component)jComboBox2, new GridConstraints(13, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JComboBox jComboBox3 = new JComboBox();
        this.myBuildConfigurationLanguageCombo = jComboBox3;
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox3.setModel(defaultComboBoxModel);
        jComboBox3.setName("buildConfigurationLanguageCombo");
        jPanel.add(jComboBox3, new GridConstraints(18, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        ContextHelpLabel contextHelpLabel = this.myBuildConfigurationLanguageLabel;
        contextHelpLabel.setText("Build configuration language");
        jPanel.add((Component)contextHelpLabel, new GridConstraints(18, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jBLabel4.setLabelFor(jTextField2);
        jBLabel5.setLabelFor(jTextField);
        jBLabel6.setLabelFor((Component)textFieldWithBrowseButton);
        jBLabel3.setLabelFor(jComboBox);
        jBLabel2.setLabelFor(jTextField2);
        jBLabel.setLabelFor(jTextField2);
        jBLabel7.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }
}

