/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.icon.IconGeneratorResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.SwingWorker;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconGenerationProcessor {
    @Nullable
    private Request myQueuedRequest;
    @Nullable
    private Request myRunningRequest;

    public void enqueue(@NotNull IconGenerator iconGenerator, @NotNull Consumer<IconGeneratorResult> onDone) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (((Optional)iconGenerator.sourceAsset().get()).isPresent()) {
            IconGenerator.IconOptions options2 = iconGenerator.createOptions(true);
            this.myQueuedRequest = new Request(iconGenerator, options2, onDone);
        }
        this.processNextRequest();
    }

    private void processNextRequest() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myQueuedRequest == null) {
            return;
        }
        if (this.myRunningRequest != null) {
            this.myRunningRequest.cancel();
        }
        this.myRunningRequest = this.myQueuedRequest;
        this.myQueuedRequest = null;
        Request request2 = this.myRunningRequest;
        if (request2 != null) {
            Worker worker = new Worker(request2, () -> {
                ApplicationManager.getApplication().assertIsDispatchThread();
                this.myRunningRequest = null;
                this.processNextRequest();
            });
            worker.start();
        }
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(IconGenerationProcessor.class);
    }

    private static class Request {
        @NotNull
        private final IconGenerator myIconGenerator;
        @NotNull
        private final Consumer<IconGeneratorResult> myOnDone;
        @NotNull
        private final IconGenerator.IconOptions myOptions;
        @Nullable
        private IconGeneratorResult myGeneratorResult;
        private boolean isCanceled;

        Request(@NotNull IconGenerator iconGenerator, @NotNull IconGenerator.IconOptions options2, @NotNull Consumer<IconGeneratorResult> onDone) {
            this.myIconGenerator = iconGenerator;
            this.myOptions = options2;
            this.myOnDone = onDone;
        }

        public void run() {
            assert (!ApplicationManager.getApplication().isDispatchThread());
            this.myGeneratorResult = this.myIconGenerator.generateIcons(this.myOptions);
        }

        public void done() {
            if (!this.isCanceled) {
                this.myOnDone.accept(this.myGeneratorResult);
            }
        }

        public void cancel() {
            this.isCanceled = true;
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }
    }

    private static class Worker
    extends SwingWorker<Request> {
        @NotNull
        private final Request myRequest;
        @NotNull
        private final Runnable myOnDone;

        Worker(@NotNull Request request2, @NotNull Runnable onDone) {
            this.myRequest = request2;
            this.myOnDone = onDone;
        }

        @NotNull
        public Request construct() {
            long start2 = System.currentTimeMillis();
            this.myRequest.run();
            long end = System.currentTimeMillis();
            IconGenerationProcessor.getLog().info(String.format(Locale.US, "Icons generated in %.2g sec", (double)(end - start2) / 1000.0));
            return this.myRequest;
        }

        public void finished() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            try {
                this.myRequest.done();
            }
            finally {
                ApplicationManager.getApplication().invokeLater(this.myOnDone, ModalityState.any());
            }
        }
    }
}

