/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.resources.Density;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import java.io.File;
import java.util.Comparator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DensityAwareFileComparator
implements Comparator<File> {
    @NotNull
    private final Set<File> myDirectories;

    public DensityAwareFileComparator(@NotNull Set<File> directories2) {
        this.myDirectories = directories2;
    }

    @Override
    public int compare(@NotNull File file1, @NotNull File file2) {
        Density density2;
        int c = -Boolean.compare(this.myDirectories.contains(file1), this.myDirectories.contains(file2));
        if (c != 0) {
            return c;
        }
        String path1 = file1.getAbsolutePath();
        String path2 = file2.getAbsolutePath();
        Density density1 = IconGenerator.pathToDensity(path1 + File.separator);
        c = Boolean.compare(density1 != null, (density2 = IconGenerator.pathToDensity(path2 + File.separator)) != null);
        if (c != 0) {
            return c;
        }
        if (density1 != null && density2 != null && density1 != density2) {
            return Integer.compare(density2.getDpiValue(), density1.getDpiValue());
        }
        return path1.compareTo(path2);
    }
}

