/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.tools.idea.npw.assetstudio.assets.VectorAsset;
import com.android.tools.idea.npw.assetstudio.ui.AssetComponent;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ui.TextProperty;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class VectorAssetBrowser
extends TextFieldWithBrowseButton
implements AssetComponent<VectorAsset>,
Disposable {
    @NotNull
    private final VectorAsset myAsset = new VectorAsset();
    @NotNull
    private final BindingsManager myBindings = new BindingsManager();
    @NotNull
    private final List<ActionListener> myAssetListeners = new ArrayList<ActionListener>(1);

    public VectorAssetBrowser() {
        this.addBrowseFolderListener(null, null, null, VectorAssetBrowser.createFileDescriptor("svg", "psd"));
        TextProperty imagePathText = new TextProperty(this.getTextField());
        this.myBindings.bind(imagePathText, this.myAsset.path().transform(file2 -> file2.map(File::getAbsolutePath).orElse("")));
        this.myBindings.bind(this.myAsset.path(), imagePathText.transform(s -> StringUtil.isEmptyOrSpaces((String)s) ? Optional.empty() : Optional.of(new File(s.trim()))));
        this.myAsset.path().addListener(() -> {
            ActionEvent e = new ActionEvent(this, 1001, null);
            for (ActionListener listener2 : this.myAssetListeners) {
                listener2.actionPerformed(e);
            }
        });
    }

    @Override
    @NotNull
    public VectorAsset getAsset() {
        return this.myAsset;
    }

    @Override
    public void addAssetListener(@NotNull ActionListener l) {
        this.myAssetListeners.add(l);
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myAssetListeners.clear();
    }

    private static FileChooserDescriptor createFileDescriptor(String ... extensions) {
        return FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withFileFilter(file2 -> Arrays.stream(extensions).anyMatch(e -> Comparing.equal((String)file2.getExtension(), (String)e, (boolean)file2.isCaseSensitive())));
    }
}

