/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.idea.npw.assetstudio.assets.TextAsset;
import com.android.tools.idea.npw.assetstudio.ui.AssetComponent;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.ArrayUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public final class MultiLineTextAssetEditor
extends JPanel
implements AssetComponent<TextAsset> {
    private final TextAsset myTextAsset = new TextAsset();
    private final BindingsManager myBindings = new BindingsManager();
    private final List<ActionListener> myListeners = new ArrayList<ActionListener>(1);

    public MultiLineTextAssetEditor() {
        super((LayoutManager)new TabularLayout("4px,120px,*"));
        JPanel spacer = new JPanel();
        JTextPane textPane = new JTextPane();
        textPane.setBackground((Color)JBColor.WHITE);
        textPane.setBorder((Border)new CustomLineBorder(JBColor.border(), 1, 1, 1, 1));
        List<String> fontFamilies = TextAsset.getAllFontFamilies();
        ComboBox fontCombo = new ComboBox((Object[])ArrayUtil.toStringArray(fontFamilies));
        this.add((Component)spacer, new TabularLayout.Constraint(0, 0));
        this.add((Component)textPane, new TabularLayout.Constraint(0, 1));
        this.add((Component)fontCombo, new TabularLayout.Constraint(0, 2));
        this.myBindings.bindTwoWay(new TextProperty(textPane), this.myTextAsset.text());
        SelectedItemProperty selectedFont = new SelectedItemProperty((JComboBox)fontCombo);
        this.myBindings.bindTwoWay(ObjectProperty.wrap(selectedFont), this.myTextAsset.fontFamily());
        InvalidationListener onTextChanged = () -> {
            ActionEvent e = new ActionEvent(this, 1001, null);
            for (ActionListener listener2 : this.myListeners) {
                listener2.actionPerformed(e);
            }
        };
        this.myTextAsset.text().addListener(onTextChanged);
        this.myTextAsset.fontFamily().addListener(onTextChanged);
    }

    @Override
    @NotNull
    public TextAsset getAsset() {
        return this.myTextAsset;
    }

    @Override
    public void addAssetListener(@NotNull ActionListener listener2) {
        this.myListeners.add(listener2);
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.clear();
    }
}

