/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class TextRenderUtil {
    public static BufferedImage renderTextImage(String text2, int paddingPercentage, Options options2) {
        if (options2 == null) {
            options2 = new Options();
        }
        BufferedImage tempImage = AssetUtil.newArgbBufferedImage((int)1, (int)1);
        if (text2 == null || text2.isEmpty()) {
            return tempImage;
        }
        Graphics2D tempG = (Graphics2D)tempImage.getGraphics();
        Font font = options2.font;
        if (font == null) {
            font = new Font(options2.fontName, options2.fontStyle, options2.fontSize);
        }
        FontRenderContext frc = tempG.getFontRenderContext();
        TextLayout layout = new TextLayout(text2, font, frc);
        Rectangle2D bounds = layout.getBounds();
        if (paddingPercentage != 0) {
            double minDimension = Math.min(bounds.getWidth(), bounds.getHeight());
            double delta = minDimension * (double)paddingPercentage / 100.0;
            bounds.setRect(bounds.getMinX() - delta, bounds.getMinY() - delta, bounds.getWidth() + 2.0 * delta, bounds.getHeight() + 2.0 * delta);
        }
        BufferedImage image = AssetUtil.newArgbBufferedImage((int)Math.max(1, (int)bounds.getWidth()), (int)Math.max(1, (int)bounds.getHeight()));
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setColor((Color)new JBColor(new Color(options2.foregroundColor, true), new Color(options2.backgroundColor, true)));
        g.setFont(font);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.drawString(text2, (float)(-bounds.getX()), (float)(-bounds.getY()));
        g.dispose();
        tempG.dispose();
        return image;
    }

    public static class Options {
        private static final int DEFAULT_FONT_SIZE = 512;
        public int foregroundColor = -1;
        public int backgroundColor = -16777216;
        public Font font = null;
        public String fontName = "Serif";
        public int fontStyle = 0;
        public int fontSize = 512;
    }
}

