/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.npw.assetstudio.AnnotatedImage;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.TransformedImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.icon.CategoryIconMap;
import com.android.tools.idea.npw.assetstudio.icon.IconGeneratorResult;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.projectsystem.AndroidModulePaths;
import com.android.tools.lint.checks.ApiLookup;
import com.android.utils.CharSequences;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class IconGenerator
implements Disposable {
    protected static final ImmutableSet<Density> DENSITIES = ImmutableSet.of((Object)Density.MEDIUM, (Object)Density.HIGH, (Object)Density.XHIGH, (Object)Density.XXHIGH, (Object)Density.XXXHIGH);
    private static final Map<Density, Pattern> DENSITY_PATTERNS;
    protected static final AnnotatedImage PLACEHOLDER_IMAGE;
    private final OptionalProperty<BaseAsset> mySourceAsset = new OptionalValueProperty<BaseAsset>();
    private final StringProperty myOutputName = new StringValueProperty();
    protected final int myMinSdkVersion;
    @NotNull
    private final GraphicGeneratorContext myContext;
    @NotNull
    private final AtomicNullableLazyValue<ApiLookup> myApiLookup;
    @NotNull
    protected final String myLineSeparator;

    public IconGenerator(final @NotNull Project project, int minSdkVersion2, @NotNull GraphicGeneratorContext context2) {
        this.myMinSdkVersion = minSdkVersion2;
        this.myContext = context2;
        this.myApiLookup = new AtomicNullableLazyValue<ApiLookup>(){

            @Nullable
            protected ApiLookup compute() {
                return LintIdeClient.getApiLookup((Project)project);
            }
        };
        this.myLineSeparator = CodeStyle.getSettings((Project)project).getLineSeparator();
    }

    public void dispose() {
    }

    @NotNull
    public GraphicGeneratorContext getGraphicGeneratorContext() {
        return this.myContext;
    }

    @NotNull
    public final OptionalProperty<BaseAsset> sourceAsset() {
        return this.mySourceAsset;
    }

    @NotNull
    public final StringProperty outputName() {
        return this.myOutputName;
    }

    @NotNull
    public IconGeneratorResult generateIcons(@NotNull IconOptions options2) {
        return new IconGeneratorResult(this.generateIcons(this.myContext, options2, (String)this.myOutputName.get()), options2);
    }

    @NotNull
    private CategoryIconMap generateIntoMemory() {
        if (((Optional)this.mySourceAsset.get()).isEmpty()) {
            throw new IllegalStateException("Can't generate icons without a source asset set first");
        }
        IconOptions options2 = this.createOptions(false);
        return this.generateIntoMemory(options2);
    }

    @NotNull
    private CategoryIconMap generateIntoMemory(@NotNull IconOptions options2) {
        HashMap<String, Map<String, AnnotatedImage>> categoryMap = new HashMap<String, Map<String, AnnotatedImage>>();
        this.generateRasterImage(null, categoryMap, this.myContext, options2, (String)this.myOutputName.get());
        return new CategoryIconMap(categoryMap);
    }

    @NotNull
    public final Map<File, BufferedImage> generateIntoFileMap(@NotNull File resDirectory) {
        if (((String)this.myOutputName.get()).isEmpty()) {
            throw new IllegalStateException("Can't save icons to disk if a filename isn't set first");
        }
        if (resDirectory.getParentFile() == null) {
            throw new IllegalArgumentException("Invalid paths used when trying to generate an icon");
        }
        CategoryIconMap categoryIconMap = this.generateIntoMemory();
        return categoryIconMap.toFileMap(resDirectory);
    }

    @NotNull
    public Map<File, GeneratedIcon> generateIntoIconMap(@NotNull AndroidModulePaths paths, @NotNull File resFolder) {
        IconOptions options2 = this.createOptions(false);
        return this.generateIntoIconMap(paths, resFolder, options2);
    }

    @NotNull
    public final Map<File, GeneratedIcon> generateIconPlaceholders(@NotNull AndroidModulePaths paths, @NotNull File resFolder) {
        if (((String)this.myOutputName.get()).isEmpty()) {
            return Collections.emptyMap();
        }
        IconOptions options2 = this.createOptions(false);
        options2.usePlaceholders = true;
        return this.generateIntoIconMap(paths, resFolder, options2);
    }

    @NotNull
    private Map<File, GeneratedIcon> generateIntoIconMap(@NotNull AndroidModulePaths paths, @NotNull File resFolder, @NotNull IconOptions options2) {
        if (((String)this.myOutputName.get()).isEmpty()) {
            throw new IllegalStateException("Can't save icons to disk if a filename isn't set first");
        }
        IconGeneratorResult icons = this.generateIcons(options2);
        HashMap<File, GeneratedIcon> outputMap = new HashMap<File, GeneratedIcon>();
        icons.getIcons().forEach(icon2 -> {
            PathString relativePath = icon2.getOutputPath();
            if (relativePath != null && icon2.getCategory() != IconCategory.PREVIEW) {
                File path2 = new File(IconGenerator.getBaseDirectory(paths, resFolder, icon2.getCategory()), relativePath.getNativePath());
                outputMap.put(path2, (GeneratedIcon)icon2);
            }
        });
        return outputMap;
    }

    @NotNull
    private static File getBaseDirectory(@NotNull AndroidModulePaths paths, @NotNull File resFolder, @NotNull IconCategory category) {
        File dir;
        if (category == IconCategory.PLAY_STORE) {
            dir = paths.getManifestDirectory();
            if (dir != null) {
                return dir;
            }
            dir = resFolder.getParentFile();
        } else {
            dir = resFolder;
        }
        if (dir == null) {
            throw new IllegalArgumentException("Invalid paths used when trying to generate an icon");
        }
        return dir;
    }

    public void generateIconsToDisk(@NotNull AndroidModulePaths paths, @NotNull File resFolder) {
        Map<File, GeneratedIcon> pathIconMap = this.generateIntoIconMap(paths, resFolder);
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (Map.Entry fileImageEntry : pathIconMap.entrySet()) {
                File file2 = (File)fileImageEntry.getKey();
                GeneratedIcon icon2 = (GeneratedIcon)fileImageEntry.getValue();
                if (icon2 instanceof GeneratedImageIcon) {
                    if (FileUtilRt.extensionEquals((String)file2.getName(), (String)"png")) {
                        this.writePngToDisk(file2, ((GeneratedImageIcon)icon2).getImage());
                        continue;
                    }
                    if (FileUtilRt.extensionEquals((String)file2.getName(), (String)"webp")) {
                        this.writeWebpToDisk(file2, ((GeneratedImageIcon)icon2).getImage());
                        continue;
                    }
                    IconGenerator.getLog().error("Please report this error. Unable to create icon for invalid file: " + file2.getAbsolutePath());
                    continue;
                }
                if (icon2 instanceof GeneratedXmlResource) {
                    if (FileUtilRt.extensionEquals((String)file2.getName(), (String)"xml")) {
                        this.writeTextToDisk(file2, ((GeneratedXmlResource)icon2).getXmlText());
                        continue;
                    }
                    IconGenerator.getLog().error("Please report this error. Unable to create icon for invalid file: " + file2.getAbsolutePath());
                    continue;
                }
                IconGenerator.getLog().error("Please report this error. Unable to create icon for invalid file: " + file2.getAbsolutePath());
            }
        });
    }

    private void writePngToDisk(@NotNull File file2, @NotNull BufferedImage image) {
        try {
            VirtualFile directory = VfsUtil.createDirectories((String)file2.getParentFile().getAbsolutePath());
            VirtualFile virtualFile = directory.findChild(file2.getName());
            if (virtualFile == null || !virtualFile.exists()) {
                virtualFile = directory.createChildData((Object)this, file2.getName());
            }
            try (OutputStream outputStream = virtualFile.getOutputStream((Object)this);){
                ImageIO.write((RenderedImage)image, "PNG", outputStream);
            }
        }
        catch (IOException e) {
            IconGenerator.getLog().error((Throwable)e);
        }
    }

    private void writeWebpToDisk(@NotNull File file2, @NotNull BufferedImage image) {
        try {
            VirtualFile directory = VfsUtil.createDirectories((String)file2.getParentFile().getAbsolutePath());
            VirtualFile virtualFile = directory.findChild(file2.getName());
            if (virtualFile == null || !virtualFile.exists()) {
                virtualFile = directory.createChildData((Object)this, file2.getName());
            }
            try (OutputStream outputStream = virtualFile.getOutputStream((Object)this);){
                ImageIO.write((RenderedImage)image, "WEBP", outputStream);
            }
        }
        catch (IOException e) {
            IconGenerator.getLog().error((Throwable)e);
        }
    }

    private void writeTextToDisk(@NotNull File file2, @NotNull String text2) {
        try {
            VirtualFile directory = VfsUtil.createDirectories((String)file2.getParentFile().getAbsolutePath());
            VirtualFile virtualFile = directory.findChild(file2.getName());
            if (virtualFile == null || !virtualFile.exists()) {
                virtualFile = directory.createChildData((Object)this, file2.getName());
            }
            try (OutputStream outputStream = virtualFile.getOutputStream((Object)this);){
                byte[] bytes2 = text2.getBytes(StandardCharsets.UTF_8);
                outputStream.write(bytes2);
            }
        }
        catch (IOException e) {
            IconGenerator.getLog().error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<GeneratedIcon> generateIcons(@NotNull GraphicGeneratorContext context2, @NotNull IconOptions options2, @NotNull String name2) {
        List<Callable<GeneratedIcon>> tasks = this.createIconGenerationTasks(context2, options2, name2);
        ArrayList<Future> futures = new ArrayList<Future>(tasks.size());
        ArrayList<GeneratedIcon> icons = new ArrayList<GeneratedIcon>(tasks.size());
        Disposable taskCanceler = () -> {
            List list2 = futures;
            synchronized (list2) {
                for (Future f : futures) {
                    f.cancel(true);
                }
            }
        };
        Disposer.register((Disposable)this, (Disposable)taskCanceler);
        ArrayList<Future> arrayList = futures;
        synchronized (arrayList) {
            for (Callable<GeneratedIcon> task2 : tasks) {
                futures.add(ApplicationManager.getApplication().executeOnPooledThread(task2));
            }
        }
        for (Future future2 : futures) {
            try {
                icons.add((GeneratedIcon)future2.get());
            }
            catch (InterruptedException | ExecutionException e) {
                Disposer.dispose((Disposable)taskCanceler);
            }
        }
        return icons;
    }

    @NotNull
    protected List<Callable<GeneratedIcon>> createIconGenerationTasks(@NotNull GraphicGeneratorContext context2, @NotNull IconOptions options2, @NotNull String name2) {
        TransformedImageAsset imageAsset = options2.image;
        if (imageAsset == null) {
            return Collections.emptyList();
        }
        ArrayList<Callable<GeneratedIcon>> tasks = new ArrayList<Callable<GeneratedIcon>>();
        for (Density density : DENSITIES) {
            Density outputDensity;
            IconOptions localOptions = options2.clone();
            localOptions.density = density;
            Density density2 = outputDensity = density == Density.XXXHIGH && imageAsset.isDrawable() ? Density.ANYDPI : density;
            if (options2.generateOutputIcons) {
                if (outputDensity == Density.ANYDPI) {
                    tasks.add(() -> {
                        IconOptions iconOptions = options2.clone();
                        iconOptions.density = Density.ANYDPI;
                        String xmlDrawableText = imageAsset.getTransformedDrawable();
                        assert (xmlDrawableText != null);
                        iconOptions.apiVersion = this.calculateMinRequiredApiLevel(xmlDrawableText, this.myMinSdkVersion);
                        return new GeneratedXmlResource(name2, new PathString(this.getIconPath(iconOptions, name2)), IconCategory.REGULAR, xmlDrawableText);
                    });
                } else {
                    tasks.add(() -> {
                        AnnotatedImage foregroundImage = this.generateRasterImage(context2, localOptions);
                        return new GeneratedImageIcon(name2, new PathString(this.getIconPath(localOptions, name2)), IconCategory.REGULAR, density, foregroundImage);
                    });
                }
            }
            if (!options2.generatePreviewIcons) continue;
            tasks.add(() -> {
                AnnotatedImage image;
                try {
                    image = this.generateRasterImage(context2, localOptions);
                }
                catch (Throwable e) {
                    IconGenerator.getLog().error(e);
                    image = IconGenerator.createPlaceholderErrorImage(e, localOptions);
                }
                return new GeneratedImageIcon(outputDensity.getResourceValue(), null, IconCategory.PREVIEW, density, image);
            });
        }
        return tasks;
    }

    @NotNull
    protected static AnnotatedImage createPlaceholderErrorImage(@NotNull Throwable e, @NotNull IconOptions options2) {
        StringBuilder errorMessage = new StringBuilder("Preview rendering error: ");
        String message2 = e.getMessage();
        if (message2 == null) {
            message2 = e.getClass().getSimpleName();
        }
        errorMessage.append(message2);
        Throwable cause = e.getCause();
        if (cause != null && (message2 = cause.getMessage()) != null) {
            errorMessage.append(": ").append(message2);
        }
        double scaleFactor = IconGenerator.getMdpiScaleFactor(options2.density);
        int size = AssetStudioUtils.roundToInt(24.0 * scaleFactor);
        return new AnnotatedImage(AssetUtil.newArgbBufferedImage((int)size, (int)size), errorMessage.toString());
    }

    @NotNull
    public abstract AnnotatedImage generateRasterImage(@NotNull GraphicGeneratorContext var1, @NotNull IconOptions var2);

    @NotNull
    protected AnnotatedImage generateRasterImage(@NotNull Dimension iconSize, @NotNull IconOptions options2) {
        BufferedImage image;
        if (options2.usePlaceholders) {
            return PLACEHOLDER_IMAGE;
        }
        double scaleFactor = IconGenerator.getMdpiScaleFactor(options2.density);
        Dimension imageSize = AssetStudioUtils.scaleDimension(iconSize, scaleFactor);
        TransformedImageAsset imageAsset = options2.image;
        if (imageAsset == null) {
            return PLACEHOLDER_IMAGE;
        }
        Object errorMessage = null;
        try {
            image = imageAsset.getTransformedImage(imageSize);
        }
        catch (RuntimeException e) {
            errorMessage = imageAsset.isDrawable() ? "Unable to generate image, possibly invalid drawable" : "Failed to transform %s image";
            String exceptionMessage = e.getMessage();
            if (exceptionMessage != null) {
                errorMessage = (String)errorMessage + ": " + exceptionMessage;
            }
            image = imageAsset.createErrorImage(imageSize);
        }
        return new AnnotatedImage(image, (String)errorMessage);
    }

    @NotNull
    public abstract IconOptions createOptions(boolean var1);

    @NotNull
    protected String getIconPath(@NotNull IconOptions options2, @NotNull String iconName) {
        return this.getIconFolder(options2) + "/" + IconGenerator.getIconFileName(options2, iconName);
    }

    @NotNull
    private static String getIconFileName(@NotNull IconOptions options2, @NotNull String iconName) {
        if (options2.density == Density.ANYDPI) {
            return iconName + ".xml";
        }
        if (options2.generateWebpIcons) {
            return iconName + ".webp";
        }
        return iconName + ".png";
    }

    @NotNull
    protected String getIconFolder(@NotNull IconOptions options2) {
        switch (options2.iconFolderKind) {
            case DRAWABLE: {
                return IconGenerator.getIconFolder(ResourceFolderType.DRAWABLE, options2.density, options2.apiVersion);
            }
            case MIPMAP: {
                return IconGenerator.getIconFolder(ResourceFolderType.MIPMAP, options2.density, options2.apiVersion);
            }
            case DRAWABLE_NO_DPI: {
                return IconGenerator.getIconFolder(ResourceFolderType.DRAWABLE, Density.NODPI, options2.apiVersion);
            }
            case VALUES: {
                return IconGenerator.getIconFolder(ResourceFolderType.VALUES, Density.NODPI, options2.apiVersion);
            }
        }
        throw new IllegalArgumentException("Unexpected folder kind: " + options2.iconFolderKind);
    }

    @NotNull
    private static String getIconFolder(@NotNull ResourceFolderType folderType, @NotNull Density density, int apiVersion) {
        StringBuilder buf = new StringBuilder(50);
        buf.append(folderType.getName());
        if (density != Density.NODPI) {
            buf.append('-');
            buf.append(density.getResourceValue());
        }
        if (apiVersion > 1) {
            buf.append("-v");
            buf.append(apiVersion);
        }
        return buf.toString();
    }

    public void generateRasterImage(@Nullable String category, @NotNull Map<String, Map<String, AnnotatedImage>> categoryMap, @NotNull GraphicGeneratorContext context2, @NotNull IconOptions options2, @NotNull String name2) {
        if (options2.density == Density.ANYDPI) {
            this.generateImageAndUpdateMap(category, categoryMap, context2, options2, name2);
            return;
        }
        Density[] densityValues = Density.values();
        Arrays.sort(densityValues, Comparator.comparingInt(Density::getDpiValue));
        for (Density density : densityValues) {
            if (!density.isValidValueForDevice() || !this.includeDensity(density)) continue;
            options2.density = density;
            this.generateImageAndUpdateMap(category, categoryMap, context2, options2, name2);
        }
    }

    private void generateImageAndUpdateMap(@Nullable String category, @NotNull Map<String, Map<String, AnnotatedImage>> categoryMap, @NotNull GraphicGeneratorContext context2, @NotNull IconOptions options2, @NotNull String name2) {
        AnnotatedImage annotatedImage = this.generateRasterImage(context2, options2);
        String mapCategory = category;
        if (mapCategory == null) {
            mapCategory = options2.density.getResourceValue();
        }
        Map imageMap = categoryMap.computeIfAbsent(mapCategory, k -> new LinkedHashMap());
        imageMap.put(this.getIconPath(options2, name2), annotatedImage);
    }

    protected boolean includeDensity(@NotNull Density density) {
        return density.isRecommended() && density != Density.LOW;
    }

    public static double getMdpiScaleFactor(@NotNull Density density) {
        if (density == Density.ANYDPI) {
            density = Density.XXXHIGH;
        }
        if (density == Density.NODPI) {
            density = Density.MEDIUM;
        }
        return (double)density.getDpiValue() / (double)Density.MEDIUM.getDpiValue();
    }

    @Nullable
    public static Density pathToDensity(@NotNull String iconPath) {
        iconPath = FileUtils.toSystemIndependentPath((String)iconPath);
        iconPath = iconPath.substring(0, iconPath.lastIndexOf(47) + 1);
        for (Density density : Density.values()) {
            if (!DENSITY_PATTERNS.get(density).matcher(iconPath).matches()) continue;
            return density;
        }
        return null;
    }

    protected int calculateMinRequiredApiLevel(@NotNull String xmlDrawableText, int minSdk) {
        ApiLookup apiLookup = (ApiLookup)this.myApiLookup.getValue();
        if (apiLookup == null) {
            return 0;
        }
        KXmlParser parser2 = new KXmlParser();
        int requiredApiLevel = 0;
        try {
            int type;
            parser2.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser2.setInput((Reader)CharSequences.getReader((CharSequence)xmlDrawableText, (boolean)true));
            while ((type = parser2.next()) != 1) {
                if (type != 2) continue;
                for (int i = 0; i < parser2.getAttributeCount(); ++i) {
                    int attributeApiLevel;
                    String attributeName;
                    if (!"http://schemas.android.com/apk/res/android".equals(parser2.getAttributeNamespace(i)) || (attributeName = parser2.getAttributeName(i)).equals("fillType") || requiredApiLevel >= (attributeApiLevel = apiLookup.getFieldVersions("android/R$attr", attributeName).min())) continue;
                    requiredApiLevel = attributeApiLevel;
                }
            }
        }
        catch (IOException | XmlPullParserException throwable) {
            // empty catch block
        }
        return requiredApiLevel > minSdk && requiredApiLevel > 21 ? requiredApiLevel : 0;
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(IconGenerator.class);
    }

    @Nullable
    private static BufferedImage loadImage(@NotNull GraphicGeneratorContext context2, @NotNull Shape shape, @NotNull Density density, @NotNull String fileName) {
        String densityValue = density == Density.NODPI ? "playstore" : density.getResourceValue();
        String name2 = String.format("/images/launcher_stencil/%s/%s/%s.png", shape.id, densityValue, fileName);
        return context2.loadImageResource(name2);
    }

    @Nullable
    protected static BufferedImage loadMaskImage(@NotNull GraphicGeneratorContext context2, @NotNull Shape shape, @NotNull Density density) {
        return IconGenerator.loadImage(context2, shape, density, "mask");
    }

    @Nullable
    protected static BufferedImage loadBackImage(@NotNull GraphicGeneratorContext context2, @NotNull Shape shape, @NotNull Density density) {
        return IconGenerator.loadImage(context2, shape, density, "back");
    }

    @Nullable
    protected static BufferedImage loadStyleImage(@NotNull GraphicGeneratorContext context2, @NotNull Shape shape, @NotNull Density density, @NotNull Style style) {
        return IconGenerator.loadImage(context2, shape, density, style.id);
    }

    static {
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        for (Density density : Density.values()) {
            builder2.put((Object)density, (Object)Pattern.compile(String.format(".*[^a-z]%s[^a-z].*", density.getResourceValue()), 2));
        }
        DENSITY_PATTERNS = builder2.build();
        PLACEHOLDER_IMAGE = new AnnotatedImage(AssetStudioUtils.createPlaceholderImage());
    }

    public static class IconOptions
    implements Cloneable {
        public boolean generateOutputIcons;
        public boolean generatePreviewIcons;
        public boolean generateWebpIcons;
        @Nullable
        public TransformedImageAsset image;
        @Nullable
        public ListenableFuture<BufferedImage> sourceImageFuture;
        public boolean isTrimmed;
        public int paddingPercent;
        @NotNull
        public IconFolderKind iconFolderKind = IconFolderKind.DRAWABLE;
        @NotNull
        public Density density = Density.XHIGH;
        public int apiVersion;
        public boolean usePlaceholders;

        public IconOptions(boolean forPreview) {
            this.generatePreviewIcons = forPreview;
            this.generateOutputIcons = !forPreview;
        }

        @NotNull
        public IconOptions clone() {
            try {
                return (IconOptions)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error(e);
            }
        }
    }

    public static enum IconFolderKind {
        DRAWABLE,
        DRAWABLE_NO_DPI,
        MIPMAP,
        VALUES;

    }

    public static enum Shape {
        NONE("none"),
        SOLID("solid"),
        CIRCLE("circle"),
        SQUARE("square"),
        VRECT("vrect"),
        HRECT("hrect"),
        SQUARE_DOG("square_dogear"),
        VRECT_DOG("vrect_dogear"),
        HRECT_DOG("hrect_dogear");

        public final String id;

        private Shape(String id2) {
            this.id = id2;
        }
    }

    public static enum Style {
        SIMPLE("fore1");

        public final String id;

        private Style(String id2) {
            this.id = id2;
        }
    }
}

