/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.actions;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.npw.NpwUiUtilsKt;
import com.android.tools.idea.npw.actions.AndroidAssetStudioAction;
import com.android.tools.idea.npw.assetstudio.wizard.GenerateIconsModel;
import com.android.tools.idea.npw.assetstudio.wizard.NewVectorAssetStep;
import com.android.tools.idea.projectsystem.CapabilityNotSupported;
import com.android.tools.idea.projectsystem.CapabilityStatus;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.io.File;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/npw/actions/NewVectorAssetAction;", "Lcom/android/tools/idea/npw/actions/AndroidAssetStudioAction;", "()V", "createWizard", "Lcom/android/tools/idea/wizard/model/ModelWizard;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "template", "Lcom/android/tools/idea/projectsystem/NamedModuleTemplate;", "resFolder", "Ljava/io/File;", "getHelpUrl", "Ljava/net/URL;", "getWizardMinimumSize", "Ljava/awt/Dimension;", "getWizardPreferredSize", "intellij.android.newProjectWizard"})
public final class NewVectorAssetAction
extends AndroidAssetStudioAction {
    public NewVectorAssetAction() {
        super("Vector Asset", "Open Vector Asset Studio to create an image asset");
    }

    @Override
    @Nullable
    protected ModelWizard createWizard(@NotNull AndroidFacet facet2, @NotNull NamedModuleTemplate template, @NotNull File resFolder) {
        AndroidModel androidModel;
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)resFolder, (String)"resFolder");
        Module module2 = facet2.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
        Module module3 = module2;
        CapabilityStatus status2 = ProjectSystemUtil.getModuleSystem(module3).canGeneratePngFromVectorGraphics();
        if (status2 instanceof CapabilityNotSupported && (androidModel = AndroidModel.get(facet2)) != null) {
            AndroidVersion androidVersion = androidModel.getMinSdkVersion();
            Intrinsics.checkNotNullExpressionValue((Object)androidVersion, (String)"androidModel.minSdkVersion");
            AndroidVersion minSdkVersion2 = androidVersion;
            if (minSdkVersion2.getApiLevel() < 21) {
                Messages.showErrorDialog((Project)module3.getProject(), (String)((CapabilityNotSupported)status2).getMessage(), (String)((CapabilityNotSupported)status2).getTitle());
                return null;
            }
        }
        ModelWizard.Builder wizardBuilder = new ModelWizard.Builder(new ModelWizardStep[0]);
        wizardBuilder.addStep(new NewVectorAssetStep(new GenerateIconsModel(facet2, "vectorWizard", template, resFolder), facet2));
        return wizardBuilder.build();
    }

    @Override
    @NotNull
    protected Dimension getWizardMinimumSize() {
        JBDimension jBDimension = JBUI.size((int)700, (int)540);
        Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"size(700, 540)");
        return (Dimension)jBDimension;
    }

    @Override
    @NotNull
    protected Dimension getWizardPreferredSize() {
        return this.getWizardMinimumSize();
    }

    @Override
    @NotNull
    protected URL getHelpUrl() {
        return NpwUiUtilsKt.toUrl("http://developer.android.com/tools/help/vector-asset-studio.html");
    }
}

