/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.other;

import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.GroupNodes;
import com.android.tools.idea.navigator.nodes.android.AndroidPsiDirectoryNode;
import com.android.tools.idea.navigator.nodes.android.AndroidPsiFileNode;
import com.android.tools.idea.navigator.nodes.other.NonAndroidSourceType;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonAndroidSourceTypeNode
extends ProjectViewNode<Module>
implements FolderGroupNode {
    private final NonAndroidSourceType mySourceType;

    NonAndroidSourceTypeNode(@NotNull Project project, @NotNull Module module2, @NotNull ViewSettings settings, @NotNull NonAndroidSourceType type) {
        super(project, (Object)module2, settings);
        this.mySourceType = type;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        List<VirtualFile> sourceFolders2 = this.getSourceFolders();
        ArrayList children2 = new ArrayList(sourceFolders2.size());
        assert (this.myProject != null);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ProjectViewDirectoryHelper directoryHelper = ProjectViewDirectoryHelper.getInstance((Project)this.myProject);
        for (VirtualFile file2 : sourceFolders2) {
            PsiDirectory dir = psiManager.findDirectory(file2);
            if (dir == null) continue;
            children2.addAll(this.wrapInAndroidViewNodes(directoryHelper.getDirectoryChildren(dir, this.getSettings(), true), dir));
        }
        return children2;
    }

    @NotNull
    private Collection<AbstractTreeNode<?>> wrapInAndroidViewNodes(@NotNull Collection<AbstractTreeNode<?>> folderChildren, @NotNull PsiDirectory psiDirectory) {
        ArrayList children2 = new ArrayList(folderChildren.size());
        assert (this.myProject != null);
        for (AbstractTreeNode<?> child : folderChildren) {
            if (child instanceof PsiDirectoryNode) {
                PsiDirectory folder = (PsiDirectory)((PsiDirectoryNode)child).getValue();
                assert (folder != null);
                children2.add((AbstractTreeNode<?>)new AndroidPsiDirectoryNode(this.myProject, folder, this.getSettings(), null, psiDirectory));
                continue;
            }
            if (child instanceof PsiFileNode) {
                PsiFile file2 = (PsiFile)((PsiFileNode)child).getValue();
                assert (file2 != null);
                children2.add((AbstractTreeNode<?>)new AndroidPsiFileNode(this.myProject, file2, this.getSettings(), null));
                continue;
            }
            children2.add(child);
        }
        return children2;
    }

    @NotNull
    private List<VirtualFile> getSourceFolders() {
        ContentEntry[] contentEntries;
        Module module2 = this.getModule();
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module2);
        ArrayList<VirtualFile> folders = new ArrayList<VirtualFile>();
        for (ContentEntry entry : contentEntries = rootManager.getContentEntries()) {
            List sources = entry.getSourceFolders(this.mySourceType.rootType);
            for (SourceFolder folder : sources) {
                VirtualFile file2 = folder.getFile();
                if (file2 == null) continue;
                folders.add(file2);
            }
        }
        return folders;
    }

    @NotNull
    private Module getModule() {
        Module module2 = (Module)this.getValue();
        assert (module2 != null);
        return module2;
    }

    protected void update(@NotNull PresentationData presentation) {
        presentation.addText(this.mySourceType.presentableName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.setPresentableText(this.mySourceType.presentableName);
        presentation.setIcon(this.mySourceType.icon);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        for (VirtualFile folder : this.getSourceFolders()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)folder, (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Comparable getSortKey() {
        return this.mySourceType;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.mySourceType;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.mySourceType.presentableName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NonAndroidSourceTypeNode that = (NonAndroidSourceTypeNode)o;
        return this.mySourceType == that.mySourceType;
    }

    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.mySourceType.hashCode();
        return result2;
    }

    @Override
    @NotNull
    public List<PsiDirectory> getFolders() {
        assert (this.myProject != null);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        List<VirtualFile> sourceFolders2 = this.getSourceFolders();
        ArrayList<PsiDirectory> folders = new ArrayList<PsiDirectory>(sourceFolders2.size());
        for (VirtualFile f : sourceFolders2) {
            PsiDirectory dir = psiManager.findDirectory(f);
            if (dir == null) continue;
            folders.add(dir);
        }
        return folders;
    }

    public boolean canRepresent(Object element2) {
        return GroupNodes.canRepresent(this, element2);
    }
}

