/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.other;

import com.android.tools.idea.navigator.nodes.AndroidViewModuleNode;
import com.android.tools.idea.navigator.nodes.other.NonAndroidSourceType;
import com.android.tools.idea.navigator.nodes.other.NonAndroidSourceTypeNode;
import com.google.common.collect.Sets;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.ui.Queryable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonAndroidModuleNode
extends AndroidViewModuleNode {
    public NonAndroidModuleNode(@NotNull Project project, @NotNull Module value2, @NotNull ViewSettings settings) {
        super(project, value2, settings);
    }

    @Override
    @NotNull
    protected Collection<AbstractTreeNode<?>> getModuleChildren() {
        Module module2 = this.getModule();
        Set<NonAndroidSourceType> sourceTypes = NonAndroidModuleNode.getNonEmptySourceTypes(module2);
        ArrayList nodes2 = new ArrayList(sourceTypes.size());
        assert (this.myProject != null);
        for (NonAndroidSourceType type : sourceTypes) {
            nodes2.add((AbstractTreeNode<?>)new NonAndroidSourceTypeNode(this.myProject, module2, this.getSettings(), type));
        }
        return nodes2;
    }

    @NotNull
    private static Set<NonAndroidSourceType> getNonEmptySourceTypes(@NotNull Module module2) {
        ContentEntry[] contentEntries;
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module2);
        HashSet sourceTypes = Sets.newHashSetWithExpectedSize((int)NonAndroidSourceType.values().length);
        for (ContentEntry entry : contentEntries = rootManager.getContentEntries()) {
            block1: for (NonAndroidSourceType type : NonAndroidSourceType.values()) {
                for (SourceFolder sourceFolder : entry.getSourceFolders(type.rootType)) {
                    if (sourceFolder.getFile() == null) continue;
                    sourceTypes.add(type);
                    continue block1;
                }
            }
        }
        return sourceTypes;
    }

    @Nullable
    public Comparable getSortKey() {
        return this.getModule().getName();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Override
    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        Module module2 = this.getModule();
        return String.format("%1$s (non-Android)", super.toTestString(printInfo));
    }

    @NotNull
    private Module getModule() {
        Module module2 = (Module)this.getValue();
        assert (module2 != null);
        return module2;
    }
}

