/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.utils;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;

public class LexicalIncludePaths {
    @NotNull
    public static final ImmutableSet<String> HEADER_FILE_EXTENSIONS = ImmutableSet.of((Object)"", (Object)"h", (Object)"hpp", (Object)"hh", (Object)"h++", (Object)"hxx", (Object[])new String[]{"inl", "tcc", "pch"});
    @NotNull
    private static final String UNIX_SEPARATOR = "/";

    public static boolean hasHeaderExtension(@NotNull String filename) {
        String extension = FilenameUtils.getExtension((String)filename);
        return HEADER_FILE_EXTENSIONS.contains((Object)extension);
    }

    @NotNull
    public static String findCommonParentFolder(@NotNull Collection<String> folders) {
        if (folders.isEmpty()) {
            return "";
        }
        ArrayList<String[]> splits = new ArrayList<String[]>();
        int minSize = Integer.MAX_VALUE;
        for (String folder : folders) {
            String[] split = folder.split(UNIX_SEPARATOR);
            splits.add(split);
            minSize = Math.min(minSize, split.length);
        }
        StringBuilder buildUp = null;
        for (int i = 0; i < minSize; ++i) {
            String prior = null;
            for (String[] split : splits) {
                if (prior == null) {
                    prior = split[i];
                    continue;
                }
                if (prior.equals(split[i])) continue;
                return buildUp == null ? "" : buildUp.toString();
            }
            if (buildUp != null) {
                buildUp.append(UNIX_SEPARATOR);
            }
            if (buildUp == null) {
                buildUp = new StringBuilder(prior == null ? "" : prior);
                continue;
            }
            buildUp.append(prior);
        }
        return buildUp == null ? "" : buildUp.toString();
    }

    @NotNull
    public static String trimPathSeparators(@NotNull String path2) {
        String result2 = path2;
        if (result2.endsWith(UNIX_SEPARATOR)) {
            result2 = result2.substring(0, result2.length() - 1);
        }
        if (result2.startsWith(UNIX_SEPARATOR)) {
            result2 = result2.substring(1);
        }
        return result2;
    }

    @NotNull
    public static Matcher matchFolderToRegex(@NotNull Pattern pattern, @NotNull File folder) {
        return pattern.matcher(FilenameUtils.separatorsToUnix((String)folder.getPath()) + UNIX_SEPARATOR);
    }
}

