/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NdkSourceFolderNode
extends PsiDirectoryNode {
    private boolean myShowFolderPath;

    public NdkSourceFolderNode(@NotNull Project project, @NotNull PsiDirectory folder, @NotNull ViewSettings settings, @Nullable PsiFileSystemItemFilter filter2) {
        super(project, folder, settings, filter2);
    }

    protected boolean shouldShowModuleName() {
        return false;
    }

    protected boolean shouldShowSourcesRoot() {
        return false;
    }

    protected void updateImpl(@NotNull PresentationData presentation) {
        VirtualFile folder = this.getVirtualFile();
        assert (folder != null);
        presentation.setPresentableText(folder.getName());
        presentation.addText(folder.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.myShowFolderPath) {
            String text2 = String.format(" (%1$s)", FileUtil.getLocationRelativeToUserHome((String)folder.getPresentableUrl()));
            presentation.addText(text2, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        presentation.setIcon(AllIcons.Nodes.Folder);
    }

    public Collection<AbstractTreeNode<?>> getChildrenImpl() {
        PsiDirectory folder = (PsiDirectory)this.getValue();
        if (folder == null) {
            return Collections.emptyList();
        }
        return ProjectViewDirectoryHelper.getInstance((Project)this.myProject).getDirectoryChildren(folder, this.getSettings(), true, this.getFilter());
    }

    void setShowFolderPath(boolean showFolderPath) {
        this.myShowFolderPath = showFolderPath;
    }
}

