/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.apk.ndk;

import com.android.tools.idea.apk.paths.PathNode;
import com.android.tools.idea.apk.paths.PathTree;
import com.android.tools.idea.navigator.nodes.apk.ndk.SourceCodeFilter;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PathTrees {
    private PathTrees() {
    }

    @NotNull
    static List<PsiDirectory> findSourceFolders(@NotNull PathTree tree2, @NotNull String basePath, @NotNull Project project) {
        ArrayList<PsiDirectory> children2 = new ArrayList<PsiDirectory>();
        ArrayList<PathNode> nodes2 = new ArrayList<PathNode>();
        PathTrees.removeEmptyRoots(tree2.getChildren(), nodes2);
        for (PathNode pathNode : nodes2) {
            PathTrees.addRoots(pathNode, basePath, children2, project);
        }
        return children2;
    }

    private static void addRoots(@NotNull PathNode pathNode, @NotNull String basePath, @NotNull List<PsiDirectory> roots, @NotNull Project project) {
        String path2 = pathNode.getPath();
        if (FileUtil.isAncestor((String)basePath, (String)path2, (boolean)true)) {
            roots.add(PathTrees.findFolder(path2, project));
            return;
        }
        for (PathNode child : pathNode.getChildren()) {
            PathTrees.addRoots(child, basePath, roots, project);
        }
    }

    @NotNull
    static List<AbstractTreeNode<?>> getSourceFolderNodes(@NotNull PathTree tree2, @NotNull SourceCodeFilter filter2, @NotNull Project project, @NotNull ViewSettings settings) {
        ArrayList children2 = new ArrayList();
        ArrayList<PathNode> rootSrcNodes = new ArrayList<PathNode>();
        PathTrees.removeEmptyRoots(tree2.getChildren(), rootSrcNodes);
        for (PathNode pathNode : rootSrcNodes) {
            String path2 = pathNode.getPath();
            PsiDirectory psiFolder = PathTrees.findFolder(path2, project);
            if (psiFolder == null) continue;
            children2.add((AbstractTreeNode<?>)new PsiDirectoryNode(project, psiFolder, settings, (PsiFileSystemItemFilter)filter2));
        }
        return children2;
    }

    private static void removeEmptyRoots(@NotNull Collection<PathNode> nodes2, @NotNull List<PathNode> rootNodes) {
        for (PathNode node : nodes2) {
            String path2 = node.getPath();
            if (StringUtil.isNotEmpty((String)path2)) {
                rootNodes.add(node);
                continue;
            }
            PathTrees.removeEmptyRoots(node.getChildren(), rootNodes);
        }
    }

    @Nullable
    private static PsiDirectory findFolder(@NotNull String path2, @NotNull Project project) {
        VirtualFile folder = LocalFileSystem.getInstance().findFileByPath(path2);
        if (folder != null) {
            return PsiManager.getInstance((Project)project).findDirectory(folder);
        }
        return null;
    }
}

