/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.GroupNodes;
import com.android.tools.idea.navigator.nodes.android.AndroidResFileNode;
import com.android.tools.idea.navigator.nodes.android.AndroidResGroupNode;
import com.google.common.collect.HashMultimap;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResFolderTypeNode
extends ProjectViewNode<List<PsiDirectory>>
implements FolderGroupNode {
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final ResourceFolderType myFolderType;

    AndroidResFolderTypeNode(@NotNull Project project, @NotNull AndroidFacet androidFacet, @NotNull List<PsiDirectory> folders, @NotNull ViewSettings settings, @NotNull ResourceFolderType folderType) {
        super(project, folders, settings);
        this.myFacet = androidFacet;
        this.myFolderType = folderType;
    }

    @Override
    @NotNull
    public List<PsiDirectory> getFolders() {
        return this.getResFolders();
    }

    public boolean contains(@NotNull VirtualFile file2) {
        for (PsiDirectory resFolder : this.getResFolders()) {
            VirtualFile folder = resFolder.getVirtualFile();
            if (!VfsUtilCore.isAncestor((VirtualFile)folder, (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public boolean canRepresent(Object element2) {
        return GroupNodes.canRepresent(this, element2);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        HashMultimap multimap = HashMultimap.create();
        for (PsiDirectory resFolder : this.getResFolders()) {
            if (!resFolder.isValid()) continue;
            for (PsiFile file2 : resFolder.getFiles()) {
                String resName = FileUtilRt.getNameWithoutExtension((String)file2.getName());
                multimap.put((Object)resName, (Object)file2);
            }
        }
        assert (this.myProject != null);
        ArrayList<Comparable> children2 = new ArrayList<Comparable>(multimap.size());
        for (String resName : multimap.keySet()) {
            ArrayList<PsiFile> files2 = new ArrayList<PsiFile>(multimap.get((Object)resName));
            if (files2.size() > 1) {
                children2.add(new AndroidResGroupNode(this.myProject, this.myFacet, files2, resName, this.getSettings()));
                continue;
            }
            children2.add(new AndroidResFileNode(this.myProject, (PsiFile)files2.get(0), this.getSettings(), this.myFacet));
        }
        return children2;
    }

    @NotNull
    private List<PsiDirectory> getResFolders() {
        List folders = (List)this.getValue();
        assert (folders != null);
        return folders;
    }

    protected void update(@NotNull PresentationData presentation) {
        presentation.addText(this.myFolderType.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.setIcon(IconManager.getInstance().getPlatformIcon(PlatformIcons.Package));
        presentation.setPresentableText(this.myFolderType.getName());
    }

    @Nullable
    public Comparable getSortKey() {
        return this.myFolderType;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.myFolderType;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.myFolderType.getName();
    }
}

