/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.android.AndroidManifestFileNode;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.google.common.collect.Iterables;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidManifestsGroupNode
extends ProjectViewNode<AndroidFacet>
implements FolderGroupNode {
    private static final String MANIFESTS_NODE = "manifests";
    @NotNull
    private final Set<VirtualFile> mySources;

    public AndroidManifestsGroupNode(@NotNull Project project, @NotNull AndroidFacet androidFacet, @NotNull ViewSettings settings, @NotNull Set<VirtualFile> sources) {
        super(project, (Object)androidFacet, settings);
        this.mySources = sources;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        return this.mySources.contains(file2);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        Project project = this.getNotNullProject();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ArrayList<AndroidManifestFileNode> children2 = new ArrayList<AndroidManifestFileNode>();
        for (VirtualFile manifest : this.mySources) {
            PsiFile psiFile;
            if (!manifest.isValid() || (psiFile = psiManager.findFile(manifest)) == null) continue;
            AndroidFacet facet2 = this.getAndroidFacet();
            children2.add(new AndroidManifestFileNode(project, psiFile, this.getSettings(), facet2));
        }
        return children2;
    }

    protected void update(@NotNull PresentationData presentation) {
        presentation.addText(MANIFESTS_NODE, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        Icon icon2 = AndroidSourceType.MANIFEST.INSTANCE.getIcon();
        if (icon2 != null) {
            presentation.setIcon(icon2);
        }
        presentation.setPresentableText(MANIFESTS_NODE);
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    public boolean canNavigate() {
        return !this.mySources.isEmpty();
    }

    public void navigate(boolean requestFocus) {
        VirtualFile fileToOpen = this.findFileToOpen(this.mySources);
        if (fileToOpen == null) {
            return;
        }
        new OpenFileDescriptor(this.getNotNullProject(), fileToOpen).navigate(requestFocus);
    }

    @Nullable
    private VirtualFile findFileToOpen(@NotNull Set<VirtualFile> files2) {
        VirtualFile bestFile = (VirtualFile)Iterables.getFirst(files2, null);
        PsiManager psiManager = PsiManager.getInstance((Project)this.getNotNullProject());
        for (VirtualFile file2 : files2) {
            AndroidFacet facet2;
            NamedIdeaSourceProvider sourceProvider;
            PsiFile psiFile = psiManager.findFile(file2);
            if (psiFile == null || (sourceProvider = AndroidManifestFileNode.getSourceProvider(facet2 = this.getAndroidFacet(), psiFile)) == null || !"main".equals(sourceProvider.getName())) continue;
            bestFile = file2;
        }
        return bestFile;
    }

    @NotNull
    private AndroidFacet getAndroidFacet() {
        AndroidFacet facet2 = (AndroidFacet)this.getValue();
        assert (facet2 != null) : "Android Facet for module cannot be null";
        return facet2;
    }

    @NotNull
    private Project getNotNullProject() {
        assert (this.myProject != null);
        return this.myProject;
    }

    @Override
    @NotNull
    public List<PsiDirectory> getFolders() {
        return Collections.emptyList();
    }

    @Nullable
    public Comparable getSortKey() {
        return AndroidSourceType.MANIFEST.INSTANCE;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return AndroidSourceType.MANIFEST.INSTANCE;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return MANIFESTS_NODE;
    }

    public boolean isAlwaysShowPlus() {
        return true;
    }
}

