/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.navigator.ProjectViewListener;
import com.android.tools.idea.stats.FeatureSurveys;
import com.android.utils.DateProvider;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ProjectViewSelectionChangeEvent;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.concurrency.EdtExecutorService;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u000f\u0018\u00002\u00020\u0001:\u0001%B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001e\u0010 \u001a\u00020\u00192\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\"2\u0006\u0010#\u001a\u00020$H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/navigator/ProjectViewListener;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "featureSurveys", "Lcom/android/tools/idea/stats/FeatureSurveys;", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "dateProvider", "Lcom/android/utils/DateProvider;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/stats/FeatureSurveys;Ljava/util/concurrent/ScheduledExecutorService;Lcom/android/utils/DateProvider;)V", "addEventTimestamp", "", "contentManagerListener", "com/android/tools/idea/navigator/ProjectViewListener$contentManagerListener$1", "Lcom/android/tools/idea/navigator/ProjectViewListener$contentManagerListener$1;", "firstRemovedId", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "convertToViewEnum", "Lcom/google/wireless/android/sdk/stats/ProjectViewSelectionChangeEvent$ProjectViewContent;", "viewId", "processDetectedChange", "", "fromViewId", "toViewId", "toolWindowUnregistered", "id", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "toolWindowsRegistered", "ids", "", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "ReportingRunnable", "intellij.android.core"})
public final class ProjectViewListener
implements ToolWindowManagerListener {
    @NotNull
    private final Project project;
    @NotNull
    private final FeatureSurveys featureSurveys;
    @NotNull
    private final ScheduledExecutorService scheduler;
    @NotNull
    private final DateProvider dateProvider;
    private volatile long addEventTimestamp;
    @Nullable
    private volatile String firstRemovedId;
    @NotNull
    private final contentManagerListener.1 contentManagerListener;

    public ProjectViewListener(@NotNull Project project, @NotNull FeatureSurveys featureSurveys, @NotNull ScheduledExecutorService scheduler, @NotNull DateProvider dateProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)featureSurveys, (String)"featureSurveys");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        Intrinsics.checkNotNullParameter((Object)dateProvider, (String)"dateProvider");
        this.project = project;
        this.featureSurveys = featureSurveys;
        this.scheduler = scheduler;
        this.dateProvider = dateProvider;
        this.contentManagerListener = new ContentManagerListener(this){
            final /* synthetic */ ProjectViewListener this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(@NotNull ContentManagerEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                long currentTime = ProjectViewListener.access$getDateProvider$p(this.this$0).now().getTime();
                ContentManagerEvent.ContentOperation contentOperation = event2.getOperation();
                switch (contentOperation == null ? -1 : contentManagerListener.WhenMappings.$EnumSwitchMapping$0[contentOperation.ordinal()]) {
                    case 1: {
                        boolean shouldUpdateFirstId = ProjectViewListener.access$getAddEventTimestamp$p(this.this$0) + 10000L < currentTime;
                        ProjectViewListener.access$setAddEventTimestamp$p(this.this$0, currentTime);
                        if (!shouldUpdateFirstId) break;
                        ProjectViewListener.access$setFirstRemovedId$p(this.this$0, ProjectView.getInstance((Project)this.this$0.getProject()).getCurrentViewId());
                        break;
                    }
                    case 2: {
                        ProjectViewListener.access$setAddEventTimestamp$p(this.this$0, currentTime);
                        ProjectViewListener.access$getScheduler$p(this.this$0).schedule(this.this$0.new ReportingRunnable(currentTime), 10000L, TimeUnit.MILLISECONDS);
                        break;
                    }
                }
            }
        };
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ProjectViewListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ScheduledExecutorService scheduledExecutorService = EdtExecutorService.getScheduledExecutorInstance();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"getScheduledExecutorInstance()");
        DateProvider dateProvider = DateProvider.SYSTEM;
        Intrinsics.checkNotNullExpressionValue((Object)dateProvider, (String)"SYSTEM");
        this(project, FeatureSurveys.INSTANCE, scheduledExecutorService, dateProvider);
    }

    public void toolWindowsRegistered(@NotNull List<String> ids, @NotNull ToolWindowManager toolWindowManager) {
        block1: {
            long currentTime;
            Intrinsics.checkNotNullParameter(ids, (String)"ids");
            Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
            if (!ids.contains("Project")) break block1;
            this.addEventTimestamp = currentTime = this.dateProvider.now().getTime();
            this.firstRemovedId = "";
            this.scheduler.schedule(new ReportingRunnable(currentTime), 10000L, TimeUnit.MILLISECONDS);
            ToolWindow toolWindow = toolWindowManager.getToolWindow("Project");
            if (toolWindow != null && (toolWindow = toolWindow.getContentManager()) != null) {
                toolWindow.addContentManagerListener((ContentManagerListener)this.contentManagerListener);
            }
        }
    }

    public void toolWindowUnregistered(@NotNull String id2, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        if (Intrinsics.areEqual((Object)id2, (Object)"Project")) {
            toolWindow.getContentManager().removeContentManagerListener((ContentManagerListener)this.contentManagerListener);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processDetectedChange(String fromViewId, String toViewId) {
        void $this$processDetectedChange_u24lambda_u241_u24lambda_u240;
        ProjectViewSelectionChangeEvent.Builder builder2;
        AndroidStudioEvent.Builder builder3;
        ProjectViewSelectionChangeEvent.ProjectViewContent viewBeforeChangeValue = this.convertToViewEnum(fromViewId);
        ProjectViewSelectionChangeEvent.ProjectViewContent viewAfterChangeValue = this.convertToViewEnum(toViewId);
        AndroidStudioEvent.Builder $this$processDetectedChange_u24lambda_u241 = builder3 = AndroidStudioEvent.newBuilder();
        boolean bl = false;
        $this$processDetectedChange_u24lambda_u241.setKind(AndroidStudioEvent.EventKind.PROJECT_VIEW_SELECTION_CHANGE_EVENT);
        ProjectViewSelectionChangeEvent.Builder builder4 = builder2 = ProjectViewSelectionChangeEvent.newBuilder();
        AndroidStudioEvent.Builder builder5 = $this$processDetectedChange_u24lambda_u241;
        boolean bl2 = false;
        $this$processDetectedChange_u24lambda_u241_u24lambda_u240.setViewBeforeChange(viewBeforeChangeValue);
        $this$processDetectedChange_u24lambda_u241_u24lambda_u240.setViewAfterChange(viewAfterChangeValue);
        builder5.setProjectViewSelectionChangeEvent(builder2.build());
        AndroidStudioEvent.Builder builder6 = builder3;
        Intrinsics.checkNotNullExpressionValue((Object)builder6, (String)"newBuilder().apply {\n   \u2026lue\n      }.build()\n    }");
        UsageTracker.log((AndroidStudioEvent.Builder)builder6);
        if (viewBeforeChangeValue == ProjectViewSelectionChangeEvent.ProjectViewContent.ANDROID && ProjectView.getInstance((Project)this.project).getPaneIds().contains("AndroidView")) {
            this.featureSurveys.triggerSurveyByName("ANDROID_PROJECT_VIEW_UNSELECTED");
        }
    }

    private final ProjectViewSelectionChangeEvent.ProjectViewContent convertToViewEnum(String viewId) {
        return switch (viewId) {
            case "" -> ProjectViewSelectionChangeEvent.ProjectViewContent.UNKNOWN;
            case "AndroidView" -> ProjectViewSelectionChangeEvent.ProjectViewContent.ANDROID;
            case "ProjectPane" -> ProjectViewSelectionChangeEvent.ProjectViewContent.PROJECT;
            default -> ProjectViewSelectionChangeEvent.ProjectViewContent.OTHER;
        };
    }

    public static final /* synthetic */ DateProvider access$getDateProvider$p(ProjectViewListener $this) {
        return $this.dateProvider;
    }

    public static final /* synthetic */ void access$setAddEventTimestamp$p(ProjectViewListener $this, long l) {
        $this.addEventTimestamp = l;
    }

    public static final /* synthetic */ void access$setFirstRemovedId$p(ProjectViewListener $this, String string) {
        $this.firstRemovedId = string;
    }

    public static final /* synthetic */ ScheduledExecutorService access$getScheduler$p(ProjectViewListener $this) {
        return $this.scheduler;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/navigator/ProjectViewListener$ReportingRunnable;", "Ljava/lang/Runnable;", "addingTime", "", "(Lcom/android/tools/idea/navigator/ProjectViewListener;J)V", "getAddingTime", "()J", "run", "", "intellij.android.core"})
    private final class ReportingRunnable
    implements Runnable {
        private final long addingTime;

        public ReportingRunnable(long addingTime) {
            this.addingTime = addingTime;
        }

        public final long getAddingTime() {
            return this.addingTime;
        }

        @Override
        public void run() {
            if (ProjectViewListener.this.getProject().isDisposed()) {
                return;
            }
            String localInitialViewId = ProjectViewListener.this.firstRemovedId;
            if (this.addingTime != ProjectViewListener.this.addEventTimestamp) {
                return;
            }
            String newViewId = ProjectView.getInstance((Project)ProjectViewListener.this.getProject()).getCurrentViewId();
            if (localInitialViewId != null && newViewId != null && !Intrinsics.areEqual((Object)localInitialViewId, (Object)newViewId)) {
                ProjectViewListener.this.processDetectedChange(localInitialViewId, newViewId);
            }
        }
    }
}

