/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator;

import com.android.tools.idea.Projects;
import com.android.tools.idea.navigator.nodes.AndroidViewNodeProvider;
import com.android.tools.idea.navigator.nodes.AndroidViewProjectNode;
import com.android.tools.idea.navigator.nodes.FileGroupNode;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.android.BuildScriptTreeStructureProvider;
import com.intellij.facet.Facet;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.AbstractProjectViewPaneWithAsyncSupport;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import icons.StudioIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProjectViewPane
extends AbstractProjectViewPaneWithAsyncSupport {
    public static final String ID = "AndroidView";
    private AtomicBoolean isProcessingChanges = new AtomicBoolean(false);

    public AndroidProjectViewPane(final Project project) {
        super(project);
        ProjectWideFacetListenersRegistry.getInstance((Project)project).registerListener((ProjectWideFacetListener)new ProjectWideFacetAdapter<Facet>(){

            public void facetAdded(@NotNull Facet facet2) {
                this.somethingChanged();
            }

            public void facetRemoved(@NotNull Facet facet2) {
                this.somethingChanged();
            }

            private void somethingChanged() {
                if (!AndroidProjectViewPane.this.isProcessingChanges.getAndSet(true)) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        try {
                            if (project.isDisposed()) {
                                return;
                            }
                            ProjectView projectView = ProjectView.getInstance((Project)project);
                            AbstractProjectViewPane pane = projectView.getProjectViewPaneById(AndroidProjectViewPane.ID);
                            boolean visible = AndroidProjectViewPane.this.isInitiallyVisible();
                            if (visible && pane == null) {
                                projectView.addProjectPane((AbstractProjectViewPane)AndroidProjectViewPane.this);
                            } else if (!visible && pane != null) {
                                projectView.removeProjectPane(pane);
                            }
                        }
                        finally {
                            AndroidProjectViewPane.this.isProcessingChanges.set(false);
                        }
                    }, project.getDisposed());
                }
            }
        });
    }

    @NotNull
    public String getTitle() {
        return "Android";
    }

    @NotNull
    public Icon getIcon() {
        return StudioIcons.Common.ANDROID_HEAD;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    public int getWeight() {
        return 142;
    }

    public boolean isInitiallyVisible() {
        return AndroidUtils.hasAndroidFacets(this.myProject);
    }

    @NotNull
    public SelectInTarget createSelectInTarget() {
        return new ProjectViewSelectInTarget(this.myProject){

            public String toString() {
                return AndroidProjectViewPane.this.getTitle();
            }

            public String getMinorViewId() {
                return AndroidProjectViewPane.this.getId();
            }

            public float getWeight() {
                return AndroidProjectViewPane.this.getWeight();
            }

            protected boolean canSelect(PsiFileSystemItem file2) {
                if (super.canSelect(file2)) {
                    return true;
                }
                return AndroidViewNodeProvider.getProviders().stream().anyMatch(it -> it.projectContainsExternalFile(this.myProject, file2.getVirtualFile()));
            }
        };
    }

    @NotNull
    protected ProjectAbstractTreeStructureBase createStructure() {
        return new AndroidProjectTreeStructure(this.myProject, ID);
    }

    @NotNull
    protected ProjectViewTree createTree(@NotNull DefaultTreeModel treeModel) {
        return new MyProjectViewTree(treeModel);
    }

    @NotNull
    public PsiDirectory[] getSelectedDirectories() {
        PackageElement packageElement;
        Module m;
        Object selectedElement = this.getSelectedElement();
        if (selectedElement instanceof PackageElement && (m = (packageElement = (PackageElement)selectedElement).getModule()) != null) {
            return packageElement.getPackage().getDirectories(GlobalSearchScope.moduleScope((Module)m));
        }
        NodeDescriptor descriptor2 = this.getSelectedDescriptor();
        if (descriptor2 instanceof FolderGroupNode) {
            return ((FolderGroupNode)descriptor2).getFolders().toArray(PsiDirectory.EMPTY_ARRAY);
        }
        PsiDirectory[] selectedDirectories = super.getSelectedDirectories();
        if (selectedElement instanceof Module && selectedDirectories.length > 0) {
            ArrayList<PsiDirectory> dirs2 = new ArrayList<PsiDirectory>(selectedDirectories.length);
            for (PsiDirectory dir : selectedDirectories) {
                VirtualFile file2 = dir.getVirtualFile();
                if (GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file2, (Project)this.myProject) || file2.getParent() != null && file2.getPath().contains("/generated/")) continue;
                dirs2.add(dir);
            }
            selectedDirectories = dirs2.toArray(PsiDirectory.EMPTY_ARRAY);
        }
        return selectedDirectories;
    }

    @Nullable
    public Object getValueFromNode(@Nullable Object node) {
        Object o = super.getValueFromNode(node);
        if (o instanceof ArrayList && TreeUtil.getUserObject((Object)node) instanceof FolderGroupNode) {
            return ((ArrayList)o).toArray();
        }
        return o;
    }

    @Nullable
    protected Object getSlowDataFromSelection(@Nullable Object[] selectedUserObjects, @Nullable Object[] singleSelectedPathUserObjects, @NotNull String dataId) {
        PackageElement packageElement;
        Object o;
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            VirtualFile directory;
            Object object = o = selectedUserObjects.length != 1 ? null : this.getValueFromNode(selectedUserObjects[0]);
            if (o instanceof PsiDirectory && this.isTopModuleDirectoryOrParent(directory = ((PsiDirectory)o).getVirtualFile())) {
                return new NoOpDeleteProvider();
            }
        }
        if (PlatformCoreDataKeys.MODULE.is(dataId)) {
            Object object = o = selectedUserObjects.length != 1 ? null : this.getValueFromNode(selectedUserObjects[0]);
            if (o instanceof PackageElement) {
                packageElement = (PackageElement)o;
                return packageElement.getModule();
            }
            if (o instanceof AndroidFacet) {
                return ((AndroidFacet)o).getModule();
            }
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            Module m;
            Object object = o = selectedUserObjects.length != 1 ? null : this.getValueFromNode(selectedUserObjects[0]);
            if (o instanceof PackageElement && (m = (packageElement = (PackageElement)o).getModule()) != null) {
                PsiDirectory[] folders = packageElement.getPackage().getDirectories(GlobalSearchScope.moduleScope((Module)m));
                if (folders.length > 0) {
                    return folders[0].getVirtualFile();
                }
                return null;
            }
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            List<PsiDirectory> directories2;
            ArrayList<VirtualFile> virtualFiles;
            List<PsiFile> files2;
            NodeDescriptor selectedDescriptor;
            NodeDescriptor nodeDescriptor = selectedDescriptor = selectedUserObjects.length != 1 ? null : (NodeDescriptor)ObjectUtils.tryCast((Object)selectedUserObjects[0], NodeDescriptor.class);
            if (selectedDescriptor instanceof FileGroupNode && !(files2 = ((FileGroupNode)selectedDescriptor).getFiles()).isEmpty()) {
                virtualFiles = new ArrayList<VirtualFile>(files2.size());
                for (PsiFile file2 : files2) {
                    if (!file2.isValid()) continue;
                    virtualFiles.add(file2.getVirtualFile());
                }
                return virtualFiles.toArray(VirtualFile.EMPTY_ARRAY);
            }
            if (selectedDescriptor instanceof FolderGroupNode && !(directories2 = ((FolderGroupNode)selectedDescriptor).getFolders()).isEmpty()) {
                virtualFiles = new ArrayList(directories2.size());
                for (PsiDirectory directory : directories2) {
                    if (!directory.isValid()) continue;
                    virtualFiles.add(directory.getVirtualFile());
                }
                return virtualFiles.toArray(VirtualFile.EMPTY_ARRAY);
            }
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            List<PsiDirectory> directories3;
            List<PsiFile> files3;
            NodeDescriptor selectedDescriptor;
            List l;
            Object object = o = selectedUserObjects.length != 1 ? null : this.getValueFromNode(selectedUserObjects[0]);
            if (o instanceof PsiElement) {
                return o;
            }
            if (o instanceof List && !(l = (List)o).isEmpty() && l.get(0) instanceof PsiElement) {
                return l.get(0);
            }
            NodeDescriptor nodeDescriptor = selectedDescriptor = selectedUserObjects.length != 1 ? null : (NodeDescriptor)ObjectUtils.tryCast((Object)selectedUserObjects[0], NodeDescriptor.class);
            if (selectedDescriptor instanceof FileGroupNode && !(files3 = ((FileGroupNode)selectedDescriptor).getFiles()).isEmpty()) {
                return files3.get(0);
            }
            if (selectedDescriptor instanceof FolderGroupNode && !(directories3 = ((FolderGroupNode)selectedDescriptor).getFolders()).isEmpty()) {
                return directories3.get(0);
            }
        }
        return super.getSlowDataFromSelection(selectedUserObjects, singleSelectedPathUserObjects, dataId);
    }

    private boolean isTopModuleDirectoryOrParent(@NotNull VirtualFile directory) {
        for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            File baseDirPath;
            File moduleRootFolderPath = AndroidRootUtil.findModuleRootFolderPath(module2);
            if (moduleRootFolderPath == null || !FileUtil.filesEqual((File)moduleRootFolderPath, (File)(baseDirPath = Projects.getBaseDirPath((Project)this.myProject)))) continue;
            File directoryPath = VfsUtilCore.virtualToIoFile((VirtualFile)directory);
            return FileUtil.isAncestor((File)directoryPath, (File)baseDirPath, (boolean)false);
        }
        return false;
    }

    private static class AndroidProjectTreeStructure
    extends ProjectTreeStructure
    implements ProjectViewSettings {
        private final String panelId;

        AndroidProjectTreeStructure(@NotNull Project project, @NotNull String panelId) {
            super(project, panelId);
            this.panelId = panelId;
        }

        public List<TreeStructureProvider> getProviders() {
            List providers = super.getProviders();
            if (providers == null) {
                return null;
            }
            return ContainerUtil.map((Collection)providers, provider2 -> new BuildScriptTreeStructureProvider((TreeStructureProvider)provider2));
        }

        protected AbstractTreeNode createRoot(@NotNull Project project, @NotNull ViewSettings settings) {
            return new AndroidViewProjectNode(project, settings);
        }

        public boolean isShowVisibilityIcons() {
            return ProjectView.getInstance((Project)this.myProject).isShowVisibilityIcons(this.panelId);
        }
    }

    private class MyProjectViewTree
    extends ProjectViewTree
    implements DataProvider {
        MyProjectViewTree(DefaultTreeModel treeModel) {
            super((TreeModel)treeModel);
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            return AndroidProjectViewPane.this.getData(dataId);
        }
    }

    private static class NoOpDeleteProvider
    implements DeleteProvider {
        private NoOpDeleteProvider() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void deleteElement(@NotNull DataContext dataContext) {
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            return false;
        }
    }
}

