/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.nav.safeargs.module;

import com.android.ide.common.gradle.Version;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.nav.safeargs.SafeArgsMode;
import com.android.tools.idea.nav.safeargs.SafeArgsModeKt;
import com.android.tools.idea.nav.safeargs.index.NavXmlData;
import com.android.tools.idea.nav.safeargs.index.NavXmlIndex;
import com.android.tools.idea.nav.safeargs.module.ModuleNavigationResourcesModificationTracker;
import com.android.tools.idea.nav.safeargs.module.NavEntry;
import com.android.tools.idea.nav.safeargs.module.NavInfo;
import com.android.tools.idea.nav.safeargs.psi.SafeArgsFeatureVersionsKt;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/nav/safeargs/module/NavInfoFetcher;", "", "module", "Lcom/intellij/openapi/module/Module;", "mode", "Lcom/android/tools/idea/nav/safeargs/SafeArgsMode;", "(Lcom/intellij/openapi/module/Module;Lcom/android/tools/idea/nav/safeargs/SafeArgsMode;)V", "androidFacetIfEnabled", "Lorg/jetbrains/android/facet/AndroidFacet;", "getAndroidFacetIfEnabled", "()Lorg/jetbrains/android/facet/AndroidFacet;", "isEnabled", "", "()Z", "modificationCount", "", "getModificationCount", "()J", "navVersion", "Lcom/android/ide/common/gradle/Version;", "getNavVersion", "()Lcom/android/ide/common/gradle/Version;", "getCurrentNavInfo", "Lcom/android/tools/idea/nav/safeargs/module/NavInfo;", "intellij.android.nav.safeargs"})
@SourceDebugExtension(value={"SMAP\nNavInfoFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavInfoFetcher.kt\ncom/android/tools/idea/nav/safeargs/module/NavInfoFetcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1#2:178\n1#2:189\n1603#3,9:179\n1851#3:188\n1852#3:190\n1612#3:191\n*S KotlinDebug\n*F\n+ 1 NavInfoFetcher.kt\ncom/android/tools/idea/nav/safeargs/module/NavInfoFetcher\n*L\n118#1:189\n118#1:179,9\n118#1:188\n118#1:190\n118#1:191\n*E\n"})
public final class NavInfoFetcher {
    @NotNull
    private final Module module;
    @NotNull
    private final SafeArgsMode mode;

    public NavInfoFetcher(@NotNull Module module2, @NotNull SafeArgsMode mode) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.module = module2;
        this.mode = mode;
    }

    private final AndroidFacet getAndroidFacetIfEnabled() {
        Object object;
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)this.module);
        if (androidFacet != null) {
            AndroidFacet androidFacet2;
            AndroidFacet it = androidFacet2 = androidFacet;
            boolean bl = false;
            object = SafeArgsModeKt.isSafeArgsEnabled(it) && SafeArgsModeKt.getSafeArgsMode(it) == this.mode ? androidFacet2 : null;
        } else {
            object = null;
        }
        return object;
    }

    public final boolean isEnabled() {
        return this.getAndroidFacetIfEnabled() != null;
    }

    public final long getModificationCount() {
        return ModuleNavigationResourcesModificationTracker.Companion.getInstance(this.module).getModificationCount();
    }

    @NotNull
    public final Version getNavVersion() {
        AndroidFacet androidFacet = this.getAndroidFacetIfEnabled();
        if (androidFacet == null || (androidFacet = SafeArgsFeatureVersionsKt.findNavigationVersion(androidFacet)) == null) {
            androidFacet = SafeArgsFeatureVersionsKt.getGRADLE_VERSION_ZERO();
        }
        return androidFacet;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final NavInfo getCurrentNavInfo() {
        void $this$mapNotNullTo$iv$iv;
        AndroidFacet androidFacet = this.getAndroidFacetIfEnabled();
        if (androidFacet == null) {
            return null;
        }
        AndroidFacet facet2 = androidFacet;
        String string = ProjectSystemUtil.getModuleSystem(facet2).getPackageName();
        if (string == null) {
            return null;
        }
        String modulePackage = string;
        if (DumbService.getInstance((Project)this.module.getProject()).isDumb()) {
            Logger.getInstance(this.getClass()).warn("Safe Args classes may be temporarily stale or unavailable due to indices not being ready right now.");
            return null;
        }
        Version navVersion = this.getNavVersion();
        long modificationCount = this.getModificationCount();
        LocalResourceRepository localResourceRepository = StudioResourceRepositoryManager.getModuleResources(facet2);
        Intrinsics.checkNotNullExpressionValue((Object)localResourceRepository, (String)"getModuleResources(facet)");
        LocalResourceRepository moduleResources = localResourceRepository;
        ListMultimap<String, ResourceItem> listMultimap = moduleResources.getResources(ResourceNamespace.RES_AUTO, ResourceType.NAVIGATION);
        Intrinsics.checkNotNullExpressionValue(listMultimap, (String)"moduleResources.getResou\u2026 ResourceType.NAVIGATION)");
        ListMultimap<String, ResourceItem> navResources = listMultimap;
        Collection collection2 = navResources.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"navResources.values()");
        Iterable $this$mapNotNull$iv = collection2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            NavEntry navEntry;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ResourceItem resource = (ResourceItem)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)resource, (String)"resource");
            if (IdeResourcesUtil.getSourceAsVirtualFile(resource) == null) {
                navEntry = null;
            } else {
                NavXmlData data;
                VirtualFile file2;
                Project project = this.module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
                navEntry = NavXmlIndex.Companion.getDataForFile(project, file2) == null ? null : new NavEntry(resource, file2, data);
            }
            if (navEntry == null) continue;
            NavEntry it$iv$iv = navEntry;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List entries2 = (List)destination$iv$iv;
        return new NavInfo(facet2, modulePackage, entries2, navVersion, modificationCount);
    }
}

