/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.projectmodel.DynamicResourceValue;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.model.Namespacing;
import com.android.tools.idea.model.TestExecutionOption;
import com.android.tools.idea.model.TestOptions;
import com.android.tools.lint.detector.api.Desugaring;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AndroidModel {
    public static final String UNINITIALIZED_APPLICATION_ID = "uninitialized.application.id";
    public static final Key<AndroidModel> KEY = Key.create((String)AndroidModel.class.getName());

    @Nullable
    public static AndroidModel get(@NotNull AndroidFacet facet2) {
        return (AndroidModel)facet2.getUserData(KEY);
    }

    @Nullable
    public static AndroidModel get(@NotNull Module module2) {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        return facet2 == null ? null : AndroidModel.get(facet2);
    }

    public static void set(@NotNull AndroidFacet facet2, @Nullable AndroidModel androidModel) {
        facet2.putUserData(KEY, (Object)androidModel);
    }

    public static boolean isRequired(@NotNull AndroidFacet facet2) {
        return !facet2.getProperties().ALLOW_USER_CONFIGURATION;
    }

    @NotNull
    public String getApplicationId();

    @NotNull
    public Set<String> getAllApplicationIds();

    public boolean overridesManifestPackage();

    public Boolean isDebuggable();

    @NotNull
    public AndroidVersion getMinSdkVersion();

    @NotNull
    public AndroidVersion getRuntimeMinSdkVersion();

    @Nullable
    public AndroidVersion getTargetSdkVersion();

    @NotNull
    default public EnumSet<Abi> getSupportedAbis() {
        return EnumSet.allOf(Abi.class);
    }

    @NotNull
    public Namespacing getNamespacing();

    @NotNull
    public Set<Desugaring> getDesugaring();

    @Nullable
    default public Iterable<File> getLintRuleJarsOverride() {
        return null;
    }

    @NotNull
    default public Map<String, DynamicResourceValue> getResValues() {
        return Collections.emptyMap();
    }

    @NotNull
    default public TestOptions getTestOptions() {
        return TestOptions.DEFAULT;
    }

    @Nullable
    default public TestExecutionOption getTestExecutionOption() {
        return this.getTestOptions().getExecutionOption();
    }

    @Nullable
    default public String getResourcePrefix() {
        return null;
    }

    default public boolean isBaseSplit() {
        return false;
    }

    default public boolean isInstantAppCompatible() {
        return false;
    }
}

