/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit.notifications;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.mlkit.MlUtils;
import com.android.tools.idea.mlkit.viewer.TfliteModelFileEditor;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingDependenciesNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"ml.missing.deps.notification.panel");
    private static final Key<String> HIDDEN_KEY = Key.create((String)"ml.missing.deps.notification.panel.hidden");

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (fileEditor.getUserData(HIDDEN_KEY) != null || !(fileEditor instanceof TfliteModelFileEditor)) {
            return null;
        }
        Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)project);
        if (module2 == null || !MlUtils.isMlModelBindingBuildFeatureEnabled(module2)) {
            return null;
        }
        if (MlUtils.isModelFileInMlModelsFolder(module2, file2) && !MlUtils.getMissingRequiredDependencies(module2).isEmpty()) {
            EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
            panel2.setText("ML Model Binding dependencies not found.");
            panel2.createActionLabel("Add Now", () -> {
                List<GradleCoordinate> depsToAdd = MlUtils.getMissingRequiredDependencies(module2);
                AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem(module2);
                if (DependencyManagementUtil.userWantsToAdd(module2.getProject(), depsToAdd, "")) {
                    for (GradleCoordinate dep : depsToAdd) {
                        moduleSystem.registerDependency(dep);
                    }
                    ProjectSystemUtil.getSyncManager(module2.getProject()).syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
                }
            });
            panel2.createActionLabel("Hide notification", () -> {
                fileEditor.putUserData(HIDDEN_KEY, (Object)"true");
                EditorNotifications.getInstance((Project)project).updateNotifications(file2);
            });
            return panel2;
        }
        return null;
    }
}

