/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Service
public final class ProjectMlModelFileTracker
extends SimpleModificationTracker {
    public ProjectMlModelFileTracker(@NotNull Project project) {
        project.getMessageBus().connect((Disposable)project).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                boolean hasModelFile = false;
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file2 = vFileEvent.getFile();
                    if (file2 == null || !"tflite".equalsIgnoreCase(file2.getExtension())) continue;
                    hasModelFile = true;
                    break;
                }
                if (hasModelFile) {
                    ProjectMlModelFileTracker.this.incModificationCount();
                }
            }
        });
    }

    @NotNull
    public static ProjectMlModelFileTracker getInstance(@NotNull Project project) {
        return (ProjectMlModelFileTracker)((Object)project.getService(ProjectMlModelFileTracker.class));
    }
}

