/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.mlkit.viewer.TfliteModelFileType;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.SourceProviders;
import com.android.tools.mlkit.MlNames;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MlUtils {
    private static final ImmutableList<String> REQUIRED_DEPENDENCY_LIST = ImmutableList.of((Object)"org.tensorflow:tensorflow-lite-support:0.1.0", (Object)"org.tensorflow:tensorflow-lite-metadata:0.1.0");

    private MlUtils() {
    }

    public static boolean isMlModelBindingBuildFeatureEnabled(@NotNull Module module2) {
        return AndroidFacet.getInstance((Module)module2) != null && ProjectSystemUtil.getModuleSystem(module2).isMlModelBindingEnabled();
    }

    public static boolean isModelFileInMlModelsFolder(@NotNull Module module2, @NotNull VirtualFile file2) {
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module2);
        return androidFacet != null && FileTypeRegistry.getInstance().isFileOfType(file2, (FileType)TfliteModelFileType.INSTANCE) && SourceProviders.getInstance(androidFacet).getCurrentAndSomeFrequentlyUsedInactiveSourceProviders().stream().flatMap(sourceProvider -> Streams.stream(sourceProvider.getMlModelsDirectories())).anyMatch(mlDir -> VfsUtilCore.isAncestor((VirtualFile)mlDir, (VirtualFile)file2, (boolean)true));
    }

    @NotNull
    public static String computeModelClassName(@NotNull Module module2, @NotNull VirtualFile file2) {
        String relativePath = MlUtils.relativePathToMlModelsFolder(module2, file2);
        return relativePath != null ? MlNames.computeModelClassName((String)relativePath) : "";
    }

    @Nullable
    private static String relativePathToMlModelsFolder(@NotNull Module module2, @NotNull VirtualFile file2) {
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module2);
        if (androidFacet == null || !FileTypeRegistry.getInstance().isFileOfType(file2, (FileType)TfliteModelFileType.INSTANCE)) {
            return null;
        }
        Optional<VirtualFile> ancestor = SourceProviders.getInstance(androidFacet).getCurrentAndSomeFrequentlyUsedInactiveSourceProviders().stream().flatMap(sourceProvider -> Streams.stream(sourceProvider.getMlModelsDirectories())).filter(mlDir -> VfsUtilCore.isAncestor((VirtualFile)mlDir, (VirtualFile)file2, (boolean)true)).findFirst();
        return ancestor.map(virtualFile -> VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)virtualFile)).orElse(null);
    }

    @NotNull
    public static List<GradleCoordinate> getMissingTfliteGpuDependencies(@NotNull Module module2) {
        return MlUtils.getMissingDependencies(module2, (ImmutableList<String>)ImmutableList.of((Object)"org.tensorflow:tensorflow-lite-gpu:2.3.0"));
    }

    @NotNull
    public static List<GradleCoordinate> getMissingRequiredDependencies(@NotNull Module module2) {
        return MlUtils.getMissingDependencies(module2, REQUIRED_DEPENDENCY_LIST);
    }

    @NotNull
    private static List<GradleCoordinate> getMissingDependencies(@NotNull Module module2, ImmutableList<String> dependencies2) {
        AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem(module2);
        ArrayList<GradleCoordinate> pendingDeps = new ArrayList<GradleCoordinate>();
        for (String requiredDepString : dependencies2) {
            GradleCoordinate requiredDep = Objects.requireNonNull(GradleCoordinate.parseCoordinateString((String)requiredDepString));
            GradleCoordinate requiredDepInAnyVersion = new GradleCoordinate(requiredDep.getGroupId(), requiredDep.getArtifactId(), "+");
            if (moduleSystem.getRegisteredDependency(requiredDepInAnyVersion) != null) continue;
            pendingDeps.add(requiredDep);
        }
        return pendingDeps;
    }

    @NotNull
    public static List<Pair<GradleCoordinate, GradleCoordinate>> getDependenciesLowerThanRequiredVersion(@NotNull Module module2) {
        AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem(module2);
        ArrayList<Pair<GradleCoordinate, GradleCoordinate>> resultDepPairList = new ArrayList<Pair<GradleCoordinate, GradleCoordinate>>();
        for (String requiredDepString : REQUIRED_DEPENDENCY_LIST) {
            GradleCoordinate requiredDep = Objects.requireNonNull(GradleCoordinate.parseCoordinateString((String)requiredDepString));
            GradleCoordinate requiredDepInAnyVersion = new GradleCoordinate(requiredDep.getGroupId(), requiredDep.getArtifactId(), "+");
            GradleCoordinate registeredDep = moduleSystem.getRegisteredDependency(requiredDepInAnyVersion);
            if (registeredDep == null || GradleCoordinate.COMPARE_PLUS_LOWER.compare(registeredDep, requiredDep) >= 0) continue;
            resultDepPairList.add((Pair<GradleCoordinate, GradleCoordinate>)Pair.create((Object)registeredDep, (Object)requiredDep));
        }
        return resultDepPairList;
    }
}

