/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit;

import com.android.tools.idea.mlkit.LightModelClassConfig;
import com.android.tools.idea.mlkit.MlModelFileIndex;
import com.android.tools.idea.mlkit.MlModelMetadata;
import com.android.tools.idea.mlkit.MlUtils;
import com.android.tools.idea.mlkit.ProjectMlModelFileTracker;
import com.android.tools.idea.mlkit.lightpsi.LightModelClass;
import com.android.tools.idea.projectsystem.ProjectSyncModificationTracker;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MlModuleService {
    private final Module myModule;
    private final Map<MlModelMetadata, LightModelClass> myLightModelClassMap = new ConcurrentHashMap<MlModelMetadata, LightModelClass>();

    public static MlModuleService getInstance(@NotNull Module module2) {
        return Objects.requireNonNull((MlModuleService)module2.getService(MlModuleService.class));
    }

    public MlModuleService(@NotNull Module module2) {
        this.myModule = module2;
    }

    @NotNull
    public List<LightModelClass> getLightModelClassList() {
        if (!MlUtils.isMlModelBindingBuildFeatureEnabled(this.myModule) || DumbService.isDumb((Project)this.myModule.getProject())) {
            return Collections.emptyList();
        }
        return (List)CachedValuesManager.getManager((Project)this.myModule.getProject()).getCachedValue((UserDataHolder)this.myModule, () -> {
            Set<MlModelMetadata> latestModelMetadataSet = MlModelFileIndex.getModelMetadataSet(this.myModule);
            List outdatedModelMetadataList = ContainerUtil.filter(this.myLightModelClassMap.keySet(), modelMetadata -> !latestModelMetadataSet.contains(modelMetadata));
            for (MlModelMetadata outdatedModelMetadata : outdatedModelMetadataList) {
                this.myLightModelClassMap.remove(outdatedModelMetadata);
            }
            ArrayList<LightModelClass> lightModelClassList = new ArrayList<LightModelClass>();
            for (MlModelMetadata modelMetadata2 : latestModelMetadataSet) {
                LightModelClass lightModelClass = this.getOrCreateLightModelClass(modelMetadata2);
                if (lightModelClass == null) continue;
                lightModelClassList.add(lightModelClass);
            }
            return CachedValueProvider.Result.create(lightModelClassList, MlModuleService.getProjectDependencies(this.myModule.getProject()));
        });
    }

    @Nullable
    private LightModelClass getOrCreateLightModelClass(@NotNull MlModelMetadata modelMetadata) {
        return this.myLightModelClassMap.computeIfAbsent(modelMetadata, key -> {
            String packageName2 = ProjectSystemUtil.getModuleSystem(this.myModule).getPackageName();
            if (packageName2 == null) {
                Logger.getInstance(MlModuleService.class).warn("Can not determine the package name for module: " + this.myModule.getName());
                return null;
            }
            String modelFileUrl = modelMetadata.myModelFileUrl;
            VirtualFile modelFile = VirtualFileManager.getInstance().findFileByUrl(modelFileUrl);
            if (modelFile == null) {
                Logger.getInstance(MlModuleService.class).warn("Failed to find the virtual file for: " + modelFileUrl);
                return null;
            }
            String className = MlUtils.computeModelClassName(this.myModule, modelFile);
            if (Strings.isNullOrEmpty((String)className)) {
                Logger.getInstance(MlModuleService.class).warn("Can not determine the class name for: " + modelFileUrl);
                return null;
            }
            LightModelClassConfig classConfig = new LightModelClassConfig(modelMetadata, packageName2 + ".ml", className);
            return new LightModelClass(this.myModule, modelFile, classConfig);
        });
    }

    static Collection<Object> getProjectDependencies(@NotNull Project project) {
        return Lists.newArrayList((Object[])new Object[]{ProjectMlModelFileTracker.getInstance(project), DumbService.getInstance((Project)project).getModificationTracker(), ModuleManager.getInstance((Project)project), ProjectSyncModificationTracker.getInstance(project)});
    }
}

