/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.memorysettings;

import com.android.tools.idea.memorysettings.MemorySettingsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class MemorySettingsRecommendation {
    private static final Logger LOG = Logger.getInstance(MemorySettingsRecommendation.class);

    public static int getRecommended(@Nullable Project project, int currentXmx) {
        if (project == null || currentXmx < 0) {
            return -1;
        }
        int basedOnMachine = MemorySettingsRecommendation.getRecommendedBasedOnMachine();
        int basedOnProject = MemorySettingsRecommendation.getRecommendedBasedOnModuleCount(project);
        int recommended = Math.min(basedOnMachine, basedOnProject);
        if (basedOnMachine >= 2048 && recommended < 2048 && !SystemInfo.isWindows) {
            recommended = 2048;
        }
        LOG.info(String.format(Locale.US, "recommendation based on machine: %d, on project: %d", basedOnMachine, basedOnProject));
        return (double)currentXmx < (double)recommended * 0.9 ? recommended : -1;
    }

    private static int getRecommendedBasedOnMachine() {
        int machineMemInGB = MemorySettingsUtil.getMachineMem() >> 10;
        boolean isWindows = SystemInfo.isWindows;
        if (machineMemInGB < 8) {
            return isWindows ? 1280 : 1536;
        }
        if (machineMemInGB < 12) {
            return isWindows ? 1536 : 2048;
        }
        if (machineMemInGB < 16) {
            return 3072;
        }
        return 4096;
    }

    private static int getRecommendedBasedOnModuleCount(Project project) {
        int count2 = ModuleManager.getInstance((Project)project).getModules().length;
        if (count2 < 50) {
            return 1280;
        }
        if (count2 < 100) {
            return 2048;
        }
        if (count2 < 200) {
            return 3072;
        }
        return 4096;
    }
}

