/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.memorysettings;

import com.android.tools.idea.memorysettings.MemorySettingsUtil;
import com.google.wireless.android.sdk.stats.MemorySettingsEvent;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.LowMemoryWatcher;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

@Service
public final class AndroidLowMemoryNotifier
implements Disposable {
    private LowMemoryWatcher myWatcher;
    private final AtomicBoolean myNotificationShown = new AtomicBoolean();

    public static AndroidLowMemoryNotifier getInstance() {
        return (AndroidLowMemoryNotifier)ApplicationManager.getApplication().getService(AndroidLowMemoryNotifier.class);
    }

    private AndroidLowMemoryNotifier() {
        this.myWatcher = LowMemoryWatcher.register(this::onLowMemorySignalReceived, (LowMemoryWatcher.LowMemoryWatcherType)LowMemoryWatcher.LowMemoryWatcherType.ONLY_AFTER_GC);
    }

    private void onLowMemorySignalReceived() {
        int currentXmx = MemorySettingsUtil.getCurrentXmx();
        int xmxCap = MemorySettingsUtil.getIdeXmxCapInGB() * 1024;
        if (this.myNotificationShown.compareAndSet(false, true) && currentXmx < xmxCap) {
            String content2 = AndroidBundle.message("low.memory.notification.content", new Object[0]);
            new Notification("Low Memory", AndroidBundle.message("low.memory.notification.title", new Object[0]), content2, NotificationType.WARNING).addAction((AnAction)NotificationAction.createExpiring((String)IdeBundle.message((String)"low.memory.notification.action", (Object[])new Object[0]), (e, n) -> {
                MemorySettingsUtil.log(MemorySettingsEvent.EventKind.CONFIGURE, currentXmx, -1, -1, -1, -1, -1, -1, -1, -1);
                ShowSettingsUtilImpl.showSettingsDialog((Project)e.getProject(), (String)"memory.settings", (String)"");
            })).notify(null);
        }
    }

    public void dispose() {
        this.myWatcher.stop();
        this.myWatcher = null;
    }

    private static class Initializer
    implements StartupActivity.Background {
        private Initializer() {
        }

        public void runActivity(@NotNull Project project) {
            AndroidLowMemoryNotifier.getInstance();
        }
    }
}

