/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.material.icons.utils;

import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.material.icons.metadata.MaterialIconsMetadata;
import com.android.tools.idea.sdk.AndroidSdks;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J\u0016\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\n\u0010\u0017\u001a\u00020\u0007*\u00020\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/material/icons/utils/MaterialIconsUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MATERIAL_ICONS_PATH", "", "METADATA_FILE_NAME", "getBundledIconPath", "styleName", "iconName", "iconFileName", "getBundledStyleDirectoryPath", "getIconFileNameWithoutExtension", "getIconsSdkTargetPath", "Ljava/io/File;", "getMetadata", "Lcom/android/tools/idea/material/icons/metadata/MaterialIconsMetadata;", "url", "Ljava/net/URL;", "hasMetadataFileInSdkPath", "", "toDirFormat", "intellij.android.android-material"})
public final class MaterialIconsUtils {
    @NotNull
    public static final MaterialIconsUtils INSTANCE = new MaterialIconsUtils();
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String MATERIAL_ICONS_PATH = "images/material/icons/";
    @NotNull
    public static final String METADATA_FILE_NAME = "icons_metadata.txt";

    private MaterialIconsUtils() {
    }

    @NotNull
    public final String getBundledStyleDirectoryPath(@NotNull String styleName) {
        Intrinsics.checkNotNullParameter((Object)styleName, (String)"styleName");
        return MATERIAL_ICONS_PATH + this.toDirFormat(styleName);
    }

    @NotNull
    public final String getBundledIconPath(@NotNull String styleName, @NotNull String iconName, @NotNull String iconFileName) {
        Intrinsics.checkNotNullParameter((Object)styleName, (String)"styleName");
        Intrinsics.checkNotNullParameter((Object)iconName, (String)"iconName");
        Intrinsics.checkNotNullParameter((Object)iconFileName, (String)"iconFileName");
        return this.getBundledStyleDirectoryPath(styleName) + "/" + iconName + "/" + iconFileName;
    }

    @NotNull
    public final String toDirFormat(@NotNull String $this$toDirFormat) {
        Intrinsics.checkNotNullParameter((Object)$this$toDirFormat, (String)"<this>");
        String string = $this$toDirFormat;
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        return StringsKt.replace$default((String)string2, (String)" ", (String)"", (boolean)false, (int)4, null);
    }

    @Nullable
    public final File getIconsSdkTargetPath() {
        AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"getInstance().tryToChooseSdkHandler()");
        AndroidSdkHandler sdkHandler = androidSdkHandler;
        Path path2 = sdkHandler.getLocation();
        if (path2 == null) {
            return null;
        }
        Path sdkHome = path2;
        Path materialDir = sdkHome.resolve("icons/material");
        return Files.createDirectories(materialDir, new FileAttribute[0]).toFile();
    }

    public final boolean hasMetadataFileInSdkPath() {
        File iconsSdkPath = this.getIconsSdkTargetPath();
        return iconsSdkPath != null && FilesKt.resolve((File)iconsSdkPath, (String)METADATA_FILE_NAME).exists();
    }

    @NotNull
    public final MaterialIconsMetadata getMetadata(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return MaterialIconsMetadata.Companion.parse(url, LOG);
    }

    @NotNull
    public final String getIconFileNameWithoutExtension(@NotNull String iconName, @NotNull String styleName) {
        String family;
        Intrinsics.checkNotNullParameter((Object)iconName, (String)"iconName");
        Intrinsics.checkNotNullParameter((Object)styleName, (String)"styleName");
        String string = family = StringsKt.substringAfter$default((String)this.toDirFormat(styleName), (String)"materialicons", null, (int)2, null);
        String familyPrefix = Intrinsics.areEqual((Object)string, (Object)"") ? "baseline" : (Intrinsics.areEqual((Object)string, (Object)"outlined") ? "outline" : family);
        return familyPrefix + "_" + iconName + "_24";
    }

    static {
        Logger logger2 = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(javaClass)");
        LOG = logger2;
    }
}

