/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.material.icons.metadata;

import com.android.tools.idea.material.icons.common.BundledMetadataUrlProvider;
import com.android.tools.idea.material.icons.common.SdkMetadataUrlProvider;
import com.android.tools.idea.material.icons.metadata.MaterialIconsMetadata;
import com.android.tools.idea.material.icons.metadata.MaterialIconsMetadataDownloadCacheServiceKt;
import com.android.tools.idea.material.icons.metadata.MaterialIconsMetadataDownloadService;
import com.android.tools.idea.material.icons.utils.MaterialIconsUtils;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/material/icons/metadata/MaterialIconsMetadataDownloadCacheService;", "", "()V", "cachedMetadataDownloadService", "Lcom/android/tools/idea/material/icons/metadata/MaterialIconsMetadataDownloadService;", "getDownloadService", "downloadDir", "Ljava/io/File;", "fallbackMetadataURL", "Ljava/net/URL;", "getMetadata", "Ljava/util/concurrent/CompletableFuture;", "Lcom/android/tools/idea/material/icons/metadata/MaterialIconsMetadata;", "intellij.android.android-material"})
public final class MaterialIconsMetadataDownloadCacheService {
    @Nullable
    private MaterialIconsMetadataDownloadService cachedMetadataDownloadService;

    @NotNull
    public final CompletableFuture<MaterialIconsMetadata> getMetadata() {
        URL uRL = new SdkMetadataUrlProvider().getMetadataUrl();
        if (uRL == null) {
            uRL = new BundledMetadataUrlProvider().getMetadataUrl();
        }
        if (uRL == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        URL fallbackMetadataURL = uRL;
        File downloadDir = new File(FileUtil.getTempDirectory());
        if (!downloadDir.isDirectory()) {
            CompletableFuture<MaterialIconsMetadata> completableFuture = CompletableFuture.completedFuture(MaterialIconsUtils.INSTANCE.getMetadata(fallbackMetadataURL));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(getMetadata(fallbackMetadataURL))");
            return completableFuture;
        }
        return MaterialIconsMetadataDownloadCacheServiceKt.access$refreshAndGetMetadata(this.getDownloadService(downloadDir, fallbackMetadataURL), fallbackMetadataURL);
    }

    private final MaterialIconsMetadataDownloadService getDownloadService(File downloadDir, URL fallbackMetadataURL) {
        MaterialIconsMetadataDownloadService downloadService;
        MaterialIconsMetadataDownloadService materialIconsMetadataDownloadService = this.cachedMetadataDownloadService;
        if (materialIconsMetadataDownloadService == null) {
            materialIconsMetadataDownloadService = new MaterialIconsMetadataDownloadService(downloadDir, fallbackMetadataURL);
        }
        this.cachedMetadataDownloadService = downloadService = materialIconsMetadataDownloadService;
        return downloadService;
    }
}

