/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.material.icons;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.vectordrawable.VdIcon;
import com.android.tools.idea.material.icons.MaterialIconsCopyHandlerKt;
import com.android.tools.idea.material.icons.MaterialVdIcons;
import com.android.tools.idea.material.icons.VdIconURLWithFileName;
import com.android.tools.idea.material.icons.VdIconWriteData;
import com.android.tools.idea.material.icons.metadata.MaterialIconsMetadata;
import com.android.tools.idea.material.icons.metadata.MaterialIconsMetadataBuilder;
import com.android.tools.idea.material.icons.metadata.MaterialMetadataIcon;
import com.android.tools.idea.material.icons.utils.MaterialIconsUtils;
import com.android.utils.SdkUtils;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J0\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J<\u0010\u001d\u001a\u00020\u00162\"\u0010\u001e\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\rj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e`\u000f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J,\u0010\"\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\rj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e`\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010#\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010%\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\rj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/material/icons/MaterialIconsCopyHandler;", "", "metadata", "Lcom/android/tools/idea/material/icons/metadata/MaterialIconsMetadata;", "materialVdIcons", "Lcom/android/tools/idea/material/icons/MaterialVdIcons;", "(Lcom/android/tools/idea/material/icons/metadata/MaterialIconsMetadata;Lcom/android/tools/idea/material/icons/MaterialVdIcons;)V", "families", "", "", "[Ljava/lang/String;", "host", "iconNameToWriteData", "Ljava/util/HashMap;", "Lcom/android/tools/idea/material/icons/VdIconWriteData;", "Lkotlin/collections/HashMap;", "urlPattern", "alreadyCopied", "", "targetPath", "Ljava/io/File;", "copyIcon", "", "iconUrl", "Ljava/net/URL;", "iconFileName", "family", "iconMetadata", "Lcom/android/tools/idea/material/icons/metadata/MaterialMetadataIcon;", "copyIcons", "iconsToCopy", "metadataBuilder", "Lcom/android/tools/idea/material/icons/metadata/MaterialIconsMetadataBuilder;", "copyTo", "getRemainingIconsToCopy", "restoreMetadata", "updateFinishedMetadataFileName", "updateTemporaryMetadataFile", "intellij.android.android-material"})
@SourceDebugExtension(value={"SMAP\nMaterialIconsCopyHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaterialIconsCopyHandler.kt\ncom/android/tools/idea/material/icons/MaterialIconsCopyHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n13543#2,2:197\n13543#2:199\n13543#2,2:200\n13544#2:202\n13543#2,2:205\n13543#2,2:212\n211#3,2:203\n211#3,2:208\n1851#4:207\n1852#4:210\n1#5:211\n*S KotlinDebug\n*F\n+ 1 MaterialIconsCopyHandler.kt\ncom/android/tools/idea/material/icons/MaterialIconsCopyHandler\n*L\n64#1:197,2\n71#1:199\n72#1:200,2\n71#1:202\n121#1:205,2\n169#1:212,2\n85#1:203,2\n136#1:208,2\n130#1:207\n130#1:210\n*E\n"})
public final class MaterialIconsCopyHandler {
    @NotNull
    private final String host;
    @NotNull
    private final String urlPattern;
    @NotNull
    private final String[] families;
    @NotNull
    private final HashMap<String, VdIconWriteData> iconNameToWriteData;

    public MaterialIconsCopyHandler(@NotNull MaterialIconsMetadata metadata, @NotNull MaterialVdIcons materialVdIcons) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)materialVdIcons, (String)"materialVdIcons");
        this.host = metadata.getHost();
        this.urlPattern = metadata.getUrlPattern();
        this.families = metadata.getFamilies();
        this.iconNameToWriteData = new HashMap();
        HashMap iconNameToMetadata = new HashMap();
        MaterialMetadataIcon[] $this$forEach$iv = metadata.getIcons();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            MaterialMetadataIcon element$iv;
            MaterialMetadataIcon it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            ((Map)iconNameToMetadata).put(it.getName(), it);
        }
        HashMap iconNameToStyleAndUrl = new HashMap();
        Object $this$forEach$iv2 = materialVdIcons.getStyles();
        boolean $i$f$forEach2 = false;
        int element$iv = ((String[])$this$forEach$iv2).length;
        for (n = 0; n < element$iv; ++n) {
            String element$iv2;
            String style = element$iv2 = $this$forEach$iv2[n];
            boolean bl = false;
            VdIcon[] $this$forEach$iv3 = materialVdIcons.getAllIcons(style);
            boolean $i$f$forEach3 = false;
            int n2 = $this$forEach$iv3.length;
            for (int i = 0; i < n2; ++i) {
                Object object;
                Map map2;
                VdIcon element$iv3;
                VdIcon vdIcon = element$iv3 = $this$forEach$iv3[i];
                boolean bl2 = false;
                String string = vdIcon.getDisplayName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"vdIcon.displayName");
                String iconName = StringsKt.replace$default((String)string, (String)" ", (String)"_", (boolean)false, (int)4, null);
                if (!((Map)iconNameToStyleAndUrl).containsKey(iconName)) {
                    map2 = iconNameToStyleAndUrl;
                    object = new HashMap<String, VdIconURLWithFileName>();
                    HashMap<String, VdIconURLWithFileName> $this$lambda_u243_u24lambda_u242_u24lambda_u241 = object;
                    boolean bl3 = false;
                    URL uRL = vdIcon.getURL();
                    Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"vdIcon.url");
                    String string2 = vdIcon.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"vdIcon.name");
                    $this$lambda_u243_u24lambda_u242_u24lambda_u241.put(style, new VdIconURLWithFileName(uRL, string2));
                    map2.put(iconName, object);
                    continue;
                }
                Object v = iconNameToStyleAndUrl.get(iconName);
                Intrinsics.checkNotNull(v);
                map2 = (Map)v;
                URL uRL = vdIcon.getURL();
                Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"vdIcon.url");
                String string3 = vdIcon.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"vdIcon.name");
                object = new VdIconURLWithFileName(uRL, string3);
                map2.put(style, object);
            }
        }
        $this$forEach$iv2 = iconNameToMetadata;
        $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            String iconName = (String)entry.getKey();
            MaterialMetadataIcon metadata2 = (MaterialMetadataIcon)entry.getValue();
            if (iconNameToStyleAndUrl.containsKey(iconName)) {
                Map map3 = this.iconNameToWriteData;
                Object v = iconNameToStyleAndUrl.get(iconName);
                Intrinsics.checkNotNull(v);
                map3.put(iconName, new VdIconWriteData((HashMap)v, metadata2));
                continue;
            }
            MaterialIconsCopyHandlerKt.access$getLOG$p().warn("Files not found for '" + iconName + "'");
        }
    }

    @Slow
    public final void copyTo(@NotNull File targetPath) {
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        if (!targetPath.isDirectory()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.alreadyCopied(targetPath)) {
            MaterialIconsCopyHandlerKt.access$getLOG$p().info("Icons have already been copied to this directory.");
            return;
        }
        MaterialIconsMetadataBuilder metadataBuilder = this.restoreMetadata(targetPath);
        HashMap<String, VdIconWriteData> iconsToCopy = this.getRemainingIconsToCopy(metadataBuilder);
        if (iconsToCopy.isEmpty()) {
            return;
        }
        this.copyIcons(iconsToCopy, metadataBuilder, targetPath);
    }

    private final HashMap<String, VdIconWriteData> getRemainingIconsToCopy(MaterialIconsMetadataBuilder metadataBuilder) {
        HashMap<String, VdIconWriteData> iconsToCopy = new HashMap<String, VdIconWriteData>((Map)this.iconNameToWriteData);
        MaterialMetadataIcon[] $this$forEach$iv = metadataBuilder.build().getIcons();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            MaterialMetadataIcon element$iv;
            MaterialMetadataIcon it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            iconsToCopy.remove(it.getName());
        }
        return iconsToCopy;
    }

    private final void copyIcons(HashMap<String, VdIconWriteData> iconsToCopy, MaterialIconsMetadataBuilder metadataBuilder, File targetPath) {
        boolean cancelled = false;
        Collection<VdIconWriteData> collection2 = iconsToCopy.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"iconsToCopy.values");
        Iterable $this$forEach$iv = collection2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VdIconWriteData writeData = (VdIconWriteData)element$iv;
            boolean bl = false;
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            boolean bl2 = progressIndicator != null ? progressIndicator.isCanceled() : false;
            if (bl2) {
                cancelled = true;
                continue;
            }
            MaterialMetadataIcon iconMetadata = writeData.getMetadataIcon();
            Map $this$forEach$iv2 = writeData.getStylesToURLAndName();
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry entry = element$iv2 = iterator2.next();
                boolean bl3 = false;
                String family = (String)entry.getKey();
                VdIconURLWithFileName urlAndFileName = (VdIconURLWithFileName)entry.getValue();
                if (ArraysKt.contains((Object[])iconMetadata.getUnsupportedFamilies(), (Object)family)) continue;
                this.copyIcon(urlAndFileName.getUrl(), urlAndFileName.getFileName(), family, iconMetadata, targetPath);
            }
            metadataBuilder.addIconMetadata(iconMetadata);
        }
        this.updateTemporaryMetadataFile(metadataBuilder, targetPath);
        if (!cancelled) {
            this.updateFinishedMetadataFileName(targetPath);
        }
    }

    private final void copyIcon(URL iconUrl, String iconFileName, String family, MaterialMetadataIcon iconMetadata, File targetPath) {
        Serializable serializable;
        File $this$copyIcon_u24lambda_u248 = serializable = FilesKt.resolve((File)FilesKt.resolve((File)targetPath, (String)MaterialIconsUtils.INSTANCE.toDirFormat(family)), (String)iconMetadata.getName());
        boolean bl = false;
        $this$copyIcon_u24lambda_u248.mkdirs();
        File vdIconDir = serializable;
        serializable = iconUrl;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)serializable);
        FilesKt.writeText$default((File)new File(vdIconDir, iconFileName), (String)new String(byArray, charset), null, (int)2, null);
    }

    private final void updateTemporaryMetadataFile(MaterialIconsMetadataBuilder metadataBuilder, File targetPath) {
        Path tempFilePath = targetPath.toPath().resolve("icons_metadata_temp_copy.txt");
        MaterialIconsMetadata materialIconsMetadata = metadataBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)tempFilePath, (String)"tempFilePath");
        MaterialIconsMetadata.Companion.writeAsJson(materialIconsMetadata, tempFilePath, MaterialIconsCopyHandlerKt.access$getLOG$p());
    }

    private final boolean alreadyCopied(File targetPath) {
        File $this$alreadyCopied_u24lambda_u249 = new File(targetPath, "icons_metadata.txt");
        boolean bl = false;
        return !$this$alreadyCopied_u24lambda_u249.isDirectory() && $this$alreadyCopied_u24lambda_u249.exists();
    }

    private final MaterialIconsMetadataBuilder restoreMetadata(File targetPath) {
        MaterialIconsMetadataBuilder metadataBuilder = new MaterialIconsMetadataBuilder(this.host, this.urlPattern, this.families);
        File metadataTempFile = new File(targetPath, "icons_metadata_temp_copy.txt");
        if (metadataTempFile.exists() && !metadataTempFile.isDirectory()) {
            MaterialIconsCopyHandlerKt.access$getLOG$p().info("Continuing icons copy");
            URL uRL = SdkUtils.fileToUrl((File)metadataTempFile);
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"fileToUrl(metadataTempFile)");
            MaterialIconsMetadata metadata = MaterialIconsMetadata.Companion.parse(uRL, MaterialIconsCopyHandlerKt.access$getLOG$p());
            MaterialMetadataIcon[] $this$forEach$iv = metadata.getIcons();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                MaterialMetadataIcon element$iv;
                MaterialMetadataIcon it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                metadataBuilder.addIconMetadata(it);
            }
        }
        return metadataBuilder;
    }

    private final void updateFinishedMetadataFileName(File targetPath) {
        File metadataFinishedFile = FilesKt.resolve((File)targetPath, (String)"icons_metadata.txt");
        File metadataTempFile = FilesKt.resolve((File)targetPath, (String)"icons_metadata_temp_copy.txt");
        if (!metadataTempFile.exists()) {
            MaterialIconsCopyHandlerKt.access$getLOG$p().warn("No temporary metadata file");
            return;
        }
        try {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.move(metadataTempFile.toPath(), metadataFinishedFile.toPath(), copyOptionArray);
        }
        catch (IOException e) {
            MaterialIconsCopyHandlerKt.access$getLOG$p().warn("Failed to rename temporary metadata file", (Throwable)e);
        }
    }
}

