/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.util;

import com.android.tools.idea.logcat.message.LogcatMessage;
import com.android.tools.idea.logcat.util.MessagesFileKt;
import com.android.tools.idea.logcat.util.TempFileFactory;
import com.intellij.openapi.diagnostic.Logger;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0006\u0010\u0014\u001a\u00020\u0010J\u0006\u0010\u0015\u001a\u00020\u0010J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/logcat/util/MessagesFile;", "", "name", "", "maxSizeBytes", "", "(Ljava/lang/String;I)V", "file", "Ljava/nio/file/Path;", "outputStream", "Ljava/io/ObjectOutputStream;", "previousFile", "sizeBytes", "tempFileFactory", "Lcom/android/tools/idea/logcat/util/TempFileFactory;", "appendMessages", "", "messages", "", "Lcom/android/tools/idea/logcat/message/LogcatMessage;", "delete", "initialize", "loadMessagesAndDelete", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nMessagesFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessagesFile.kt\ncom/android/tools/idea/logcat/util/MessagesFile\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n12#2,5:137\n19#2,4:142\n19#2,4:146\n1851#3,2:150\n*S KotlinDebug\n*F\n+ 1 MessagesFile.kt\ncom/android/tools/idea/logcat/util/MessagesFile\n*L\n59#1:137,5\n69#1:142,4\n77#1:146,4\n78#1:150,2\n*E\n"})
public final class MessagesFile {
    @NotNull
    private final String name;
    private final int maxSizeBytes;
    @NotNull
    private final TempFileFactory tempFileFactory;
    @Nullable
    private Path file;
    @Nullable
    private Path previousFile;
    @Nullable
    private ObjectOutputStream outputStream;
    private int sizeBytes;

    public MessagesFile(@NotNull String name2, int maxSizeBytes) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.name = name2;
        this.maxSizeBytes = maxSizeBytes;
        this.tempFileFactory = TempFileFactory.Companion.getInstance();
    }

    /*
     * WARNING - void declaration
     */
    public final void initialize() {
        void it;
        Path path2;
        Path path3 = path2 = this.tempFileFactory.createTempFile("studio-" + this.name, ".bin");
        MessagesFile messagesFile = this;
        boolean bl = false;
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream((Path)it, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(this, *options)");
        this.outputStream = new ObjectOutputStream(outputStream);
        messagesFile.file = path2;
        this.sizeBytes = 0;
        Logger $this$debug_u24default$iv = MessagesFileKt.access$getLogger$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            messagesFile = $this$debug_u24default$iv;
            boolean bl2 = false;
            Path path4 = this.file;
            messagesFile.debug("Created message file " + (path4 != null ? PathsKt.getName((Path)path4) : null), e$iv);
        }
    }

    public final void appendMessages(@NotNull List<LogcatMessage> messages) {
        Logger logger2;
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        if (this.sizeBytes > this.maxSizeBytes) {
            Logger $this$trace$iv = MessagesFileKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger2 = $this$trace$iv;
                boolean bl = false;
                Path path2 = this.file;
                logger2.trace("File " + (path2 != null ? PathsKt.getName((Path)path2) : null) + " exceeded max size (" + this.sizeBytes + " > " + this.maxSizeBytes + ")");
            }
            ObjectOutputStream objectOutputStream = this.outputStream;
            if (objectOutputStream != null) {
                MessagesFileKt.access$writeEofAndClose(objectOutputStream);
            }
            MessagesFileKt.access$delete(this.previousFile);
            this.previousFile = this.file;
            this.initialize();
        }
        ObjectOutputStream objectOutputStream = this.outputStream;
        if (objectOutputStream == null) {
            throw new IllegalStateException("message file for " + this.name + " is not initialized");
        }
        ObjectOutputStream stream = objectOutputStream;
        Logger $this$trace$iv = MessagesFileKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger2 = $this$trace$iv;
            boolean bl = false;
            Path path3 = this.file;
            logger2.trace("Appending " + messages.size() + " messages to file " + (path3 != null ? PathsKt.getName((Path)path3) : null));
        }
        Iterable $this$forEach$iv = messages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LogcatMessage it = (LogcatMessage)element$iv;
            boolean bl = false;
            this.sizeBytes += it.getMessage().length();
            it.writeExternal(stream);
        }
    }

    @NotNull
    public final List<LogcatMessage> loadMessagesAndDelete() {
        List list2;
        ObjectOutputStream objectOutputStream = this.outputStream;
        if (objectOutputStream != null) {
            MessagesFileKt.access$writeEofAndClose(objectOutputStream);
        }
        List $this$loadMessagesAndDelete_u24lambda_u245 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable<Path> iterable = this.previousFile;
        $this$loadMessagesAndDelete_u24lambda_u245.addAll(iterable != null && (iterable = MessagesFileKt.access$readMessages(iterable)) != null ? (Collection)iterable : (Collection)CollectionsKt.emptyList());
        Iterable<Path> iterable2 = this.file;
        if (iterable2 == null || (iterable2 = MessagesFileKt.access$readMessages(iterable2)) == null) {
            throw new IllegalStateException("message file for " + this.name + " is not initialized");
        }
        $this$loadMessagesAndDelete_u24lambda_u245.addAll((Collection)iterable2);
        this.delete();
        return CollectionsKt.build((List)list2);
    }

    public final void delete() {
        MessagesFileKt.access$delete(this.file);
        MessagesFileKt.access$delete(this.previousFile);
        this.file = null;
        this.previousFile = null;
        this.outputStream = null;
        this.sizeBytes = 0;
    }
}

