/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.util;

import com.android.tools.idea.logcat.message.LogLevel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0003\u000e\u000f\u0010B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\bH&J\u0006\u0010\f\u001a\u00020\rR\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0003\u0011\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/logcat/util/FilterHint;", "", "()V", "length", "", "getLength", "()I", "text", "", "getText", "()Ljava/lang/String;", "getFilter", "isElided", "", "AppName", "Level", "Tag", "Lcom/android/tools/idea/logcat/util/FilterHint$AppName;", "Lcom/android/tools/idea/logcat/util/FilterHint$Level;", "Lcom/android/tools/idea/logcat/util/FilterHint$Tag;", "intellij.android.logcat"})
public abstract class FilterHint {
    private FilterHint() {
    }

    @NotNull
    public abstract String getText();

    public abstract int getLength();

    public final boolean isElided() {
        return this.getText().length() > this.getLength();
    }

    @NotNull
    public abstract String getFilter();

    public /* synthetic */ FilterHint(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/logcat/util/FilterHint$AppName;", "Lcom/android/tools/idea/logcat/util/FilterHint;", "text", "", "length", "", "(Ljava/lang/String;I)V", "getLength", "()I", "getText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "getFilter", "hashCode", "toString", "intellij.android.logcat"})
    public static final class AppName
    extends FilterHint {
        @NotNull
        private final String text;
        private final int length;

        public AppName(@NotNull String text2, int length) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            super(null);
            this.text = text2;
            this.length = length;
        }

        @Override
        @NotNull
        public String getText() {
            return this.text;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        @NotNull
        public String getFilter() {
            return "package:" + this.getText();
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        public final int component2() {
            return this.length;
        }

        @NotNull
        public final AppName copy(@NotNull String text2, int length) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return new AppName(text2, length);
        }

        public static /* synthetic */ AppName copy$default(AppName appName, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = appName.text;
            }
            if ((n2 & 2) != 0) {
                n = appName.length;
            }
            return appName.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "AppName(text=" + this.text + ", length=" + this.length + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.length);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AppName)) {
                return false;
            }
            AppName appName = (AppName)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)appName.text)) {
                return false;
            }
            return this.length == appName.length;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\b\u0010\u0015\u001a\u00020\fH\u0016J\t\u0010\u0016\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\fH\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/logcat/util/FilterHint$Level;", "Lcom/android/tools/idea/logcat/util/FilterHint;", "level", "Lcom/android/tools/idea/logcat/message/LogLevel;", "(Lcom/android/tools/idea/logcat/message/LogLevel;)V", "length", "", "getLength", "()I", "getLevel", "()Lcom/android/tools/idea/logcat/message/LogLevel;", "text", "", "getText", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "getFilter", "hashCode", "toString", "intellij.android.logcat"})
    public static final class Level
    extends FilterHint {
        @NotNull
        private final LogLevel level;
        @NotNull
        private final String text;
        private final int length;

        public Level(@NotNull LogLevel level) {
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            super(null);
            this.level = level;
            this.text = " " + this.level.getPriorityLetter() + " ";
            this.length = 3;
        }

        @NotNull
        public final LogLevel getLevel() {
            return this.level;
        }

        @Override
        @NotNull
        public String getText() {
            return this.text;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        @NotNull
        public String getFilter() {
            return "level:" + this.level.name();
        }

        @NotNull
        public final LogLevel component1() {
            return this.level;
        }

        @NotNull
        public final Level copy(@NotNull LogLevel level) {
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            return new Level(level);
        }

        public static /* synthetic */ Level copy$default(Level level, LogLevel logLevel, int n, Object object) {
            if ((n & 1) != 0) {
                logLevel = level.level;
            }
            return level.copy(logLevel);
        }

        @NotNull
        public String toString() {
            return "Level(level=" + this.level + ")";
        }

        public int hashCode() {
            return this.level.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Level)) {
                return false;
            }
            Level level = (Level)other;
            return this.level == level.level;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/logcat/util/FilterHint$Tag;", "Lcom/android/tools/idea/logcat/util/FilterHint;", "text", "", "length", "", "(Ljava/lang/String;I)V", "getLength", "()I", "getText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "getFilter", "hashCode", "toString", "intellij.android.logcat"})
    public static final class Tag
    extends FilterHint {
        @NotNull
        private final String text;
        private final int length;

        public Tag(@NotNull String text2, int length) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            super(null);
            this.text = text2;
            this.length = length;
        }

        @Override
        @NotNull
        public String getText() {
            return this.text;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        @NotNull
        public String getFilter() {
            return "tag:" + this.getText();
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        public final int component2() {
            return this.length;
        }

        @NotNull
        public final Tag copy(@NotNull String text2, int length) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return new Tag(text2, length);
        }

        public static /* synthetic */ Tag copy$default(Tag tag, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = tag.text;
            }
            if ((n2 & 2) != 0) {
                n = tag.length;
            }
            return tag.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "Tag(text=" + this.text + ", length=" + this.length + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.length);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Tag)) {
                return false;
            }
            Tag tag = (Tag)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)tag.text)) {
                return false;
            }
            return this.length == tag.length;
        }
    }
}

