/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.util;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.logcat.message.LogcatHeader;
import com.android.tools.idea.logcat.message.LogcatMessage;
import com.android.tools.idea.logcat.messages.DocumentAppenderKt;
import com.android.tools.idea.logcat.messages.FormattingOptions;
import com.android.tools.idea.logcat.util.FilterHint;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.project.Project;
import com.intellij.util.Processor;
import javax.swing.JScrollBar;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\u0001H\u0001\u001a\u0014\u0010\f\u001a\u00020\u000b*\u00020\u00012\u0006\u0010\r\u001a\u00020\u000bH\u0001\u00a8\u0006\u000e"}, d2={"createLogcatEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "project", "Lcom/intellij/openapi/project/Project;", "getFilterHint", "Lcom/android/tools/idea/logcat/util/FilterHint;", "offset", "", "formattingOptions", "Lcom/android/tools/idea/logcat/messages/FormattingOptions;", "isCaretAtBottom", "", "isScrollAtBottom", "useImmediatePosition", "intellij.android.logcat"})
public final class EditorUtilsKt {
    @NotNull
    public static final EditorEx createLogcatEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        EditorFactory editorFactory = EditorFactory.getInstance();
        Intrinsics.checkNotNull((Object)editorFactory, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorFactoryImpl");
        Document document2 = ((EditorFactoryImpl)editorFactory).createDocument(true);
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"editorFactory as EditorF\u2026mpl).createDocument(true)");
        Document document3 = document2;
        ((DocumentImpl)document3).setAcceptSlashR(true);
        UndoUtil.disableUndoFor((Document)document3);
        Editor editor = editorFactory.createViewer(document3, project, EditorKind.CONSOLE);
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        EditorEx editor2 = (EditorEx)editor;
        EditorSettings editorSettings = editor2.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"editor.settings");
        EditorSettings editorSettings2 = editorSettings;
        editorSettings2.setAllowSingleLogicalLineFolding(true);
        editorSettings2.setLineMarkerAreaShown(false);
        editorSettings2.setIndentGuidesShown(false);
        editorSettings2.setLineNumbersShown(false);
        editorSettings2.setFoldingOutlineShown(true);
        editorSettings2.setAdditionalPageAtBottom(false);
        editorSettings2.setAdditionalColumnsCount(0);
        editorSettings2.setAdditionalLinesCount(0);
        editorSettings2.setRightMarginShown(false);
        editorSettings2.setCaretRowShown(false);
        editorSettings2.setShowingSpecialChars(false);
        editor2.getGutterComponentEx().setPaintBackground(false);
        editor2.setColorsScheme((EditorColorsScheme)ConsoleViewUtil.updateConsoleColorScheme((EditorColorsScheme)editor2.getColorsScheme()));
        return editor2;
    }

    @UiThread
    public static final boolean isCaretAtBottom(@NotNull EditorEx $this$isCaretAtBottom) {
        Intrinsics.checkNotNullParameter((Object)$this$isCaretAtBottom, (String)"<this>");
        DocumentEx it = $this$isCaretAtBottom.getDocument();
        boolean bl = false;
        return it.getLineNumber($this$isCaretAtBottom.getCaretModel().getOffset()) >= it.getLineCount() - 1;
    }

    @UiThread
    public static final boolean isScrollAtBottom(@NotNull EditorEx $this$isScrollAtBottom, boolean useImmediatePosition) {
        Intrinsics.checkNotNullParameter((Object)$this$isScrollAtBottom, (String)"<this>");
        JScrollBar scrollBar = $this$isScrollAtBottom.getScrollPane().getVerticalScrollBar();
        int position = useImmediatePosition ? scrollBar.getValue() : $this$isScrollAtBottom.getScrollingModel().getVisibleAreaOnScrollingFinished().y;
        return scrollBar.getMaximum() - scrollBar.getVisibleAmount() == position;
    }

    @Nullable
    public static final FilterHint getFilterHint(@NotNull EditorEx $this$getFilterHint, int offset, @NotNull FormattingOptions formattingOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$getFilterHint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)formattingOptions, (String)"formattingOptions");
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        $this$getFilterHint.getDocument().processRangeMarkersOverlappingWith(offset, offset, new Processor(offset, (Ref.ObjectRef<FilterHint>)result2, formattingOptions){
            final /* synthetic */ int $offset;
            final /* synthetic */ Ref.ObjectRef<FilterHint> $result;
            final /* synthetic */ FormattingOptions $formattingOptions;
            {
                this.$offset = $offset;
                this.$result = $result;
                this.$formattingOptions = $formattingOptions;
            }

            public final boolean process(RangeMarker it) {
                Object object = (LogcatMessage)it.getUserData(DocumentAppenderKt.getLOGCAT_MESSAGE_KEY());
                if (object == null || (object = ((LogcatMessage)object).getHeader()) == null) {
                    return true;
                }
                Object header = object;
                int pos = this.$offset - it.getStartOffset();
                this.$result.element = this.$formattingOptions.getTagRange().isWithin((Comparable)Integer.valueOf(pos)) ? (FilterHint)new FilterHint.Tag(((LogcatHeader)header).getTag(), this.$formattingOptions.getTagFormat().width() - 1) : (this.$formattingOptions.getAppIdRange().isWithin((Comparable)Integer.valueOf(pos)) ? (FilterHint)new FilterHint.AppName(((LogcatHeader)header).getApplicationId(), this.$formattingOptions.getAppNameFormat().width() - 1) : (this.$formattingOptions.getLeveRange().isWithin((Comparable)Integer.valueOf(pos)) ? (FilterHint)new FilterHint.Level(((LogcatHeader)header).getLogLevel()) : null));
                return false;
            }
        });
        return (FilterHint)result2.element;
    }
}

