/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.messages;

import com.android.tools.idea.logcat.ConstantsKt;
import com.android.tools.idea.logcat.message.LogcatHeader;
import com.android.tools.idea.logcat.message.LogcatMessage;
import com.android.tools.idea.logcat.messages.FormattingOptions;
import com.android.tools.idea.logcat.messages.LogcatColors;
import com.android.tools.idea.logcat.messages.TextAccumulator;
import com.android.tools.idea.logcat.messages.WordWrapKt;
import java.time.ZoneId;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J5\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/logcat/messages/MessageFormatter;", "", "logcatColors", "Lcom/android/tools/idea/logcat/messages/LogcatColors;", "zoneId", "Ljava/time/ZoneId;", "(Lcom/android/tools/idea/logcat/messages/LogcatColors;Ljava/time/ZoneId;)V", "previousPid", "", "Ljava/lang/Integer;", "previousTag", "", "formatMessages", "", "formattingOptions", "Lcom/android/tools/idea/logcat/messages/FormattingOptions;", "textAccumulator", "Lcom/android/tools/idea/logcat/messages/TextAccumulator;", "messages", "", "Lcom/android/tools/idea/logcat/message/LogcatMessage;", "softWrapWidth", "(Lcom/android/tools/idea/logcat/messages/FormattingOptions;Lcom/android/tools/idea/logcat/messages/TextAccumulator;Ljava/util/List;Ljava/lang/Integer;)V", "intellij.android.logcat"})
public final class MessageFormatter {
    @NotNull
    private final LogcatColors logcatColors;
    @NotNull
    private final ZoneId zoneId;
    @Nullable
    private String previousTag;
    @Nullable
    private Integer previousPid;

    public MessageFormatter(@NotNull LogcatColors logcatColors, @NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)logcatColors, (String)"logcatColors");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        this.logcatColors = logcatColors;
        this.zoneId = zoneId;
    }

    public final void formatMessages(@NotNull FormattingOptions formattingOptions, @NotNull TextAccumulator textAccumulator, @NotNull List<LogcatMessage> messages, @Nullable Integer softWrapWidth) {
        Intrinsics.checkNotNullParameter((Object)formattingOptions, (String)"formattingOptions");
        Intrinsics.checkNotNullParameter((Object)textAccumulator, (String)"textAccumulator");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        int headerWidth = formattingOptions.getHeaderWidth();
        String newline = StringsKt.padEnd$default((String)"\n", (int)(headerWidth + 1), (char)'\u0000', (int)2, null);
        for (LogcatMessage message2 : messages) {
            if (message2.getHeader() == ConstantsKt.SYSTEM_HEADER) {
                TextAccumulator.accumulate$default(textAccumulator, message2.getMessage() + "\n", null, null, 6, null);
                continue;
            }
            int start2 = textAccumulator.getTextLength();
            LogcatHeader header = message2.getHeader();
            String tag = header.getTag();
            String appName = header.getAppName();
            TextAccumulator.accumulate$default(textAccumulator, formattingOptions.getTimestampFormat().format(header.getTimestamp(), this.zoneId), null, null, 6, null);
            TextAccumulator.accumulate$default(textAccumulator, formattingOptions.getProcessThreadFormat().format(header.getPid(), header.getTid()), null, null, 6, null);
            TextAccumulator.accumulate$default(textAccumulator, formattingOptions.getTagFormat().format(tag, this.previousTag), this.logcatColors.getTagColor$intellij_android_logcat(tag), null, 4, null);
            TextAccumulator.accumulate$default(textAccumulator, formattingOptions.getAppNameFormat().format(appName, header.getPid(), this.previousPid), null, null, 6, null);
            formattingOptions.getLevelFormat().format(header.getLogLevel(), textAccumulator, this.logcatColors);
            String messageText = softWrapWidth == null || softWrapWidth <= headerWidth ? message2.getMessage() : WordWrapKt.wordWrap(message2.getMessage(), softWrapWidth - headerWidth);
            TextAccumulator.accumulate$default(textAccumulator, StringsKt.replace$default((String)messageText, (String)"\n", (String)newline, (boolean)false, (int)4, null), null, this.logcatColors.getMessageKey$intellij_android_logcat(header.getLogLevel()), 2, null);
            TextAccumulator.accumulate$default(textAccumulator, "\n", null, null, 6, null);
            int end = textAccumulator.getTextLength();
            textAccumulator.addMessageRange(start2, end - 1, message2);
            this.previousTag = tag;
            this.previousPid = header.getPid();
        }
    }

    public static /* synthetic */ void formatMessages$default(MessageFormatter messageFormatter, FormattingOptions formattingOptions, TextAccumulator textAccumulator, List list2, Integer n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = null;
        }
        messageFormatter.formatMessages(formattingOptions, textAccumulator, list2, n);
    }
}

