/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.messages;

import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\b\b\u0080\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J%\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0018J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0014H\u00d6\u0001J\u0006\u0010\u001b\u001a\u00020\u0003R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/logcat/messages/AppNameFormat;", "", "maxLength", "", "hideDuplicates", "", "enabled", "(IZZ)V", "getEnabled", "()Z", "getHideDuplicates", "getMaxLength", "()I", "component1", "component2", "component3", "copy", "equals", "other", "format", "", "appName", "pid", "previousPid", "(Ljava/lang/String;ILjava/lang/Integer;)Ljava/lang/String;", "hashCode", "toString", "width", "intellij.android.logcat"})
public final class AppNameFormat {
    private final int maxLength;
    private final boolean hideDuplicates;
    private final boolean enabled;

    public AppNameFormat(int maxLength, boolean hideDuplicates, boolean enabled2) {
        boolean bl;
        this.maxLength = maxLength;
        this.hideDuplicates = hideDuplicates;
        this.enabled = enabled2;
        boolean bl2 = bl = this.maxLength >= 10;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public /* synthetic */ AppNameFormat(int n, boolean bl, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 35;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            bl2 = true;
        }
        this(n, bl, bl2);
    }

    public final int getMaxLength() {
        return this.maxLength;
    }

    public final boolean getHideDuplicates() {
        return this.hideDuplicates;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    @NotNull
    public final String format(@NotNull String appName, int pid, @Nullable Integer previousPid) {
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        if (!this.enabled) {
            return "";
        }
        if (this.hideDuplicates) {
            Integer n = previousPid;
            if (n != null && pid == n) {
                return StringsKt.padEnd$default((String)"", (int)(this.maxLength + 1), (char)'\u0000', (int)2, null);
            }
        }
        if (appName.length() > this.maxLength) {
            return StringUtil.shortenTextWithEllipsis((String)appName, (int)this.maxLength, (int)(this.maxLength - 6)) + " ";
        }
        return StringsKt.padEnd$default((String)appName, (int)(this.maxLength + 1), (char)'\u0000', (int)2, null);
    }

    public final int width() {
        return this.enabled ? this.maxLength + 1 : 0;
    }

    public final int component1() {
        return this.maxLength;
    }

    public final boolean component2() {
        return this.hideDuplicates;
    }

    public final boolean component3() {
        return this.enabled;
    }

    @NotNull
    public final AppNameFormat copy(int maxLength, boolean hideDuplicates, boolean enabled2) {
        return new AppNameFormat(maxLength, hideDuplicates, enabled2);
    }

    public static /* synthetic */ AppNameFormat copy$default(AppNameFormat appNameFormat, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = appNameFormat.maxLength;
        }
        if ((n2 & 2) != 0) {
            bl = appNameFormat.hideDuplicates;
        }
        if ((n2 & 4) != 0) {
            bl2 = appNameFormat.enabled;
        }
        return appNameFormat.copy(n, bl, bl2);
    }

    @NotNull
    public String toString() {
        return "AppNameFormat(maxLength=" + this.maxLength + ", hideDuplicates=" + this.hideDuplicates + ", enabled=" + this.enabled + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.maxLength);
        int n = this.hideDuplicates ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result2 = result2 * 31 + n;
        int n2 = this.enabled ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result2 = result2 * 31 + n2;
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AppNameFormat)) {
            return false;
        }
        AppNameFormat appNameFormat = (AppNameFormat)other;
        if (this.maxLength != appNameFormat.maxLength) {
            return false;
        }
        if (this.hideDuplicates != appNameFormat.hideDuplicates) {
            return false;
        }
        return this.enabled == appNameFormat.enabled;
    }

    public AppNameFormat() {
        this(0, false, false, 7, null);
    }
}

