/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.message;

import com.android.processmonitor.monitor.ProcessNameMonitor;
import com.android.processmonitor.monitor.ProcessNames;
import com.android.tools.idea.logcat.message.LogLevel;
import com.android.tools.idea.logcat.message.LogcatHeader;
import com.android.tools.idea.logcat.message.LogcatHeaderParserKt;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0013B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/logcat/message/LogcatHeaderParser;", "", "format", "Lcom/android/tools/idea/logcat/message/LogcatHeaderParser$LogcatFormat;", "processNameMonitor", "Lcom/android/processmonitor/monitor/ProcessNameMonitor;", "defaultYear", "", "defaultZoneId", "Ljava/time/ZoneId;", "(Lcom/android/tools/idea/logcat/message/LogcatHeaderParser$LogcatFormat;Lcom/android/processmonitor/monitor/ProcessNameMonitor;ILjava/time/ZoneId;)V", "parseHeader", "Lcom/android/tools/idea/logcat/message/LogcatHeader;", "line", "", "serialNumber", "parsePriority", "Lcom/android/tools/idea/logcat/message/LogLevel;", "string", "LogcatFormat", "intellij.android.logcat"})
public final class LogcatHeaderParser {
    @NotNull
    private final LogcatFormat format;
    @NotNull
    private final ProcessNameMonitor processNameMonitor;
    private final int defaultYear;
    @NotNull
    private final ZoneId defaultZoneId;

    public LogcatHeaderParser(@NotNull LogcatFormat format, @NotNull ProcessNameMonitor processNameMonitor, int defaultYear, @NotNull ZoneId defaultZoneId) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        Intrinsics.checkNotNullParameter((Object)processNameMonitor, (String)"processNameMonitor");
        Intrinsics.checkNotNullParameter((Object)defaultZoneId, (String)"defaultZoneId");
        this.format = format;
        this.processNameMonitor = processNameMonitor;
        this.defaultYear = defaultYear;
        this.defaultZoneId = defaultZoneId;
    }

    public /* synthetic */ LogcatHeaderParser(LogcatFormat logcatFormat, ProcessNameMonitor processNameMonitor, int n, ZoneId zoneId, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = ZonedDateTime.now().getYear();
        }
        if ((n2 & 8) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"systemDefault()");
            zoneId = zoneId2;
        }
        this(logcatFormat, processNameMonitor, n, zoneId);
    }

    @Nullable
    public final LogcatHeader parseHeader(@NotNull String line2, @NotNull String serialNumber) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)line2, (String)"line");
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        MatchResult matchResult = this.format.getRegex().matchEntire((CharSequence)line2);
        if (matchResult == null) {
            return null;
        }
        MatchResult result2 = matchResult;
        Instant timestamp = switch (WhenMappings.$EnumSwitchMapping$0[this.format.ordinal()]) {
            case 1 -> LogcatHeaderParserKt.access$getEpochTimestamp(result2);
            case 2 -> LogcatHeaderParserKt.access$getStandardTimestamp(result2, this.defaultYear, this.defaultZoneId);
            default -> throw new NoWhenBranchMatchedException();
        };
        MatchGroupCollection groups = result2.getGroups();
        MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)groups, (String)"pid");
        Intrinsics.checkNotNull((Object)matchGroup);
        int pid = LogcatHeaderParserKt.access$parsePid(matchGroup.getValue());
        ProcessNames processNames = this.processNameMonitor.getProcessNames(serialNumber, pid);
        if (pid == 0) {
            object = "kernel";
        } else {
            object = processNames;
            if (object == null || (object = object.getProcessName()) == null) {
                object = "pid-" + pid;
            }
        }
        String processName = object;
        MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)groups, (String)"priority");
        Intrinsics.checkNotNull((Object)matchGroup2);
        LogLevel logLevel = this.parsePriority(matchGroup2.getValue());
        MatchGroup matchGroup3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)groups, (String)"tid");
        Intrinsics.checkNotNull((Object)matchGroup3);
        int n = LogcatHeaderParserKt.access$parseThreadId(matchGroup3.getValue());
        Object object2 = processNames;
        if (object2 == null || (object2 = object2.getApplicationId()) == null) {
            object2 = processName;
        }
        MatchGroup matchGroup4 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)groups, (String)"tag");
        Intrinsics.checkNotNull((Object)matchGroup4);
        return new LogcatHeader(logLevel, pid, n, (String)object2, processName, matchGroup4.getValue(), timestamp);
    }

    private final LogLevel parsePriority(String string) {
        LogLevel priority = LogLevel.Companion.getByLetter(string);
        if (priority != null) {
            return priority;
        }
        if (!Intrinsics.areEqual((Object)string, (Object)"F")) {
            return LogLevel.WARN;
        }
        return LogLevel.ASSERT;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/logcat/message/LogcatHeaderParser$LogcatFormat;", "", "regex", "Lkotlin/text/Regex;", "(Ljava/lang/String;ILkotlin/text/Regex;)V", "getRegex", "()Lkotlin/text/Regex;", "EPOCH_FORMAT", "STANDARD_FORMAT", "intellij.android.logcat"})
    public static final class LogcatFormat
    extends Enum<LogcatFormat> {
        @NotNull
        private final Regex regex;
        public static final /* enum */ LogcatFormat EPOCH_FORMAT = new LogcatFormat(LogcatHeaderParserKt.access$getHEADER_EPOCH_REGEX$p());
        public static final /* enum */ LogcatFormat STANDARD_FORMAT = new LogcatFormat(LogcatHeaderParserKt.access$getHEADER_STANDARD_REGEX$p());
        private static final /* synthetic */ LogcatFormat[] $VALUES;

        private LogcatFormat(Regex regex) {
            this.regex = regex;
        }

        @NotNull
        public final Regex getRegex() {
            return this.regex;
        }

        public static LogcatFormat[] values() {
            return (LogcatFormat[])$VALUES.clone();
        }

        public static LogcatFormat valueOf(String value2) {
            return Enum.valueOf(LogcatFormat.class, value2);
        }

        static {
            $VALUES = logcatFormatArray = new LogcatFormat[]{LogcatFormat.EPOCH_FORMAT, LogcatFormat.STANDARD_FORMAT};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogcatFormat.values().length];
            try {
                nArray[LogcatFormat.EPOCH_FORMAT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogcatFormat.STANDARD_FORMAT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

