/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.message;

import com.android.tools.idea.logcat.message.LogLevel;
import com.android.tools.idea.logcat.message.LogcatHeaderKt;
import java.io.ObjectOutput;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\fH\u00c6\u0003JO\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010$\u001a\u00020\bJ\t\u0010%\u001a\u00020\u0005H\u00d6\u0001J\b\u0010&\u001a\u00020\bH\u0016J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006+"}, d2={"Lcom/android/tools/idea/logcat/message/LogcatHeader;", "", "logLevel", "Lcom/android/tools/idea/logcat/message/LogLevel;", "pid", "", "tid", "applicationId", "", "processName", "tag", "timestamp", "Ljava/time/Instant;", "(Lcom/android/tools/idea/logcat/message/LogLevel;IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/time/Instant;)V", "getApplicationId", "()Ljava/lang/String;", "getLogLevel", "()Lcom/android/tools/idea/logcat/message/LogLevel;", "getPid", "()I", "getProcessName", "getTag", "getTid", "getTimestamp", "()Ljava/time/Instant;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "getAppName", "hashCode", "toString", "writeExternal", "", "out", "Ljava/io/ObjectOutput;", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nLogcatHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogcatHeader.kt\ncom/android/tools/idea/logcat/message/LogcatHeader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class LogcatHeader {
    @NotNull
    private final LogLevel logLevel;
    private final int pid;
    private final int tid;
    @NotNull
    private final String applicationId;
    @NotNull
    private final String processName;
    @NotNull
    private final String tag;
    @NotNull
    private final Instant timestamp;

    public LogcatHeader(@NotNull LogLevel logLevel, int pid, int tid, @NotNull String applicationId2, @NotNull String processName, @NotNull String tag, @NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        Intrinsics.checkNotNullParameter((Object)applicationId2, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        this.logLevel = logLevel;
        this.pid = pid;
        this.tid = tid;
        this.applicationId = applicationId2;
        this.processName = processName;
        this.tag = tag;
        this.timestamp = timestamp;
    }

    @NotNull
    public final LogLevel getLogLevel() {
        return this.logLevel;
    }

    public final int getPid() {
        return this.pid;
    }

    public final int getTid() {
        return this.tid;
    }

    @NotNull
    public final String getApplicationId() {
        return this.applicationId;
    }

    @NotNull
    public final String getProcessName() {
        return this.processName;
    }

    @NotNull
    public final String getTag() {
        return this.tag;
    }

    @NotNull
    public final Instant getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public String toString() {
        String epoch = LogcatHeaderKt.access$getEpockTimeFormatter$p().format(this.timestamp);
        char priority = this.logLevel.getPriorityLetter();
        return epoch + ": " + priority + "/" + this.tag + "(" + this.pid + ":" + this.tid + ") " + this.applicationId + "/" + this.processName;
    }

    public final void writeExternal(@NotNull ObjectOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeInt(this.logLevel.ordinal());
        out.writeInt(this.pid);
        out.writeInt(this.tid);
        out.writeUTF(this.applicationId);
        out.writeUTF(this.processName);
        out.writeUTF(this.tag);
        out.writeLong(this.timestamp.toEpochMilli());
    }

    @NotNull
    public final String getAppName() {
        CharSequence charSequence;
        CharSequence charSequence2 = this.applicationId;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = this.processName;
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    @NotNull
    public final LogLevel component1() {
        return this.logLevel;
    }

    public final int component2() {
        return this.pid;
    }

    public final int component3() {
        return this.tid;
    }

    @NotNull
    public final String component4() {
        return this.applicationId;
    }

    @NotNull
    public final String component5() {
        return this.processName;
    }

    @NotNull
    public final String component6() {
        return this.tag;
    }

    @NotNull
    public final Instant component7() {
        return this.timestamp;
    }

    @NotNull
    public final LogcatHeader copy(@NotNull LogLevel logLevel, int pid, int tid, @NotNull String applicationId2, @NotNull String processName, @NotNull String tag, @NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        Intrinsics.checkNotNullParameter((Object)applicationId2, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        return new LogcatHeader(logLevel, pid, tid, applicationId2, processName, tag, timestamp);
    }

    public static /* synthetic */ LogcatHeader copy$default(LogcatHeader logcatHeader, LogLevel logLevel, int n, int n2, String string, String string2, String string3, Instant instant, int n3, Object object) {
        if ((n3 & 1) != 0) {
            logLevel = logcatHeader.logLevel;
        }
        if ((n3 & 2) != 0) {
            n = logcatHeader.pid;
        }
        if ((n3 & 4) != 0) {
            n2 = logcatHeader.tid;
        }
        if ((n3 & 8) != 0) {
            string = logcatHeader.applicationId;
        }
        if ((n3 & 0x10) != 0) {
            string2 = logcatHeader.processName;
        }
        if ((n3 & 0x20) != 0) {
            string3 = logcatHeader.tag;
        }
        if ((n3 & 0x40) != 0) {
            instant = logcatHeader.timestamp;
        }
        return logcatHeader.copy(logLevel, n, n2, string, string2, string3, instant);
    }

    public int hashCode() {
        int result2 = this.logLevel.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.pid);
        result2 = result2 * 31 + Integer.hashCode(this.tid);
        result2 = result2 * 31 + this.applicationId.hashCode();
        result2 = result2 * 31 + this.processName.hashCode();
        result2 = result2 * 31 + this.tag.hashCode();
        result2 = result2 * 31 + this.timestamp.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LogcatHeader)) {
            return false;
        }
        LogcatHeader logcatHeader = (LogcatHeader)other;
        if (this.logLevel != logcatHeader.logLevel) {
            return false;
        }
        if (this.pid != logcatHeader.pid) {
            return false;
        }
        if (this.tid != logcatHeader.tid) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.applicationId, (Object)logcatHeader.applicationId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.processName, (Object)logcatHeader.processName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tag, (Object)logcatHeader.tag)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.timestamp, (Object)logcatHeader.timestamp);
    }
}

