/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.hyperlinks;

import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.sources.SdkSourcePositionFinder;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\u0017\u001a\u00020\u00112\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00160\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\f\u0010\u0018\u001a\u00020\u0016*\u00020\u0016H\u0002J\u0014\u0010\u0019\u001a\u00020\b*\u00020\b2\u0006\u0010\u001a\u001a\u00020\u0006H\u0002R\u0016\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/logcat/hyperlinks/SdkSourceRedirectLinkInfo;", "Lcom/intellij/execution/filters/HyperlinkInfoBase;", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "descriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "apiLevel", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;I)V", "getApiLevel", "()I", "getFiles", "()Ljava/util/List;", "navigate", "", "hyperlinkLocationPoint", "Lcom/intellij/ui/awt/RelativePoint;", "openFile", "psiFile", "Lcom/intellij/psi/PsiFile;", "openFileChooser", "getAndroidSdkFile", "withFile", "newFile", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nSdkSourceRedirectLinkInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkSourceRedirectLinkInfo.kt\ncom/android/tools/idea/logcat/hyperlinks/SdkSourceRedirectLinkInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1603#2,9:102\n1851#2:111\n1852#2:113\n1612#2:114\n1#3:112\n*S KotlinDebug\n*F\n+ 1 SdkSourceRedirectLinkInfo.kt\ncom/android/tools/idea/logcat/hyperlinks/SdkSourceRedirectLinkInfo\n*L\n47#1:102,9\n47#1:111\n47#1:113\n47#1:114\n47#1:112\n*E\n"})
public final class SdkSourceRedirectLinkInfo
extends HyperlinkInfoBase {
    @NotNull
    private final Project project;
    @VisibleForTesting
    @NotNull
    private final List<VirtualFile> files;
    @NotNull
    private final OpenFileDescriptor descriptor;
    @VisibleForTesting
    private final int apiLevel;

    public SdkSourceRedirectLinkInfo(@NotNull Project project, @NotNull List<? extends VirtualFile> files2, @NotNull OpenFileDescriptor descriptor2, int apiLevel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        this.project = project;
        this.files = files2;
        this.descriptor = descriptor2;
        this.apiLevel = apiLevel;
    }

    @NotNull
    public final List<VirtualFile> getFiles() {
        return this.files;
    }

    public final int getApiLevel() {
        return this.apiLevel;
    }

    /*
     * WARNING - void declaration
     */
    public void navigate(@NotNull Project project, @Nullable RelativePoint hyperlinkLocationPoint) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(project)");
        PsiManager psiManager2 = psiManager;
        Iterable $this$mapNotNull$iv = this.files;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PsiFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if (psiManager2.findFile(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List psiFiles = (List)destination$iv$iv;
        switch (psiFiles.size()) {
            case 0: {
                return;
            }
            case 1: {
                Object object = CollectionsKt.first((List)psiFiles);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"psiFiles.first()");
                this.openFile((PsiFile)object, this.descriptor);
                break;
            }
            default: {
                this.openFileChooser(psiFiles, this.descriptor, hyperlinkLocationPoint);
            }
        }
    }

    private final void openFileChooser(List<? extends PsiFile> files2, OpenFileDescriptor descriptor2, RelativePoint hyperlinkLocationPoint) {
        JFrame frame = WindowManager.getInstance().getFrame(this.project);
        Serializable serializable = frame;
        int width = serializable != null && (serializable = serializable.getSize()) != null ? ((Dimension)serializable).width : 200;
        JBPopup jBPopup = JBPopupFactory.getInstance().createPopupChooserBuilder(files2).setRenderer((ListCellRenderer)new GotoFileCellRenderer(width)).setTitle(ExecutionBundle.message((String)"popup.title.choose.target.file", (Object[])new Object[0])).setItemChosenCallback(new Consumer(this, descriptor2){
            final /* synthetic */ SdkSourceRedirectLinkInfo this$0;
            final /* synthetic */ OpenFileDescriptor $descriptor;
            {
                this.this$0 = $receiver;
                this.$descriptor = $descriptor;
            }

            public final void consume(@NotNull PsiFile file2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                VirtualFile virtualFile = file2.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file.virtualFile");
                SdkSourceRedirectLinkInfo.access$openFile(this.this$0, file2, SdkSourceRedirectLinkInfo.access$withFile(this.this$0, this.$descriptor, virtualFile));
            }
        }).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"private fun openFileChoo\u2026InFocusCenter()\n    }\n  }");
        JBPopup popup2 = jBPopup;
        if (hyperlinkLocationPoint != null) {
            popup2.show(hyperlinkLocationPoint);
        } else {
            popup2.showInFocusCenter();
        }
    }

    private final void openFile(PsiFile psiFile, OpenFileDescriptor descriptor2) {
        OpenFileDescriptor openFileDescriptor;
        AndroidSdks androidSdks = AndroidSdks.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)androidSdks, (String)"getInstance()");
        AndroidSdks androidSdks2 = androidSdks;
        if (androidSdks2.isInAndroidSdk((PsiElement)psiFile)) {
            VirtualFile virtualFile = this.getAndroidSdkFile(psiFile).getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"psiFile.getAndroidSdkFile().virtualFile");
            openFileDescriptor = this.withFile(descriptor2, virtualFile);
        } else {
            openFileDescriptor = descriptor2;
        }
        OpenFileDescriptor newDescriptor = openFileDescriptor;
        newDescriptor.navigate(true);
    }

    private final PsiFile getAndroidSdkFile(PsiFile $this$getAndroidSdkFile) {
        Project project = $this$getAndroidSdkFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        PsiFile psiFile = SdkSourcePositionFinder.Companion.getInstance(project).getSourcePosition(this.apiLevel, $this$getAndroidSdkFile, -1).getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"SdkSourcePositionFinder.\u2026is, lineNumber = -1).file");
        return psiFile;
    }

    private final OpenFileDescriptor withFile(OpenFileDescriptor $this$withFile, VirtualFile newFile2) {
        return $this$withFile.getLine() >= 0 ? new OpenFileDescriptor($this$withFile.getProject(), newFile2, $this$withFile.getLine(), $this$withFile.getColumn()) : new OpenFileDescriptor($this$withFile.getProject(), newFile2, $this$withFile.getOffset());
    }

    public static final /* synthetic */ void access$openFile(SdkSourceRedirectLinkInfo $this, PsiFile psiFile, OpenFileDescriptor descriptor2) {
        $this.openFile(psiFile, descriptor2);
    }

    public static final /* synthetic */ OpenFileDescriptor access$withFile(SdkSourceRedirectLinkInfo $this, OpenFileDescriptor $receiver, VirtualFile newFile2) {
        return $this.withFile($receiver, newFile2);
    }
}

